/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.ide.Version;
import oracle.ide.util.Assert;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class AddinPolicyUtils {
    private static final String POLICY_VIOLATION = "Addin Policy Violation!";
    private static final String CREATING_IMAGE_ICON_POLICY_CHECK_ID = "CREATING_IMAGE_ICON_POLICY_CHECK";
    private static final String CREATING_THREAD_POLICY_CHECK_ID = "CREATING_THREAD_POLICY_CHECK";
    private static final String CREATING_WORKSPACE_ACCESS_CHECK_ID = "CREATING_WORKSPACE_ACCESS_CHECK";
    @CodeSharingSafe(value="StaticField")
    private static Object[] m_ExceptionList = new Object[]{"AppOverviewAddin", "CREATING_WORKSPACE_ACCESS_CHECK", "ADEAddin", "CREATING_WORKSPACE_ACCESS_CHECK"};
    private static final Object ERROR_REPORTED = new Object();
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap m_CommandIDNStackTracePairToJMenuItem = new ConcurrentHashMap();
    private static final boolean OVERRIDE_FLAG = Boolean.getBoolean("oracle.ide.util.AddinPolicyUtils.OVERRIDE_FLAG");
    private static boolean m_WarnWhenCreatingImageIcons = false;
    private static boolean m_WarnWhenCreatingThreads = false;
    private static boolean m_WarnWhenLeakingJMenuItems = true;

    public static void initializingAddins(boolean initializing) {
        if (Version.DEBUG_BUILD != 0) {
            if (!initializing) {
                Assert.check(m_WarnWhenCreatingImageIcons, "Someone is calling setWarnWhenCreatingImageIcons(false) and not restoring its previous value.");
                Assert.check(m_WarnWhenCreatingThreads, "Someone is calling setWarnWhenCreatingThreads(false) and not restoring its previous value.");
            }
            AddinPolicyUtils.setWarnWhenCreatingImageIcons(initializing);
            AddinPolicyUtils.setWarnWhenCreatingThreads(initializing);
        }
    }

    public static void creatingImageIconPolicyCheck() {
        if (Version.DEBUG_BUILD != 0 && !OVERRIDE_FLAG && m_WarnWhenCreatingImageIcons) {
            AddinPolicyUtils.printInitializationViolationMessage("An addin is loading an image at initialize time", CREATING_IMAGE_ICON_POLICY_CHECK_ID);
        }
    }

    public static void creatingThreadPolicyCheck() {
        String stackTrace;
        if (Version.DEBUG_BUILD != 0 && !OVERRIDE_FLAG && m_WarnWhenCreatingThreads && (stackTrace = AddinPolicyUtils.getStackTrace(new Exception())).indexOf("java.awt.EventQueue.initDispatchThread") == -1 && stackTrace.indexOf("sun.awt.AWTAutoShutdown.activateBlockerThread") == -1 && stackTrace.indexOf("java.util.logging.LogManager.<clinit>") == -1 && stackTrace.indexOf("java.lang.UNIXProcess.<init>") == -1) {
            AddinPolicyUtils.printInitializationViolationMessage("An addin is creating a new Thread at initialize time", CREATING_THREAD_POLICY_CHECK_ID);
        }
    }

    public static void creatingAbstractButtonLeakPolicyCheck(AbstractButton abstractButton) {
        if (Version.DEBUG_BUILD == 0 || !OVERRIDE_FLAG) {
            // empty if block
        }
    }

    public static void creatingLocalActionLeakPolicyCheck(Action action) {
        if (Version.DEBUG_BUILD == 0 || !OVERRIDE_FLAG) {
            // empty if block
        }
    }

    public static void creatingJMenuItemLeakPolicyCheck(JMenuItem menuItem, int commandID) {
        if (Version.DEBUG_BUILD != 0 && !OVERRIDE_FLAG && m_WarnWhenLeakingJMenuItems) {
            CommandIDNStackTracePair key = new CommandIDNStackTracePair(commandID);
            Object value = m_CommandIDNStackTracePairToJMenuItem.get(key);
            if (value != null) {
                if (value == ERROR_REPORTED) {
                    return;
                }
                value = ((WeakReference)value).get();
            }
            if (value != null && ((AbstractButton)value).getAction() != null) {
                m_CommandIDNStackTracePairToJMenuItem.put(key, ERROR_REPORTED);
                String addInClassName = AddinPolicyUtils.getAddInClassName(key.m_StackTrace);
                if ("oracle.bm.addinUtil.ModelAddin".equals(addInClassName)) {
                    return;
                }
                System.err.println(POLICY_VIOLATION);
                System.err.print(key.m_StackTrace);
                return;
            }
            m_CommandIDNStackTracePairToJMenuItem.put(key, new WeakReference<JMenuItem>(menuItem));
        }
    }

    public static boolean setWarnWhenCreatingThreads(boolean warn) {
        boolean wasWarnWhenCreatingThreads = m_WarnWhenCreatingThreads;
        m_WarnWhenCreatingThreads = warn;
        return wasWarnWhenCreatingThreads;
    }

    public static boolean setWarnWhenCreatingImageIcons(boolean warn) {
        boolean wasWarnWhenCreatingImageIcons = m_WarnWhenCreatingImageIcons;
        m_WarnWhenCreatingImageIcons = warn;
        return wasWarnWhenCreatingImageIcons;
    }

    public static boolean setWarnWhenLeakingJMenuItems(boolean warn) {
        boolean wasWarnWhenLeakingJMenuItems = m_WarnWhenLeakingJMenuItems;
        m_WarnWhenLeakingJMenuItems = warn;
        return wasWarnWhenLeakingJMenuItems;
    }

    public static void runRunnable(Runnable runnable) {
        if (Version.DEBUG_BUILD != 0) {
            runnable.run();
        }
    }

    public static void applicationExiting() {
        if (Version.DEBUG_BUILD != 0) {
            // empty if block
        }
    }

    public static void checkCallStackForPolicyViolation(String violationMethod, String method) {
        String stackTrace;
        if (Version.DEBUG_BUILD != 0 && !OVERRIDE_FLAG && (stackTrace = AddinPolicyUtils.getStackTrace(new Exception())).indexOf(violationMethod) != -1) {
            System.err.println(POLICY_VIOLATION);
            System.err.println(method + " called directly or indirectly from " + violationMethod);
            System.err.print(stackTrace);
        }
    }

    public static void ensureGarbageCollectable(Object obj) {
        if (Version.DEBUG_BUILD != 0) {
            AddinPolicyUtils.ensureGarbageCollectable(obj, 10);
        }
    }

    public static void ensureGarbageCollectable(Object obj, int seconds) {
        if (Version.DEBUG_BUILD != 0) {
            Thread t = new Thread((Runnable)new MemoryLeakChecker(seconds, obj), "Leak detector for " + obj);
            t.setDaemon(true);
            t.start();
        }
    }

    public static void printWorkSpaceAccessDuringInitializationWarning() {
        if (Version.DEBUG_BUILD != 0) {
            String stackTrace = AddinPolicyUtils.getStackTrace(new Exception("An addin is invoking WorkSpaces.getChildren() during initialization"));
            if (m_ExceptionList.length > 0) {
                String addInClassName = AddinPolicyUtils.getAddInClassName2(stackTrace);
                if (addInClassName == null) {
                    addInClassName = AddinPolicyUtils.getAddInClassName(stackTrace);
                }
                if (addInClassName != null) {
                    for (int i = 0; i < m_ExceptionList.length; i += 2) {
                        if (!addInClassName.equals(m_ExceptionList[i]) || CREATING_WORKSPACE_ACCESS_CHECK_ID != m_ExceptionList[i + 1]) continue;
                        return;
                    }
                    System.err.println(POLICY_VIOLATION);
                    System.err.println("Addin " + addInClassName + " is accessing the Workspace during initialization");
                }
            }
        }
    }

    private AddinPolicyUtils() {
    }

    private static String getStackTrace(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter(charArrayWriter));
        String result = charArrayWriter.toString();
        charArrayWriter.close();
        return result;
    }

    private static String getAddInClassName(String stackTrace) {
        String addInName = null;
        StringTokenizer stringTokenizer = new StringTokenizer(stackTrace, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int atSpaceIndex;
            String token = stringTokenizer.nextToken();
            int initializeIndex = token.indexOf(".initialize");
            if (initializeIndex == -1) continue;
            if (!stringTokenizer.hasMoreTokens() || stringTokenizer.nextToken().indexOf("oracle.ide.AddinManager.initializeAddin") == -1 || (atSpaceIndex = token.indexOf("at ")) == -1) break;
            addInName = token.substring(atSpaceIndex + 3, initializeIndex);
            break;
        }
        return addInName;
    }

    private static String getAddInClassName2(String stackTrace) {
        String addInName = null;
        StringTokenizer stringTokenizer = new StringTokenizer(stackTrace, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            int initializeIndex = token.indexOf(".initialize");
            if (initializeIndex == -1) continue;
            String upToInitialize = token.substring(0, initializeIndex - 1);
            int dotIndex = upToInitialize.lastIndexOf(".");
            addInName = token.substring(dotIndex + 1, initializeIndex);
            break;
        }
        return addInName;
    }

    private static void printInitializationViolationMessage(String message, String POLICY_CHECK_ID) {
        String stackTrace = AddinPolicyUtils.getStackTrace(new Exception(message));
        if (m_ExceptionList.length > 0) {
            String addInClassName = AddinPolicyUtils.getAddInClassName(stackTrace);
            if (addInClassName != null) {
                for (int i = 0; i < m_ExceptionList.length; i += 2) {
                    if (!addInClassName.equals(m_ExceptionList[i]) || POLICY_CHECK_ID != m_ExceptionList[i + 1]) continue;
                    return;
                }
            } else {
                return;
            }
        }
        System.err.println(POLICY_VIOLATION);
        System.err.print(stackTrace);
    }

    private static class CommandIDNStackTracePair {
        public final int m_CommandID;
        public final String m_StackTrace;

        public CommandIDNStackTracePair(int commandID) {
            this.m_CommandID = commandID;
            this.m_StackTrace = AddinPolicyUtils.getStackTrace(new Exception("A memory leak is occurring since a temporary AbstractButton (JMenuItem or JButton usually) was created and the action was not set to null."));
        }

        public boolean equals(Object anObject) {
            if (anObject instanceof CommandIDNStackTracePair) {
                CommandIDNStackTracePair cmpElem = (CommandIDNStackTracePair)anObject;
                return this.m_CommandID == cmpElem.m_CommandID && this.m_StackTrace.equals(cmpElem.m_StackTrace);
            }
            return false;
        }

        public int hashCode() {
            return this.m_StackTrace.hashCode() + this.m_CommandID;
        }
    }

    private static class MemoryLeakChecker
    implements Runnable {
        private final int _numSeconds;
        private final WeakReference _ref;
        private final String _objToString;

        @Override
        public void run() {
            for (int i = 1; i < this._numSeconds; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object got = this._ref.get();
                if (got == null) {
                    Assert.println("No memory leak: " + this._objToString);
                    return;
                }
                got = null;
                System.gc();
            }
            Assert.println("\nThe object " + this._objToString + " is still in memory after " + this._numSeconds + " seconds.  This means a memory leak has probably occured.  False positives are possible.\n");
        }

        private MemoryLeakChecker(int numSeconds, Object o) {
            this._numSeconds = numSeconds;
            this._objToString = o.toString();
            this._ref = new WeakReference<Object>(o);
        }
    }
}

