/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.ojc.interfaces.Storage;

public class URLFileSystemStorage
implements Storage {
    private URL url;
    private InputStream in;
    private OutputStream out;
    private HashMap properties;
    private boolean isDirectory;

    public URLFileSystemStorage(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null argument");
        }
        this.url = url;
        this.isDirectory = URLFileSystem.isDirectory(url);
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public String getName() {
        return URLFileSystem.getFileName(this.url);
    }

    @Override
    public String getPath() {
        return URLFileSystem.getPlatformPathName(this.url);
    }

    @Override
    public String getCanonicalPath() {
        URL canonical = URLFileSystem.canonicalize(this.url);
        if (canonical != null) {
            return URLFileSystem.getPath(canonical);
        }
        return this.getPath();
    }

    @Override
    public long modDate() {
        return URLFileSystem.lastModified(this.url);
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isInJar() {
        return JarUtil.isJarURL(this.url);
    }

    @Override
    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    @Override
    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    @Override
    public int size() {
        return this.isDirectory ? 0 : (int)URLFileSystem.getLength(this.url);
    }

    @Override
    public byte[] read() throws IOException {
        int count;
        int nread;
        if (this.isDirectory) {
            return new byte[0];
        }
        assert (this.out == null);
        if (this.in == null) {
            this.in = URLFileSystem.openInputStream(this.url);
        }
        int avail = this.in.available();
        byte[] buf = new byte[avail];
        for (count = 0; count < avail && (nread = this.in.read(buf, count, avail)) >= 0; count += nread) {
        }
        if (avail != count) {
            throw new IOException("incomplete read");
        }
        return buf;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int avail;
        int nbytes;
        int nread;
        if (this.isDirectory) {
            return 0;
        }
        assert (this.out == null);
        if (this.in == null) {
            this.in = URLFileSystem.openInputStream(this.url);
        }
        if ((nread = this.in.read(buf, 0, nbytes = (avail = this.in.available()) < buf.length ? avail : buf.length)) != nbytes) {
            throw new IOException("incomplete read");
        }
        return nread;
    }

    @Override
    public void write(byte[] buf, int start, int len) throws IOException {
        if (!this.isDirectory) {
            assert (this.in == null);
            if (this.out == null) {
                this.out = URLFileSystem.openOutputStream(this.url);
            }
            this.out.write(buf, start, len);
        }
    }

    @Override
    public String[] list() {
        URL[] urls;
        if (this.isDirectory && (urls = URLFileSystem.list(this.url)) != null && urls.length > 0) {
            String[] names = new String[urls.length];
            for (int x = 0; x < urls.length; ++x) {
                names[x] = URLFileSystem.getPath(urls[x]);
            }
            return names;
        }
        return new String[0];
    }

    @Override
    public ArrayList listStorage() {
        URL[] urls;
        ArrayList<URLFileSystemStorage> list = new ArrayList<URLFileSystemStorage>();
        if (this.isDirectory && (urls = URLFileSystem.list(this.url)) != null && urls.length > 0) {
            for (int x = 0; x < urls.length; ++x) {
                list.add(new URLFileSystemStorage(urls[x]));
            }
        }
        return list;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public Storage open(String name) {
        if (!this.isDirectory) {
            return null;
        }
        final String finalName = name.endsWith("/") ? name.substring(0, name.length() - 1) : name;
        URL[] urls = URLFileSystem.list(this.url, new URLFilenameFilter(){

            @Override
            public boolean accept(URL url, String name) {
                return name.equals(finalName);
            }
        });
        return urls != null && urls.length > 0 ? new URLFileSystemStorage(urls[0]) : null;
    }

    @Override
    public Storage create(String name) {
        if (this.isDirectory) {
            URL newURL = URLFactory.newURL(this.url, name);
            return newURL != null ? new URLFileSystemStorage(newURL) : null;
        }
        return null;
    }

    @Override
    public Storage createDir(String name) {
        if (this.isDirectory) {
            URL newURL = URLFactory.newDirURL(this.url, name);
            URLFileSystem.mkdir(newURL);
            return newURL != null ? new URLFileSystemStorage(newURL) : null;
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

