/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;
import oracle.ide.net.CodeSourceURLFileSystemHelper;
import oracle.ide.net.FileURLFileSystemHelper;
import oracle.ide.net.HttpURLFileSystemHelper;
import oracle.ide.net.IdeDisplayURLFileSystemHelper;
import oracle.ide.net.IdeURLFileSystemHelper;
import oracle.ide.net.JarURLFileSystemHelper;
import oracle.ide.net.JarUtil;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLExistsTest;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFileSystemRootProvider;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLKey;
import oracle.ide.net.ZipURLFileSystemHelper;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.MultiLock;
import oracle.javatools.util.Log;
import oracle.javatools.util.PlatformUtils;

public final class URLFileSystem {
    private static final Map<String, URLFileSystemHelper> _helpers = new HashMap<String, URLFileSystemHelper>();
    private static final Collection<URLFileSystemRootProvider> _rootProviders = Collections.synchronizedList(new ArrayList());
    private static final URLFileSystemHelper _defaultHelper = new URLFileSystemHelper();
    private static final List<URLExistsTest> _existsTests = new ArrayList<URLExistsTest>(3);
    private static final URL[] NO_URLS = new URL[0];
    private static StreamHandlerFactoryQueue s_streamHandlerFactoryQueue;
    private static final Log LOG_READONLY;
    private static final Map<URLKey, URLFileSystemListener> _rootURLToFrontListenerMap;
    private static final Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> _rootURLToListenerMap;
    private static final CopyOnWriteArrayList<URLFileSystemListener> _unscopedListenerList;
    private static boolean TRACE_DANGLING_STREAMS;
    private static Set<URL> _seenMalformedDirURLs;

    private URLFileSystem() {
    }

    public static void registerHelper(String protocol, URLFileSystemHelper helper) {
        if (protocol != null && protocol.length() > 0 && helper != null) {
            _helpers.put(protocol, helper);
            if (ProtocolConstants.isIdeProtocol(protocol)) {
                ProtocolConstants.addIdeProtocol(protocol);
            }
        }
    }

    public static URLFileSystemHelper findHelper(String protocol) {
        URLFileSystemHelper helper = _helpers.get(protocol);
        if (helper == null && ProtocolConstants.isIdeProtocol(protocol)) {
            String head;
            int index = protocol.lastIndexOf(".");
            while (index > 0 && (helper = _helpers.get(head = protocol.substring(0, index))) == null) {
                protocol = head;
                index = protocol.lastIndexOf(".");
            }
        }
        return helper != null ? helper : _defaultHelper;
    }

    public static URLFileSystemHelper findHelper(URL url) {
        String protocol;
        URLFileSystemHelper helper;
        if (url != null && (helper = URLFileSystem.findHelper(protocol = url.getProtocol())) != null) {
            return helper;
        }
        return _defaultHelper;
    }

    public static void addExistsTest(URLExistsTest existsTest) {
        if (existsTest != null) {
            _existsTests.add(existsTest);
        }
    }

    public static void addRootProvider(URLFileSystemRootProvider provider) {
        _rootProviders.add(provider);
    }

    @Deprecated
    public static void addURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        URLStreamHandlerFactoryQueue.addFactory(factory);
    }

    public static void addURLStreamHandlerFactory(String protocol, URLStreamHandlerFactory factory) {
        if (s_streamHandlerFactoryQueue == null) {
            if (!protocol.startsWith("ide.")) {
                URLStreamHandlerFactoryQueue.addFactory(protocol, factory);
            }
        } else {
            s_streamHandlerFactoryQueue.addFactory(protocol, factory);
        }
    }

    public static void setURLStreamHandlerFactoryQueue(StreamHandlerFactoryQueue shFactoryQueue) {
        s_streamHandlerFactoryQueue = shFactoryQueue;
    }

    public static URL canonicalize(URL url) {
        return URLFileSystem.findHelper(url).canonicalize(url);
    }

    public static boolean canRead(URL url) {
        return URLFileSystem.findHelper(url).canRead(url);
    }

    public static boolean canWrite(URL url) {
        return URLFileSystem.findHelper(url).canWrite(url);
    }

    public static boolean canCreate(URL url) {
        return URLFileSystem.findHelper(url).canCreate(url);
    }

    public static boolean canDelete(URL url) {
        return URLFileSystem.findHelper(url).canDelete(url);
    }

    public static boolean isValid(URL url) {
        return URLFileSystem.findHelper(url).isValid(url);
    }

    public static URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        return URLFileSystem.findHelper(url).convertSuffix(url, oldSuffix, newSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL src, URL dst) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        MultiLock lock = null;
        if (JarUtil.isJarURL(src) || JarUtil.isJarURL(dst) || JarUtil.isArchive(URLFileSystem.getPath(src)) || JarUtil.isArchive(URLFileSystem.getPath(dst))) {
            lock = MultiLock.getCopyLock(JarUtil.getLock(src), JarUtil.getLock(dst));
            lock.lock();
        }
        try {
            in = URLFileSystem.openInputStream(src);
            out = URLFileSystem.openOutputStream(dst);
            if (!URLFileSystem.mkdirs(URLFileSystem.getParent(dst))) {
                throw new IOException();
            }
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, URL dst) throws IOException {
        OutputStream out = null;
        try {
            out = URLFileSystem.openOutputStream(dst);
            URLFileSystem.mkdirs(URLFileSystem.getParent(dst));
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL src, File dst) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        MultiLock lock = null;
        if (JarUtil.isJarURL(src) || JarUtil.isArchive(URLFileSystem.getPath(src)) || JarUtil.isArchive(dst.getPath())) {
            lock = MultiLock.getCopyLock(JarUtil.getLock(src), JarUtil.getLock(URLFactory.newFileURL(dst)));
            lock.lock();
        }
        try {
            in = URLFileSystem.openInputStream(src);
            File parentDir = dst.getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            out = new FileOutputStream(dst);
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static boolean delete(URL url) {
        try {
            URLFileSystem.deleteEx(url);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void deleteEx(URL url) throws IOException {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        Integer notifyType = null;
        if (URLFileSystem.hasListener(url)) {
            if (helper.isRegularFile(url)) {
                notifyType = 3;
            } else if (helper.isDirectory(url)) {
                notifyType = 11;
            }
        }
        helper.delete(url);
        if (notifyType != null) {
            URLFileSystem.fireURLFileSystemEvent(url, notifyType);
        }
    }

    public static URL ensureSuffix(URL url, String suffix) {
        return URLFileSystem.findHelper(url).ensureSuffix(url, suffix);
    }

    public static boolean equals(URL url1, URL url2) {
        if (url1 == url2) {
            return true;
        }
        if (!URLFileSystem.protocolsAreEqual(url1, url2)) {
            return false;
        }
        return URLFileSystem.findHelper(url1).equals(url1, url2);
    }

    public static int hashCode(URL url) {
        if (url == null) {
            return 0;
        }
        return url.getProtocol().hashCode() * 37 + URLFileSystem.findHelper(url).hashCode(url);
    }

    public static boolean exists(URL url) {
        return URLFileSystem.findHelper(url).exists(url);
    }

    public static Icon getDefaultIcon(URL url) {
        return URLFileSystem.findHelper(url).getDefaultIcon(url);
    }

    public static String getFileName(URL url) {
        return URLFileSystem.findHelper(url).getFileName(url);
    }

    public static long getLength(URL url) {
        return URLFileSystem.findHelper(url).getLength(url);
    }

    public static String getName(URL url) {
        return URLFileSystem.findHelper(url).getName(url);
    }

    public static URL getParent(URL url) {
        return URLFileSystem.findHelper(url).getParent(url);
    }

    public static String getPath(URL url) {
        return URLFileSystem.findHelper(url).getPath(url);
    }

    public static String getPathNoExt(URL url) {
        return URLFileSystem.findHelper(url).getPathNoExt(url);
    }

    public static String getPlatformPathName(URL url) {
        return URLFileSystem.findHelper(url).getPlatformPathName(url);
    }

    public static String getSuffix(URL url) {
        return URLFileSystem.findHelper(url).getSuffix(url);
    }

    public static String getSystemDisplayName(URL url) {
        return URLFileSystem.findHelper(url).getSystemDisplayName(url);
    }

    public static Icon getSystemIcon(URL url) {
        return URLFileSystem.findHelper(url).getSystemIcon(url);
    }

    public static boolean hasSuffix(URL url, String suffix) {
        return URLFileSystem.findHelper(url).hasSuffix(url, suffix);
    }

    public static boolean hasSuffix(URL url, String[] suffixes) {
        URLFileSystemHelper urlFileSystemHelper = URLFileSystem.findHelper(url);
        for (String suffix : suffixes) {
            if (!urlFileSystemHelper.hasSuffix(url, suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBaseURLFor(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        if (url1 == url2) {
            return true;
        }
        if (!URLFileSystem.protocolsAreEqual(url1, url2)) {
            return false;
        }
        return URLFileSystem.findHelper(url1).isBaseURLFor(url1, url2);
    }

    public static boolean isBound(URL url) {
        for (URLExistsTest test : _existsTests) {
            if (!test.urlExists(url)) continue;
            return true;
        }
        return URLFileSystem.exists(url);
    }

    public static boolean isLocal(URL url) {
        return URLFileSystem.findHelper(url).isLocal(url);
    }

    public static boolean isLocalFileSystemCaseSensitive() {
        return PlatformUtils.isCaseSensitiveFileSystem();
    }

    public static boolean isDirectory(URL url) {
        return URLFileSystem.findHelper(url).isDirectory(url);
    }

    public static boolean isDirectoryPath(URL url) {
        return URLFileSystem.findHelper(url).isDirectoryPath(url);
    }

    public static boolean isHidden(URL url) {
        return URLFileSystem.findHelper(url).isHidden(url);
    }

    public static boolean isReadOnly(URL url) {
        return URLFileSystem.findHelper(url).isReadOnly(url);
    }

    public static boolean isRegularFile(URL url) {
        return URLFileSystem.findHelper(url).isRegularFile(url);
    }

    public static boolean isRoot(URL url) {
        if (url == null) {
            return false;
        }
        for (URL root : URLFileSystem.listRoots()) {
            if (!URLFileSystem.equals(url, root)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] listRoots() {
        ArrayList<URLFileSystemRootProvider> providers;
        ArrayList<URL> roots = new ArrayList<URL>();
        Collection<URLFileSystemRootProvider> collection = _rootProviders;
        synchronized (collection) {
            providers = new ArrayList<URLFileSystemRootProvider>(_rootProviders);
        }
        for (URLFileSystemRootProvider provider : providers) {
            URL[] r = provider.getRoots();
            if (r == null) continue;
            roots.addAll(Arrays.asList(r));
        }
        return roots.toArray(new URL[roots.size()]);
    }

    public static long lastModified(URL url) {
        return URLFileSystem.findHelper(url).lastModified(url);
    }

    public static URL[] list(URL url) {
        return URLFileSystem.findHelper(url).list(url);
    }

    public static URL[] list(URL url, URLFilter filter) {
        return URLFileSystem.findHelper(url).list(url, filter);
    }

    public static URL[] list(URL url, URLFilenameFilter filter) {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).list(url, filter);
    }

    public static FileInfo[] ls(URL url) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).ls(url);
    }

    public static FileInfo[] ls(URL url, URLFilter filter) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).ls(url, filter);
    }

    public static FileInfo[] lsCached(URL url) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).lsCached(url);
    }

    public static FileInfo[] lsCached(URL url, URLFilter filter) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).lsCached(url, filter);
    }

    public static boolean mkdir(URL url) {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url = URLFileSystem.assertIsDirURL(url));
        boolean success = helper.mkdir(url);
        if (success) {
            URLFileSystem.fireURLFileSystemEvent(url, 10);
        }
        return success;
    }

    public static boolean mkdirs(URL url) {
        if (URLFileSystem.isDirectory(url = URLFileSystem.assertIsDirURL(url))) {
            return true;
        }
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        URL rootURL = URLFileSystem.getTrackedRootURL(url);
        boolean notify = !_unscopedListenerList.isEmpty() || rootURL != null;
        List<URL> nonexistentParents = notify ? URLFileSystem.getNonExistentParents(rootURL, url) : Collections.emptyList();
        boolean success = helper.mkdirs(url);
        URLFileSystem.notifyNonexistentParents(nonexistentParents);
        if (success) {
            URLFileSystem.fireURLFileSystemEvent(url, 10);
        }
        return success;
    }

    public static URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return directory != null ? URLFileSystem.findHelper(directory).createTempFile(prefix, suffix, directory) : URLFileSystem.findHelper("file").createTempFile(prefix, suffix, null);
    }

    public static InputStream openInputStream(URL url) throws IOException {
        return URLFileSystem.findHelper(url).openInputStream(url);
    }

    public static OutputStream openOutputStream(final URL url) throws IOException {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        URL rootURL = URLFileSystem.getTrackedRootURL(url);
        final List<URL> nonexistentParents = URLFileSystem.getNonExistentParents(rootURL, url);
        boolean notify = !_unscopedListenerList.isEmpty() || rootURL != null;
        try {
            final int eventType = helper.isRegularFile(url) ? 2 : 1;
            OutputStream stream = helper.openOutputStream(url);
            if (notify) {
                if (stream != null) {
                    Runnable notifier = new Runnable(){

                        @Override
                        public void run() {
                            URLFileSystem.notifyNonexistentParents(nonexistentParents);
                            URLFileSystem.fireURLFileSystemEvent(url, eventType);
                        }
                    };
                    stream = new TrackedOutputStream(notifier, stream);
                } else {
                    URLFileSystem.notifyNonexistentParents(nonexistentParents);
                }
            }
            return stream;
        }
        catch (IOException e) {
            URLFileSystem.notifyNonexistentParents(nonexistentParents);
            throw e;
        }
    }

    public static boolean renameTo(URL oldURL, URL newURL) {
        try {
            URLFileSystem.renameEx(oldURL, newURL);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameEx(URL oldURL, URL newURL) throws IOException {
        if (oldURL == null || newURL == null) {
            throw new IOException("URLFileSystem.renameEx: Null URL parameter");
        }
        if (oldURL == newURL || oldURL.equals(newURL)) {
            throw new IOException("URLFileSystem.renameEx: URL parameters are equal");
        }
        if (!URLFileSystem.protocolsAreEqual(oldURL, newURL)) {
            URLFileSystem.copy(oldURL, newURL);
            URLFileSystem.deleteEx(oldURL);
            return;
        }
        URLFileSystemHelper helper = URLFileSystem.findHelper(oldURL);
        URL oldRootURL = URLFileSystem.getTrackedRootURL(oldURL);
        URL newRootURL = URLFileSystem.getTrackedRootURL(newURL);
        boolean oldTracking = !_unscopedListenerList.isEmpty() || oldRootURL != null;
        boolean newTracking = !_unscopedListenerList.isEmpty() || newRootURL != null;
        Integer eventType = null;
        if (oldTracking || newTracking) {
            if (helper.isRegularFile(oldURL)) {
                eventType = 4;
            } else if (helper.isDirectory(oldURL)) {
                eventType = 12;
            }
        }
        List<URL> nonexistentParents = URLFileSystem.getNonExistentParents(newRootURL, newURL);
        boolean success = false;
        try {
            helper.rename(oldURL, newURL);
            success = true;
        }
        finally {
            try {
                if (oldTracking || newTracking) {
                    URLFileSystem.notifyNonexistentParents(nonexistentParents);
                    if (success && eventType != null) {
                        URLFileSystem.fireRenameURLFileSystemEvent(newURL, oldURL, eventType);
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static boolean setLastModified(URL url, long time) {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        boolean notify = URLFileSystem.hasListener(url) && helper.isRegularFile(url);
        long oldTime = notify ? URLFileSystem.lastModified(url) : 0L;
        boolean success = helper.setLastModified(url, time);
        if (notify && success && oldTime != time) {
            URLFileSystem.fireURLFileSystemEvent(url, 2);
        }
        return success;
    }

    public static boolean setReadOnly(URL url, boolean readOnly) {
        LOG_READONLY.trace("setting {1} read-only {0}", readOnly, (Object)url);
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        boolean notify = URLFileSystem.hasListener(url) && helper.isRegularFile(url);
        boolean oldReadOnly = notify && URLFileSystem.isReadOnly(url);
        boolean success = helper.setReadOnly(url, readOnly);
        if (notify && success && oldReadOnly != readOnly) {
            LOG_READONLY.trace("notifying {0} read-only change", (Object)url);
            URLFileSystem.fireURLFileSystemEvent(url, 13);
        }
        return success;
    }

    public static String toDisplayString(URL url) {
        return URLFileSystem.findHelper(url).toDisplayString(url);
    }

    public static String toEncodedString(URL url) {
        return URLFileSystem.findHelper(url).toEncodedString(url, null);
    }

    public static String toEncodedString(URL url, String encoding) {
        return URLFileSystem.findHelper(url).toEncodedString(url, encoding);
    }

    public static String toRelativeSpec(URL url, URL base) {
        return URLFileSystem.findHelper(url).toRelativeSpec(url, base);
    }

    public static String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        return URLFileSystem.findHelper(url).toRelativeSpec(url, base, mustConsumeBase);
    }

    public static URL getBaseParent(URL url, String relativeSpec) {
        return URLFileSystem.findHelper(url).getBaseParent(url, relativeSpec);
    }

    public static Reader createReader(URL url, String encoding) throws IOException {
        return URLFileSystem.findHelper(url).createReader(url, encoding);
    }

    private static boolean protocolsAreEqual(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        String p1 = url1.getProtocol();
        String p2 = url2.getProtocol();
        return p1.equals(p2);
    }

    protected static void fireURLFileSystemEvent(URL changedURL, int eventType) {
        if (changedURL == null) {
            return;
        }
        List<URL> rootList = URLFileSystem.getTrackedRootURLs(changedURL);
        URLFileSystem.fireURLFileSystemEvent(rootList, changedURL, null, eventType);
    }

    protected static void fireRenameURLFileSystemEvent(URL newURL, URL oldURL, int eventType) {
        if (newURL == null || oldURL == null) {
            return;
        }
        List<URL> oldRootList = URLFileSystem.getTrackedRootURLs(oldURL);
        List<URL> newRootList = URLFileSystem.getTrackedRootURLs(newURL);
        HashSet<URL> rootSet = new HashSet<URL>(oldRootList.size() + newRootList.size());
        rootSet.addAll(oldRootList);
        rootSet.addAll(newRootList);
        ArrayList<URL> rootList = new ArrayList<URL>(rootSet);
        URLFileSystem.fireURLFileSystemEvent(rootList, newURL, oldURL, eventType);
    }

    private static void fireURLFileSystemEvent(Collection<URL> rootURLs, URL changedURL, URL oldURL, int eventType) {
        if (changedURL == null) {
            return;
        }
        if (!URLFileSystemEvent.isValidEventType(eventType)) {
            return;
        }
        if (!_unscopedListenerList.isEmpty()) {
            URLFileSystemEvent event = new URLFileSystemEvent(NO_URLS, changedURL, oldURL, eventType);
            for (URLFileSystemListener listener : _unscopedListenerList) {
                try {
                    listener.notifyEvent(event);
                }
                catch (RuntimeException e) {
                    Assert.println("URLFileSystem.fireListenerEvent, exception in listener");
                    Assert.printStackTrace(e);
                }
            }
        }
        if (rootURLs != null && rootURLs.size() != 0) {
            for (Map.Entry<URLFileSystemListener, List<URL>> entry : URLFileSystem.getListenersAndTrackedRootURLs(rootURLs).entrySet()) {
                URLFileSystemListener listener;
                listener = entry.getKey();
                List<URL> registeredURLsList = entry.getValue();
                URL[] registeredURLs = registeredURLsList.toArray(new URL[registeredURLsList.size()]);
                URLFileSystemEvent event = new URLFileSystemEvent(registeredURLs, changedURL, oldURL, eventType);
                try {
                    listener.notifyEvent(event);
                }
                catch (RuntimeException e) {
                    Assert.println("URLFileSystem.fireListenerEvent, exception in listener");
                    Assert.printStackTrace(e);
                }
            }
        }
    }

    protected static boolean hasListener(URL url) {
        return !_unscopedListenerList.isEmpty() || URLFileSystem.getTrackedRootURL(url) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static URL getTrackedRootURL(URL url) {
        if (url != null) {
            Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> map = _rootURLToListenerMap;
            synchronized (map) {
                for (URLKey key : _rootURLToListenerMap.keySet()) {
                    URL rootURL = key.toURL();
                    if (rootURL == null || !URLFileSystem.isBaseURLFor(rootURL, url)) continue;
                    return rootURL;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<URLFileSystemListener, List<URL>> getListenersAndTrackedRootURLs(Collection<URL> rootURLs) {
        if (rootURLs != null) {
            HashMap<URLFileSystemListener, List<URL>> listenerMap = new HashMap<URLFileSystemListener, List<URL>>();
            Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> map = _rootURLToListenerMap;
            synchronized (map) {
                for (URL rootURL : rootURLs) {
                    CopyOnWriteArrayList<URLFileSystemListener> listenerList = _rootURLToListenerMap.get(URLKey.getInstance(rootURL));
                    if (listenerList == null) continue;
                    for (URLFileSystemListener listener : listenerList) {
                        if (listener == null) continue;
                        ArrayList<URL> resultList = (ArrayList<URL>)listenerMap.get(listener);
                        if (resultList == null) {
                            resultList = new ArrayList<URL>();
                            listenerMap.put(listener, resultList);
                        }
                        resultList.add(rootURL);
                    }
                }
            }
            return listenerMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<URL> getTrackedRootURLs(URL url) {
        if (url != null) {
            ArrayList<URL> rootList = new ArrayList<URL>();
            Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> map = _rootURLToListenerMap;
            synchronized (map) {
                for (URLKey key : _rootURLToListenerMap.keySet()) {
                    URL rootURL = key.toURL();
                    if (rootURL == null || !URLFileSystem.isBaseURLFor(rootURL, url)) continue;
                    rootList.add(rootURL);
                }
            }
            return rootList;
        }
        return null;
    }

    protected static List<URL> getNonExistentParents(URL rootURL, URL url) {
        URL parentURL;
        ArrayList<URL> nonexistentParents = new ArrayList<URL>();
        URL checkURL = url;
        while (!URLFileSystem.equals(checkURL, rootURL) && (parentURL = URLFileSystem.getParent(checkURL)) != null && !URLFileSystem.isDirectory(parentURL)) {
            nonexistentParents.add(parentURL);
            checkURL = parentURL;
        }
        return nonexistentParents;
    }

    protected static void notifyNonexistentParents(List<URL> nonexistentParents) {
        if (nonexistentParents != null) {
            int i = nonexistentParents.size();
            while (i-- > 0) {
                URL url = nonexistentParents.get(i);
                URLFileSystem.fireURLFileSystemEvent(url, 10);
            }
        }
    }

    @Deprecated
    protected static void notifyExistentParents(URL rootURL, List<URL> nonexistentParents) {
        URLFileSystem.notifyNonexistentParents(nonexistentParents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        if (listener == null) {
            return;
        }
        Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> map = _rootURLToListenerMap;
        synchronized (map) {
            if (rootURL != null) {
                final URLKey key = URLKey.getInstance(rootURL);
                CopyOnWriteArrayList<URLFileSystemListener> listenerList = _rootURLToListenerMap.get(key);
                if (listenerList == null) {
                    key.intern();
                    listenerList = new CopyOnWriteArrayList();
                    _rootURLToListenerMap.put(key, listenerList);
                    URLFileSystemListener frontListener = new URLFileSystemListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void notifyEvent(URLFileSystemEvent event) {
                            CopyOnWriteArrayList listenerList;
                            if (!_unscopedListenerList.isEmpty()) {
                                URLFileSystemEvent unscopedEvent = new URLFileSystemEvent(NO_URLS, event.getNewURL(), event.getOldURL(), event.getEventType());
                                for (URLFileSystemListener listener : _unscopedListenerList) {
                                    listener.notifyEvent(unscopedEvent);
                                }
                            }
                            Iterator iterator = _rootURLToListenerMap;
                            synchronized (iterator) {
                                listenerList = (CopyOnWriteArrayList)_rootURLToListenerMap.get(key);
                            }
                            if (listenerList != null) {
                                for (URLFileSystemListener listener : listenerList) {
                                    listener.notifyEvent(event);
                                }
                            }
                        }
                    };
                    _rootURLToFrontListenerMap.put(key, frontListener);
                    URLFileSystem.findHelper(rootURL).addURLFileSystemListener(rootURL, frontListener);
                }
                listenerList.addIfAbsent(listener);
            } else {
                _unscopedListenerList.addIfAbsent(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        if (listener == null) {
            return;
        }
        Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> map = _rootURLToListenerMap;
        synchronized (map) {
            if (rootURL != null) {
                URLKey key = URLKey.getInstance(rootURL);
                CopyOnWriteArrayList<URLFileSystemListener> listenerList = _rootURLToListenerMap.get(key);
                if (listenerList != null && listenerList.contains(listener)) {
                    listenerList.remove(listener);
                    if (listenerList.isEmpty()) {
                        _rootURLToListenerMap.remove(key);
                        URLFileSystemListener frontListener = _rootURLToFrontListenerMap.remove(key);
                        URLFileSystem.findHelper(rootURL).removeURLFileSystemListener(rootURL, frontListener);
                    }
                }
            } else {
                _unscopedListenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<URL> getURLsForListener(URLFileSystemListener listener) {
        if (listener != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            Map<URLKey, CopyOnWriteArrayList<URLFileSystemListener>> map = _rootURLToListenerMap;
            synchronized (map) {
                for (URLKey key : _rootURLToListenerMap.keySet()) {
                    URL rootURL;
                    List listenerList = _rootURLToListenerMap.get(key);
                    if (listenerList == null || !listenerList.contains(listener) || (rootURL = key.toURL()) == null) continue;
                    urls.add(rootURL);
                }
            }
            return urls;
        }
        return Collections.emptyList();
    }

    public static File getTempDirectory(URL url) {
        return URLFileSystem.findHelper(url).getTempDirectory();
    }

    private static URL assertIsDirURL(URL url) {
        String path;
        if (url != null && (path = url.getPath()) != null && path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            if (!_seenMalformedDirURLs.contains(url)) {
                _seenMalformedDirURLs.add(url);
                new IllegalArgumentException("A non-directory URL was passed to an URLFileSystem method that requires a directory URL.  You must use URLFactory.newDirURL(..) instead of newURL(..) to create directory URLs: " + path).printStackTrace();
            }
            return URLFactory.replacePathPart(url, path + "/");
        }
        return url;
    }

    static {
        URLFileSystem.registerHelper("file", new FileURLFileSystemHelper());
        URLFileSystem.registerHelper("jar", new JarURLFileSystemHelper());
        URLFileSystem.registerHelper("wsjar", new JarURLFileSystemHelper());
        URLFileSystem.registerHelper("http", new HttpURLFileSystemHelper());
        URLFileSystem.registerHelper("https", new HttpURLFileSystemHelper());
        URLFileSystem.registerHelper("ide", new IdeURLFileSystemHelper());
        URLFileSystem.registerHelper("ide.display", new IdeDisplayURLFileSystemHelper());
        URLFileSystem.registerHelper("ide.text", new IdeURLFileSystemHelper());
        URLFileSystem.registerHelper("code-source", new CodeSourceURLFileSystemHelper());
        URLFileSystem.registerHelper("zip", new ZipURLFileSystemHelper());
        s_streamHandlerFactoryQueue = null;
        LOG_READONLY = new Log("readonly");
        _rootURLToFrontListenerMap = new HashMap<URLKey, URLFileSystemListener>(500);
        _rootURLToListenerMap = new HashMap<URLKey, CopyOnWriteArrayList<URLFileSystemListener>>(500);
        _unscopedListenerList = new CopyOnWriteArrayList();
        TRACE_DANGLING_STREAMS = false;
        Runnable assertChecker = new Runnable(){

            @Override
            public void run() {
                TRACE_DANGLING_STREAMS = true;
            }
        };
        Assert.execute(assertChecker);
        _seenMalformedDirURLs = new HashSet<URL>();
    }

    private static class TrackedOutputStream
    extends OutputStream {
        private final OutputStream _tracked;
        private Runnable _runnable;
        private boolean _closed;
        private Throwable _trace;

        protected TrackedOutputStream(Runnable runnable, OutputStream tracked) {
            this._runnable = runnable;
            this._tracked = tracked;
            if (TRACE_DANGLING_STREAMS) {
                this._trace = new Throwable("Warning: closing unclosed OutputStream in finalizer, stream created here:");
            }
        }

        @Override
        public void write(int b) throws IOException {
            this._tracked.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this._tracked.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this._tracked.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this._closed) {
                this._closed = true;
                try {
                    this._tracked.close();
                    this._trace = null;
                }
                finally {
                    if (this._runnable != null) {
                        this._runnable.run();
                        this._runnable = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            Throwable trace;
            TrackedOutputStream trackedOutputStream = this;
            synchronized (trackedOutputStream) {
                trace = this._trace;
            }
            if (trace != null) {
                Assert.printStackTrace(trace);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                this.close();
            }
            finally {
                currentThread.setContextClassLoader(oldContextClassLoader);
            }
        }
    }

    public static class FileInfo {
        protected static final int ATTR_DIRECTORY = 1;
        protected static final int ATTR_REGULAR = 2;
        protected static final int ATTR_HIDDEN = 4;
        protected URL url;
        protected int attributes;
        protected long lastModified;
        protected long length;

        public FileInfo(URL url) {
            this(url, (URLFileSystem.isDirectory(url) ? 1 : 0) | (URLFileSystem.isRegularFile(url) ? 2 : 0) | (URLFileSystem.isHidden(url) ? 4 : 0), URLFileSystem.lastModified(url), URLFileSystem.getLength(url));
        }

        public FileInfo(File parent, String name, int attributes, long lastModified, long length) {
            this(new File(parent, name), attributes, lastModified, length);
        }

        public FileInfo(String parent, String name, int attributes, long lastModified, long length) {
            this(new File(parent, name), attributes, lastModified, length);
        }

        public FileInfo(File file, int attributes, long lastModified, long length) {
            this(file.getAbsolutePath(), attributes, lastModified, length);
        }

        public FileInfo(String path, int attributes, long lastModified, long length) {
            this((attributes & 1) != 0 ? URLFactory.newDirURL(path) : URLFactory.newFileURL(path), attributes, lastModified, length);
        }

        public FileInfo(URL url, int attributes, long lastModified, long length) {
            this.url = url;
            this.attributes = attributes;
            this.lastModified = lastModified;
            this.length = length;
        }

        public URL getURL() {
            return this.url;
        }

        public boolean isDirectory() {
            return (this.attributes & 1) != 0;
        }

        public boolean isFile() {
            return (this.attributes & 2) != 0;
        }

        public boolean isHidden() {
            return (this.attributes & 4) != 0;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public long length() {
            return this.length;
        }
    }

    public static interface StreamHandlerFactoryQueue {
        public void addFactory(String var1, URLStreamHandlerFactory var2);
    }
}

