/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ModelUtil;

public class DefaultURLFilter
implements URLFilter {
    private ArrayList _accepted;
    private String _description;
    private transient String _fullDescription;

    public DefaultURLFilter(String description) {
        this.setDescription(description);
    }

    public DefaultURLFilter(String description, String extension) {
        this.setDescription(description);
        this.addExtension(extension);
    }

    public DefaultURLFilter(String description, String[] extensions) {
        this.setDescription(description);
        if (extensions != null) {
            int n = extensions.length;
            for (int i = 0; i < n; ++i) {
                this.addExtension(extensions[i]);
            }
        }
    }

    public void addExtension(String extension) {
        if (extension != null && extension.length() > 0) {
            if (this._accepted == null) {
                this._accepted = new ArrayList();
            }
            if (!this._accepted.contains(extension)) {
                this._accepted.add(extension);
                this._fullDescription = null;
            }
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public boolean accept(URL url) {
        if (this._accepted == null) {
            return true;
        }
        Iterator iter = this._accepted.iterator();
        while (iter.hasNext()) {
            String extension = iter.next().toString();
            if (!URLFileSystem.hasSuffix(url, extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DefaultURLFilter)o);
    }

    protected final boolean equalsImpl(DefaultURLFilter filter) {
        return ModelUtil.areEqual(this._accepted, filter._accepted) && ModelUtil.areEqual(this._description, filter._description);
    }

    @Override
    public String toString() {
        if (this._fullDescription == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this._description != null ? this._description : "");
            if (this._accepted != null) {
                buf.append(" (");
                Iterator iter = this._accepted.iterator();
                while (iter.hasNext()) {
                    String extension = iter.next().toString();
                    buf.append("*").append(extension).append(", ");
                }
                buf.setLength(buf.length() - 2);
                buf.append(")");
            } else {
                buf.append(" (*.*)");
            }
            this._fullDescription = buf.toString();
        }
        return this._fullDescription;
    }
}

