/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.feedback;

import java.util.ArrayList;
import java.util.List;

public class FeedbackLogOptions {
    private Throwable exception;
    private Integer apiDepth;
    private String apiName;
    private List<Data> additionalData = new ArrayList<Data>(0);

    public FeedbackLogOptions() {
    }

    public FeedbackLogOptions(Throwable exception, int apiDepth) {
        this.exception = exception;
        this.apiDepth = apiDepth;
    }

    public FeedbackLogOptions(Throwable exception, String apiName) {
        this.exception = exception;
        this.apiName = apiName;
    }

    public FeedbackLogOptions(Throwable exception) {
        this.exception = exception;
    }

    public FeedbackLogOptions(Throwable exception, String dataDescription, String dataContent) {
        this.exception = exception;
        this.addAdditionalData(dataDescription, dataContent);
    }

    public FeedbackLogOptions(String dataDescription, String dataText) {
        this.addAdditionalData(dataDescription, dataText);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Integer getApiDepth() {
        return this.apiDepth;
    }

    public void setApiDepth(Integer apiDepth) {
        this.apiDepth = apiDepth;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public List<Data> getAdditionalData() {
        return this.additionalData;
    }

    public void addAdditionalData(String description, String content) {
        this.additionalData.add(new Data(description, content));
    }

    public class Data {
        private String description;
        private String content;

        public Data(String description, String content) {
            this.description = description;
            this.content = content;
        }

        public String getDescription() {
            return this.description;
        }

        public String getContent() {
            return this.content;
        }
    }
}

