/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;

public class HistoryEntrySelector {
    public static final HistoryEntrySelector CURRENT_REVISION = new HistoryEntrySelector(){

        @Override
        public HistoryEntry select(HistoryModel historyModel) {
            for (int i = 0; i < historyModel.getSize(); ++i) {
                HistoryEntry historyEntry = historyModel.getEntry(i);
                RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty());
                if (revisionIdentifier == null || !revisionIdentifier.isCurrent()) continue;
                return historyEntry;
            }
            return null;
        }
    };
    public static final HistoryEntrySelector PREVIOUS_REVISION = new HistoryEntrySelector(){

        @Override
        public HistoryEntry select(HistoryModel historyModel) {
            HistoryEntry historyEntry = CURRENT_REVISION.select(historyModel);
            if (historyEntry == null) {
                return null;
            }
            Object[] list = HistoryEntrySelector.createSortedRevisionList(historyModel);
            int i = Arrays.binarySearch(list, historyEntry.getValue(SharedProperties.getRevisionProperty()));
            return i <= 0 ? historyEntry : HistoryEntrySelector.findEntryForRevision(historyModel, ((RevisionIdentifier)list[i - 1]).getLabel());
        }
    };
    public static final HistoryEntrySelector LATEST_REVISION = new HistoryEntrySelector(){

        @Override
        public HistoryEntry select(HistoryModel historyModel) {
            RevisionIdentifier[] list = HistoryEntrySelector.createSortedRevisionList(historyModel);
            return list.length > 0 ? HistoryEntrySelector.findEntryForRevision(historyModel, list[list.length - 1].getLabel()) : null;
        }
    };
    private final String _revision;

    public HistoryEntrySelector() {
        this(null);
    }

    public HistoryEntrySelector(String revision) {
        this._revision = revision;
    }

    public HistoryEntry select(HistoryModel historyModel) {
        if (this._revision == null) {
            return historyModel.getSize() > 0 ? historyModel.getEntry(0) : null;
        }
        return HistoryEntrySelector.findEntryForRevision(historyModel, this._revision);
    }

    private static final RevisionIdentifier[] createSortedRevisionList(HistoryModel historyModel) {
        ArrayList<RevisionIdentifier> list = new ArrayList<RevisionIdentifier>();
        for (int i = 0; i < historyModel.getSize(); ++i) {
            RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyModel.getEntry(i).getValue(SharedProperties.getRevisionProperty());
            if (revisionIdentifier == null) continue;
            list.add(revisionIdentifier);
        }
        Collections.sort(list);
        return list.toArray(new RevisionIdentifier[list.size()]);
    }

    private static final HistoryEntry findEntryForRevision(HistoryModel historyModel, String revision) {
        for (int i = 0; i < historyModel.getSize(); ++i) {
            HistoryEntry historyEntry = historyModel.getEntry(i);
            if (!((RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty())).getLabel().equals(revision)) continue;
            return historyEntry;
        }
        return null;
    }
}

