/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML3g;
import oracle.spatial.util.Logger;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class GML2 {
    static Logger logger = Logger.getLogger("oracle.spatial.util.GML2");
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static String _srsAlias;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static void setsrsAlias(String string) {
        _srsAlias = string;
    }

    protected void CCWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + "," + d3 + " " + d2 + "," + d3 + " " + d2 + "," + d4 + " " + d + "," + d4 + " " + d + "," + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            stringBuffer.append(d + "," + d3 + "," + d5 + " " + d2 + "," + d3 + "," + d5 + " " + d2 + "," + d4 + "," + d5 + " " + d + "," + d4 + "," + d5 + " " + d + "," + d3 + "," + d5 + " ");
        }
    }

    protected void CWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + "," + d3 + " " + d + "," + d4 + " " + d2 + "," + d4 + " " + d2 + "," + d3 + " " + d + "," + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            stringBuffer.append(d + "," + d3 + "," + d5 + " " + d + "," + d4 + "," + d5 + " " + d2 + "," + d4 + "," + d5 + " " + d2 + "," + d3 + "," + d5 + " " + d + "," + d3 + "," + d5 + " ");
        }
    }

    protected void outputCoordinates(int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) throws IOException {
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(dArray[n3 + (i - 1) * n] + "," + dArray[n3 + (i - 1) * n + 1]);
            if (n == 3) {
                stringBuffer.append("," + dArray[n3 + (i - 1) * n + 2]);
            }
            stringBuffer.append(" ");
        }
    }

    public boolean geometryHasArcs(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 2] == 2 && nArray[3 * i + 1] % 10 > 1) {
                bl = true;
                continue;
            }
            if (nArray[3 * i + 1] % 10 == 3 && nArray[3 * i + 2] == 4) {
                bl = true;
                continue;
            }
            if (nArray[3 * i + 1] % 10 <= 3) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean geometryHasEtypeZero(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 1] % 10 != 0) continue;
            bl = true;
        }
        return bl;
    }

    protected void toGML(JGeometry jGeometry, StringBuffer stringBuffer) throws SQLException, IOException, DataException {
        this.toGML(jGeometry, stringBuffer, null);
    }

    protected void toGML(JGeometry jGeometry, StringBuffer stringBuffer, String string) throws SQLException, IOException, DataException {
        this.toGML(jGeometry, stringBuffer, string, _conn);
    }

    protected void toGML(JGeometry jGeometry, StringBuffer stringBuffer, String string, Connection connection) throws SQLException, IOException, DataException {
        String string2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Object object;
        double[] dArray;
        int[] nArray;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        String string3 = "Unknown";
        int n3 = 0;
        int n4 = 0;
        String string4 = "<gml:coordinates decimal=\".\" cs=\",\" ts=\" \">";
        String string5 = "</gml:coordinates>";
        String string6 = "<gml:geometryMember>";
        String string7 = "</gml:geometryMember>";
        String string8 = "<gml:pointMember>";
        String string9 = "</gml:pointMember>";
        String string10 = "<gml:lineStringMember>";
        String string11 = "</gml:lineStringMember>";
        String string12 = "<gml:polygonMember>";
        String string13 = "</gml:polygonMember>";
        String string14 = "<gml:outerBoundaryIs>";
        String string15 = "</gml:outerBoundaryIs>";
        String string16 = "<gml:innerBoundaryIs>";
        String string17 = "</gml:innerBoundaryIs>";
        String string18 = "<gml:LinearRing>";
        String string19 = "</gml:LinearRing>";
        String string20 = "";
        String string21 = "";
        if (jGeometry == null) {
            throw new DataException("NULL Geometry ");
        }
        if (this.geometryHasArcs(jGeometry)) {
            throw new DataException("Arcs are  not supported in GML");
        }
        if (this.geometryHasEtypeZero(jGeometry)) {
            throw new DataException("Etype zero not supported in GML");
        }
        if (jGeometry.isLRSGeometry()) {
            throw new DataException("LRS  not supported in GML");
        }
        int n5 = jGeometry.getType();
        int n6 = jGeometry.getSRID();
        n2 = jGeometry.getDimensions();
        if (n2 == 0) {
            n2 = 2;
        }
        if ((nArray = jGeometry.getElemInfo()) != null) {
            n = nArray.length / 3;
        }
        if ((dArray = jGeometry.getOrdinatesArray()) != null) {
            n4 = dArray.length / n2;
        }
        if (n5 == 1) {
            string3 = "Point";
            if (nArray != null && nArray[2] > 1) {
                string3 = "MultiPoint";
                n5 = 5;
            }
        } else if (n5 == 2) {
            string3 = "LineString";
        } else if (n5 == 3) {
            string3 = "Polygon";
            if (n == 1) {
                if (nArray != null && nArray[1] % 10 == 3 && nArray[2] == 3) {
                    string3 = "Box";
                } else {
                    string20 = string14 + string18;
                    string21 = string19 + string15;
                }
            }
        } else if (n5 == 4) {
            string3 = "MultiGeometry";
        } else if (n5 == 5) {
            string3 = "MultiPoint";
        } else if (n5 == 6) {
            string3 = "MultiLineString";
        } else if (n5 == 7) {
            string3 = "MultiPolygon";
        }
        if (string == null || string != null && string.equalsIgnoreCase("FALSE")) {
            if (n6 == 0) {
                stringBuffer.append("<gml:" + string3 + " srsName=\"SDO:\" xmlns:gml=\"http://www.opengis.net/gml\">");
            } else if (_srsNameSpace == null) {
                logger.finest("_srsNameSpace in GML2.toGML: " + _srsNameSpace);
                object = null;
                object = connection == null ? (n6 == 0 ? "SDO:0" : "SDO:" + n6) : (GML2.isLegacy(n6, connection) ? (n6 == 0 ? "SDO:0" : "SDO:" + n6) : "EPSG:" + n6);
                stringBuffer.append("<gml:" + string3 + " srsName=\"" + (String)object + "\" xmlns:gml=\"http://www.opengis.net/gml\">");
            } else {
                if (connection == null) {
                    throw new DataException("GML Converter needs a valid connection and SrsNameSpace");
                }
                object = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
                preparedStatement = null;
                resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement((String)object);
                    preparedStatement.setString(1, _srsNameSpace);
                    preparedStatement.setInt(2, n6);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new DataException("GML has unregistered SrsNameSpace/SrsName");
                    }
                    string2 = resultSet.getString("srsname");
                    stringBuffer.append("<gml:" + string3 + " srsName='" + _srsAlias + ":" + string2 + "'" + " xmlns:gml=\"http://www.opengis.net/gml" + "\" xmlns:" + _srsAlias + "=\"" + _srsNameSpace + "\" >");
                }
                catch (DataException dataException) {
                    throw dataException;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
        } else if (string != null && string.equalsIgnoreCase("TRUE")) {
            if (n6 == 0) {
                stringBuffer.append("<gml:" + string3 + " srsName=\"urn:ogc:def:crs:EPSG::0\" xmlns:gml=\"http://www.opengis.net/gml\">");
            } else if (_srsNameSpace == null) {
                stringBuffer.append("<gml:" + string3 + " srsName=\"urn:ogc:def:crs:EPSG::" + n6 + "\" xmlns:gml=\"http://www.opengis.net/gml\">");
            } else {
                if (connection == null) {
                    throw new DataException("GML Converter needs a valid connection and SrsNameSpace");
                }
                object = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
                preparedStatement = null;
                resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement((String)object);
                    preparedStatement.setString(1, _srsNameSpace);
                    preparedStatement.setInt(2, n6);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new DataException("GML has unregistered SrsNameSpace/SrsName");
                    }
                    string2 = resultSet.getString("srsname");
                    stringBuffer.append("<gml:" + string3 + " srsName=\"urn:ogc:def:crs:" + _srsAlias + ":" + string2 + "::" + n6 + "\"" + " xmlns:gml=\"http://www.opengis.net/gml" + "\" xmlns:" + _srsAlias + "=\"" + _srsNameSpace + "\" >");
                }
                catch (DataException dataException) {
                    throw dataException;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
        } else {
            stringBuffer.append("<gml:" + string3 + " srsName=\"" + string + n6 + "\" xmlns:gml=\"http://www.opengis.net/gml\">");
        }
        if (n5 == 1) {
            double[] dArray2 = jGeometry.getPoint();
            if (dArray2 != null) {
                n2 = dArray2.length;
                stringBuffer.append(string4);
                this.outputCoordinates(n2, 1, dArray2, 0, stringBuffer);
                stringBuffer.append(string5 + "</gml:" + string3 + ">");
            }
        } else if (n5 < 3 && dArray != null) {
            stringBuffer.append(string4);
            this.outputCoordinates(n2, n4, dArray, 0, stringBuffer);
            stringBuffer.append(string5 + "</gml:" + string3 + ">");
        } else if (n5 == 3 && n == 1) {
            stringBuffer.append(string20 + string4);
            this.outputCoordinates(n2, n4, dArray, 0, stringBuffer);
            stringBuffer.append(string5 + string21 + "</gml:" + string3 + ">");
        } else if (n5 == 3 && n > 1) {
            n4 = (nArray[3] - nArray[0]) / n2;
            stringBuffer.append(string14 + string18 + string4);
            n3 = 0;
            if (nArray[2] == 3) {
                this.CCWOutputRectangle(n2, dArray, n3, stringBuffer);
            } else {
                this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
            }
            stringBuffer.append(string5 + string19 + string15);
            for (int i = 2; i <= n; ++i) {
                stringBuffer.append(string16 + string18 + string4);
                n4 = i == n ? (dArray.length - nArray[3 * (i - 1)] + 1) / n2 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n2;
                n3 = nArray[3 * (i - 1)] - 1;
                if (nArray[3 * (i - 1) + 2] == 3) {
                    this.CWOutputRectangle(n2, dArray, n3, stringBuffer);
                } else {
                    this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                }
                stringBuffer.append(string5 + string19 + string17);
            }
            stringBuffer.append("</gml:" + string3 + ">");
        } else if (n5 == 4) {
            object = jGeometry.getElements();
            for (int i = 0; i < ((JGeometry[])object).length; ++i) {
                stringBuffer.append(string6);
                this.toGML(object[i], stringBuffer, string);
                stringBuffer.append(string7);
            }
            stringBuffer.append("</gml:" + string3 + ">");
        } else if (n5 == 5) {
            if (n == 1 && nArray[2] > 1) {
                n4 = nArray[2];
            } else if (n > 1) {
                n4 = n;
            }
            for (int i = 1; i <= n4; ++i) {
                n3 = n2 * (i - 1);
                if (nArray.length >= n3 + 2 && nArray[n3 + 2] == 0) continue;
                stringBuffer.append(string8 + "<gml:Point>" + string4);
                this.outputCoordinates(n2, 1, dArray, n3, stringBuffer);
                stringBuffer.append(string5 + "</gml:Point>" + string9);
            }
            stringBuffer.append("</gml:" + string3 + ">");
        } else if (n5 == 6) {
            for (int i = 1; i <= n; ++i) {
                stringBuffer.append(string10 + "<gml:LineString>" + string4);
                n4 = i == n ? (dArray.length - nArray[3 * (i - 1)] + 1) / n2 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n2;
                n3 = nArray[3 * (i - 1)] - 1;
                this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                stringBuffer.append(string5 + "</gml:LineString>" + string11);
            }
            stringBuffer.append("</gml:" + string3 + ">");
        } else if (n5 == 7) {
            boolean bl2 = true;
            for (int i = 1; i <= n; ++i) {
                boolean bl3;
                n4 = i == n ? (dArray.length - nArray[3 * (i - 1)] + 1) / n2 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n2;
                n3 = nArray[3 * (i - 1)] - 1;
                boolean bl4 = bl3 = nArray[3 * (i - 1) + 2] == 3;
                if (bl2) {
                    stringBuffer.append(string12 + "<gml:Polygon>" + string14 + string18 + string4);
                    if (bl3) {
                        this.CCWOutputRectangle(n2, dArray, n3, stringBuffer);
                    } else {
                        this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                    }
                    stringBuffer.append(string5 + string19 + string15);
                } else {
                    stringBuffer.append(string16 + string18 + string4);
                    if (bl3) {
                        this.CWOutputRectangle(n2, dArray, n3, stringBuffer);
                    } else {
                        this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                    }
                    stringBuffer.append(string5 + string19 + string17);
                }
                if (i == n) {
                    stringBuffer.append("</gml:Polygon>" + string13);
                    continue;
                }
                if (nArray[3 * i + 1] == 2003) {
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                stringBuffer.append("</gml:Polygon>" + string13);
            }
            stringBuffer.append("</gml:" + string3 + ">");
        }
    }

    protected void toGML(JGeometry jGeometry, StringBuffer stringBuffer, String string, int n) throws SQLException, IOException, DataException, Exception {
        if (n != 0) {
            if (n == 1) {
                int n2 = GML3g.reverseAxisOrder(n, jGeometry.getSRID(), _conn);
                if (n2 == 1) {
                    jGeometry = GML3g.switchXYOrdinates(jGeometry);
                }
            } else if (n == 2) {
                jGeometry = GML3g.switchXYOrdinates(jGeometry);
            } else {
                throw new Exception("Wrong value for (GML2) coordOrder parameter: please choose among [0,1,2]");
            }
        }
        this.toGML(jGeometry, stringBuffer, string);
    }

    protected void toGML(JGeometry jGeometry, StringBuffer stringBuffer, String string, int n, Connection connection) throws SQLException, IOException, DataException, Exception {
        if (n != 0) {
            if (n == 1) {
                int n2 = GML3g.reverseAxisOrder(n, jGeometry.getSRID(), connection);
                if (n2 == 1) {
                    jGeometry = GML3g.switchXYOrdinates(jGeometry);
                }
            } else if (n == 2) {
                jGeometry = GML3g.switchXYOrdinates(jGeometry);
            } else {
                throw new Exception("Wrong value for (GML2) coordOrder parameter: please choose among [0,1,2]");
            }
        }
        this.toGML(jGeometry, stringBuffer, string, connection);
    }

    public static CLOB to_GMLGeometryCLOB(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML2.to_GMLGeometry(sTRUCT);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return cLOB;
    }

    public static CLOB to_GMLGeometryCLOB(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML2.to_GMLGeometry(struct);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return cLOB;
    }

    public static String to_GMLGeometry(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        return GML2.to_GMLGeometry(struct, string, string2, null);
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        return GML2.to_GMLGeometry(sTRUCT, string, string2, null);
    }

    public static String to_GMLGeometry(Struct struct, String string, String string2, String string3) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        String string4 = GML2.to_GMLGeometry(struct, string3);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string4;
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, String string2, String string3) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        String string4 = GML2.to_GMLGeometry(sTRUCT, string3);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string4;
    }

    public static String to_GMLGeometry(Struct struct) throws SQLException, IOException {
        return GML2.to_GMLGeometry(struct, null);
    }

    public static String to_GMLGeometry(STRUCT sTRUCT) throws SQLException, IOException {
        return GML2.to_GMLGeometry(sTRUCT, null);
    }

    public static String to_GMLGeometry(Struct struct, String string) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML2.to_GMLGeometry(jGeometry, string);
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML2.to_GMLGeometry(jGeometry, string);
    }

    public static CLOB to_GMLGeometryCLOB(STRUCT sTRUCT) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML2.to_GMLGeometry(sTRUCT);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_GMLGeometryCLOB(Struct struct) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML2.to_GMLGeometry(struct);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static String to_GMLGeometry(JGeometry jGeometry) throws SQLException, IOException {
        return GML2.to_GMLGeometry(jGeometry, null);
    }

    public static String to_GMLGeometry(JGeometry jGeometry, String string) throws SQLException, IOException {
        GML2 gML2 = new GML2();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            gML2.toGML(jGeometry, stringBuffer, string);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CLOB to_GMLGeometryCLOB(STRUCT sTRUCT, NUMBER nUMBER) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML2.to_GMLGeometry(sTRUCT, nUMBER.intValue());
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_GMLGeometryCLOB(Struct struct, NUMBER nUMBER) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML2.to_GMLGeometry(struct, nUMBER.intValue());
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_GMLGeometryCLOB(STRUCT sTRUCT, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML2.to_GMLGeometry(sTRUCT, nUMBER.intValue());
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return cLOB;
    }

    public static CLOB to_GMLGeometryCLOB(Struct struct, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML2.to_GMLGeometry(struct, nUMBER.intValue());
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return cLOB;
    }

    public static String to_GMLGeometry(Struct struct, int n) throws SQLException, IOException {
        return GML2.to_GMLGeometry(struct, null, n);
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, int n) throws SQLException, IOException {
        return GML2.to_GMLGeometry(sTRUCT, null, n);
    }

    public static String to_GMLGeometry(Struct struct, String string, int n) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML2.to_GMLGeometry(jGeometry, string, n);
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, int n) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML2.to_GMLGeometry(jGeometry, string, n);
    }

    public static String to_GMLGeometry(JGeometry jGeometry, String string, int n) throws SQLException, IOException {
        GML2 gML2 = new GML2();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            gML2.toGML(jGeometry, stringBuffer, string, n);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String to_GMLGeometry(Struct struct, String string, String string2, String string3, int n) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        String string4 = GML2.to_GMLGeometry(struct, string3, n);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string4;
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, String string2, String string3, int n) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        String string4 = GML2.to_GMLGeometry(sTRUCT, string3, n);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string4;
    }

    public static String to_GMLGeometry(Struct struct, String string, String string2, String string3, int n, Connection connection) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        String string4 = GML2.to_GMLGeometry(struct, string3, n, connection);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string4;
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, String string2, String string3, int n, Connection connection) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        String string4 = GML2.to_GMLGeometry(sTRUCT, string3, n, connection);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string4;
    }

    public static String to_GMLGeometry(Struct struct, String string, int n, Connection connection) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML2.to_GMLGeometry(jGeometry, string, n, connection);
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, int n, Connection connection) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML2.to_GMLGeometry(jGeometry, string, n, connection);
    }

    public static String to_GMLGeometry(JGeometry jGeometry, String string, int n, Connection connection) throws SQLException, IOException {
        GML2 gML2 = new GML2();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            gML2.toGML(jGeometry, stringBuffer, string, n, connection);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLegacy(int n, Connection connection) throws SQLException {
        logger.finest("srId : " + n);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        try {
            string2 = "select IS_LEGACY from MDSYS.SDO_COORD_REF_SYS where SRID = ?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setInt(1, n);
            logger.finest("sqlStmt in GML2.isLegacy: " + string2);
            logger.finest("Parameter 1 : " + n);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (string == null) {
            return true;
        }
        return string.equalsIgnoreCase("true");
    }

    public static OracleClob to_GMLGeometryCLOBJS(Struct struct) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string = GML2.to_GMLGeometry(struct);
        if (string != null) {
            oracleClob.setString(1L, string.toString());
            oracleClob.close();
            return oracleClob;
        }
        oracleClob.close();
        return null;
    }

    public static OracleClob to_GMLGeometryCLOBJS(Struct struct, NUMBER nUMBER) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string = GML2.to_GMLGeometry(struct, nUMBER.intValue());
        if (string != null) {
            oracleClob.setString(1L, string.toString());
            oracleClob.close();
            return oracleClob;
        }
        oracleClob.close();
        return null;
    }

    public static OracleClob to_GMLGeometryCLOBJS(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string3 = GML2.to_GMLGeometry(struct);
        oracleClob.setString(1L, string3.toString());
        oracleClob.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return oracleClob;
    }

    public static OracleClob to_GMLGeometryCLOBJS(Struct struct, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string3 = GML2.to_GMLGeometry(struct, nUMBER.intValue());
        oracleClob.setString(1L, string3.toString());
        oracleClob.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return oracleClob;
    }

    static {
        _srsAlias = "Non-SDO";
    }
}

