/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.security;

import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Random;
import oracle.spatial.security.ORC;

final class SeedGenerator {
    private static final int BLOCKSIZE = 8;
    private static final long KNUTH = 2654435761L;
    private Random _random;
    private Random[] _srnd;
    private boolean _mixDone = false;
    private int _cursor = 0;
    private ORC _mixer = new ORC();
    private boolean _init = false;
    private Runtime _runtime = Runtime.getRuntime();
    private byte[] _entropy;
    private byte[] _scratch;
    private int _count = 1;
    private long _rot;
    private long _laddr;
    private byte[] _hstbuf;

    final int nextInt(int n) {
        n = this._srnd[this._cursor++].nextInt(n);
        if (this._cursor >= this._srnd.length) {
            this._cursor = 0;
        }
        return n;
    }

    final synchronized boolean isDone() {
        return this._mixDone;
    }

    final synchronized void setDone() {
        this._mixDone = true;
    }

    final synchronized void addRand(int n, Random random) {
        this._srnd[n] = random;
    }

    SeedGenerator(int n) {
        try {
            myPA myPA2 = new myPA();
            AccessController.doPrivileged(myPA2);
            if (myPA2.getAddr() != null) {
                this._laddr = SeedGenerator.toLong(myPA2.getAddr().getAddress());
            }
            if (myPA2.getHost() != null) {
                this._hstbuf = myPA2.getHost().getBytes();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._laddr == 0L) {
            this._laddr = 2130706433L;
        }
        if (this._hstbuf == null) {
            this._hstbuf = "localhost".getBytes();
        }
        int n2 = this._hstbuf.length > 64 ? this._hstbuf.length : 64;
        this._entropy = new byte[n2];
        this._scratch = new byte[n2];
        this._rot = 2654435761L + System.currentTimeMillis();
        this._random = new Random(5L + (System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL));
        if (n <= 0) {
            this._mixDone = true;
            this._srnd = new Random[1];
            this._srnd[0] = this._random;
            this._cursor = 0;
        } else {
            invokeSunRnd invokeSunRnd2 = null;
            this._srnd = new Random[n];
            while (n-- > 0) {
                invokeSunRnd2 = new invokeSunRnd(invokeSunRnd2, n);
            }
            invokeSunRnd2.go();
        }
    }

    private final void Init(byte[] byArray, int n) {
        if (!this._init) {
            this._mixer.i(byArray, n);
        } else {
            this._mixer.r(byArray, n);
        }
        this._init = true;
    }

    final void nextBytes(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = this.getSystemEntropy((byte)(~n2 % 257));
            if (n > i) {
                n = i;
            }
            System.arraycopy(this._entropy, 0, byArray, n2, n);
            n2 += n;
        }
        if (this.isDone()) {
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = n3++;
                byArray[n4] = (byte)(byArray[n4] ^ (byte)this.nextInt(256));
            }
        } else {
            int n5 = 0;
            while (n5 < byArray.length) {
                this._rot = (this._rot + (long)this._count++ ^ 0xFFFFFFFFFFFFFFFFL) * 2654435761L;
                int n6 = n5++;
                byArray[n6] = (byte)(byArray[n6] ^ (byte)(this._rot >> 5 ^ this._rot >> 15));
            }
        }
        this._mixer.x(byArray, byArray.length);
    }

    private final int getSystemEntropy(byte by) {
        int n = 0;
        n = SeedGenerator.long2bytes(this._entropy, n, System.currentTimeMillis());
        n = SeedGenerator.long2bytes(this._entropy, n, this._random.nextLong());
        this._entropy[n++] = by;
        switch (this._random.nextInt(7)) {
            case 0: {
                n = this.case0(n);
                break;
            }
            case 1: {
                n = this.case1(n);
                break;
            }
            case 2: {
                n = this.case2(n);
                break;
            }
            case 3: {
                n = this.case3(n);
                break;
            }
            case 4: {
                n = this.case4(n);
                break;
            }
            case 5: {
                n = this.case5(n);
                break;
            }
            default: {
                n = this.case6(n);
            }
        }
        int n2 = SeedGenerator.int2bytes(this._scratch, 0, this._random.nextInt());
        return SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
    }

    private final int case6(int n) {
        int n2 = 0;
        this.Init(this._entropy, n);
        long l = (this._random.nextLong() ^ this._runtime.freeMemory()) + this._laddr;
        n2 = SeedGenerator.long2bytes(this._scratch, n2, l);
        n2 = this.getHostName(this._scratch, n2);
        this._mixer.x(this._scratch, n2);
        return SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
    }

    private final int case5(int n) {
        int n2 = 0;
        long l = this._runtime.freeMemory() + SeedGenerator.toLong(this._entropy);
        n2 = SeedGenerator.long2bytes(this._scratch, 0, l);
        this.Init(this._scratch, n2);
        l = this._laddr * (long)this._random.nextInt() + this._runtime.totalMemory();
        n2 = SeedGenerator.long2bytes(this._scratch, n2, l);
        this._mixer.x(this._scratch, n2);
        System.arraycopy(this._entropy, 0, this._hstbuf, 0, this._hstbuf.length);
        if (n < this._hstbuf.length) {
            n = this._hstbuf.length;
        }
        return SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
    }

    private final int case4(int n) {
        this.Init(this._entropy, n);
        long l = (this._laddr ^ 0xFFFFFFFFFFFFFFFFL) % this._random.nextLong() ^ this._runtime.freeMemory() + this._laddr;
        n = SeedGenerator.long2bytes(this._entropy, 0, l);
        this._mixer.x(this._entropy, n);
        return n;
    }

    private final int case3(int n) {
        int n2 = SeedGenerator.long2bytes(this._scratch, 0, this._random.nextLong());
        this.Init(this._scratch, n2);
        long l = System.currentTimeMillis() ^ this._runtime.freeMemory() | this._laddr;
        n2 = SeedGenerator.long2bytes(this._scratch, 0, l);
        n = SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
        this._mixer.x(this._entropy, n);
        n2 = 8;
        int n3 = 8;
        while (n3-- > 0) {
            this._scratch[n3] = 0;
        }
        this._mixer.x(this._scratch, n2);
        return SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
    }

    private final int case2(int n) {
        int n2 = 0;
        n2 = SeedGenerator.long2bytes(this._scratch, 0, System.currentTimeMillis() + this._laddr);
        this.Init(this._scratch, n2);
        long l = (this._random.nextLong() + SeedGenerator.toLong(this._hstbuf)) * this._runtime.totalMemory();
        n2 = SeedGenerator.long2bytes(this._scratch, 0, l);
        return SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
    }

    private final int case1(int n) {
        int n2 = 0;
        n2 = SeedGenerator.long2bytes(this._scratch, 0, this._random.nextLong());
        this.Init(this._scratch, n2);
        long l = System.currentTimeMillis();
        long l2 = this._runtime.freeMemory() + l;
        n = SeedGenerator.long2bytes(this._entropy, n, (this._laddr + l) % l2);
        n = SeedGenerator.long2bytes(this._entropy, n, l2);
        this._mixer.x(this._entropy, n);
        return n;
    }

    private final int case0(int n) {
        int n2 = 0;
        System.arraycopy(this._entropy, 0, this._scratch, 0, n);
        n2 = n;
        n = SeedGenerator.long2bytes(this._entropy, 0, this._laddr);
        n = SeedGenerator.long2bytes(this._entropy, n, System.currentTimeMillis());
        n = SeedGenerator.long2bytes(this._entropy, n, this._runtime.freeMemory());
        n = SeedGenerator.long2bytes(this._entropy, n, this._random.nextLong());
        this._mixer.x(this._entropy, n);
        return SeedGenerator.xorbytes(this._entropy, n, this._scratch, n2);
    }

    private final int getHostName(byte[] byArray, int n) {
        int n2 = byArray.length - n;
        n2 = this._hstbuf.length > n2 ? n2 : this._hstbuf.length;
        System.arraycopy(this._hstbuf, 0, byArray, n, n2);
        return n + n2;
    }

    private static final long toLong(byte[] byArray) {
        long l = 0L;
        int n = byArray.length > 8 ? 8 : byArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = l << 8 | (long)(byArray[n2++] & 0xFF);
        }
        if (n < byArray.length) {
            while (n < byArray.length) {
                l ^= (long)(0xFF & byArray[n]) << ((n & 7) << 3);
                ++n;
            }
        }
        return l;
    }

    private static final int long2bytes(byte[] byArray, int n, long l) {
        int n2 = n;
        if ((n += 8) > byArray.length) {
            n = byArray.length;
        }
        while (n2 < n) {
            byArray[n2] = (byte)(l & 0xFFL);
            ++n2;
            l >>= 8;
        }
        return n;
    }

    private static final int int2bytes(byte[] byArray, int n, int n2) {
        int n3 = n;
        if ((n += 4) > byArray.length) {
            n = byArray.length;
        }
        while (n3 < n) {
            byArray[n3] = (byte)(n2 & 0xFF);
            ++n3;
            n2 >>= 8;
        }
        return n;
    }

    private static final int xorbytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4;
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = i;
            byArray[n5] = (byte)(byArray[n5] ^ byArray2[i]);
        }
        return n3;
    }

    class invokeSunRnd
    implements Runnable {
        private Random _sr;
        private int _index;
        invokeSunRnd _next;

        @Override
        public void run() {
            this._sr.nextInt();
            this.done();
        }

        void done() {
            SeedGenerator.this.addRand(this._index, this._sr);
            if (this._next != null) {
                this._next.go();
            } else {
                SeedGenerator.this.setDone();
            }
        }

        void go() {
            try {
                this._sr = SecureRandom.getInstance("SHA1PRNG", "SUN");
            }
            catch (Throwable throwable) {
                this._sr = new Random(System.currentTimeMillis());
            }
            try {
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.start();
            }
            catch (Throwable throwable) {
                this.done();
            }
        }

        invokeSunRnd(invokeSunRnd invokeSunRnd2, int n) {
            this._next = invokeSunRnd2;
            this._index = n;
        }
    }

    class myPA
    implements PrivilegedAction {
        private InetAddress m_addr;
        private String m_host;

        myPA() {
        }

        public final InetAddress getAddr() {
            return this.m_addr;
        }

        public final String getHost() {
            return this.m_host;
        }

        public final Object run() {
            try {
                this.m_addr = InetAddress.getLocalHost();
                this.m_host = this.m_addr.getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

