/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.file.ContentSetScope;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileScope;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileChangeListener;
import oracle.ide.index.file.FileChangeManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ideimpl.index.file.FileChangeImpl;

public class FileChangeManagerImpl
extends FileChangeManager {
    private final Map<AdapterKey, FileChangeListenerAdapter> adapters = new HashMap<AdapterKey, FileChangeListenerAdapter>();

    @Override
    public void addFileChangeListener(Workspace workspace, Project project, FileChangeListener listener) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        AdapterKey key = new AdapterKey(workspace, project, listener);
        FileChangeListenerAdapter adapter = new FileChangeListenerAdapter(workspace, project, listener);
        if (!this.adapters.containsKey(key)) {
            this.adapters.put(key, adapter);
            ContentSetScope.getInstance((Workspace)workspace, (Project)project).addFileChangeListener((oracle.ide.file.FileChangeListener)adapter);
        }
    }

    @Override
    public void removeFileChangeListener(Workspace workspace, Project project, FileChangeListener listener) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        AdapterKey key = new AdapterKey(workspace, project, listener);
        FileChangeListenerAdapter adapter = this.adapters.remove(key);
        if (adapter != null) {
            ContentSetScope.getInstance((Workspace)workspace, (Project)project).removeFileChangeListener((oracle.ide.file.FileChangeListener)adapter);
        }
    }

    private static final class FileChangeListenerAdapter
    implements oracle.ide.file.FileChangeListener {
        private final Workspace workspace;
        private final Project project;
        private final FileChangeListener adapted;

        FileChangeListenerAdapter(Workspace workspace, Project project, FileChangeListener listener) {
            this.workspace = workspace;
            this.project = project;
            this.adapted = listener;
        }

        public void filesChanged(FileScope scope, FileChanges changes) {
            ArrayList<FileChange> adaptedChanges = new ArrayList<FileChange>();
            for (oracle.ide.file.FileChange change : changes) {
                FileChange.Type type = this.getAdaptedType(change.getChangeType());
                if (type == null) continue;
                adaptedChanges.add(new FileChangeImpl(type, change.getURL(), change.getLastModified()));
            }
            this.adapted.filesChanged(this.workspace, this.project, adaptedChanges);
        }

        private FileChange.Type getAdaptedType(FileChange.Type type) {
            switch (type) {
                case ADDED: {
                    return FileChange.Type.FILE_ADDED;
                }
                case REMOVED: {
                    return FileChange.Type.FILE_REMOVED;
                }
                case MODIFIED: {
                    return FileChange.Type.FILE_CHANGED;
                }
                case BUFFER_MODIFIED: {
                    return FileChange.Type.TEXT_BUFFER_MODIFIED;
                }
            }
            return null;
        }
    }

    private static class AdapterKey {
        private Workspace workspace;
        private Project project;
        private FileChangeListener listener;

        public AdapterKey(Workspace workspace, Project project, FileChangeListener listener) {
            this.workspace = workspace;
            this.project = project;
            this.listener = listener;
        }

        public int hashCode() {
            int hashCode = this.listener.hashCode();
            hashCode += 31 * this.project.hashCode();
            if (this.workspace != null) {
                hashCode += 31 * this.workspace.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdapterKey)) {
                return false;
            }
            AdapterKey other = (AdapterKey)o;
            return this.listener.equals(other.listener) && this.project.equals((Object)other.project) && (this.workspace == null ? other.workspace == null : this.workspace.equals((Object)other.workspace));
        }
    }
}

