/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.todo;

import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.todo.TaskDescriptor;
import oracle.jdeveloper.todo.TaskScanner;

public class TaskAnalyzer
extends Analyzer {
    private static final TaskScanner SCANNER = TaskScanner.Factory.getTaskScanner();
    @ExtensionResource(value="oracle.jdeveloper.todo.task")
    private Rule TASK;

    protected final void generateTaskReports(AuditContext context, String text) {
        for (TaskDescriptor task : SCANNER.scan(text)) {
            IssueReport report = context.report(this.TASK);
            report.addParameter("tag", (Object)task.tag);
            report.addParameter("message", (Object)task.description);
            report.addParameter("priority", (Object)task.priority.value);
            int offset = context.getOffset() + task.tagOffset;
            int length = task.tag.length();
            Location location = context.getModel().getLocation(offset, length);
            report.setFocusLocation(location);
        }
    }
}

