/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.plugin.postgresql.PostgreSQLConstraintDetails;
import oracle.dbtools.migration.workbench.postgresql.BlackMessages;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLCaptureQueries;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLConstraintExtractor;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLMigrationAddinArb;

public class PostgreSQLCapturer
extends AbstractOnlineCapturer {
    public static final String MY_LANGUAGE_ID = "PostgreSQL";
    private static final String CAPTURE_SCHEMAS_QUERY = "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA";
    private static final String CAPTURE_TABLES_QUERY = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES where table_schema='${schema}'";
    private static final String CAPTURE_COLUMNS_QUERY = "select * from information_schema.columns where table_schema='${schema}' and table_name='${table}'";
    protected static final String CAPTURE_INDEX_QUERY = "SELECT n.nspname as \"Schema\",  c.relname as \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'v' THEN 'view' WHEN 'i' THEN 'index' WHEN 'S' THEN  'sequence' WHEN 's' THEN 'special' END as \"Type\", u.usename as \"Owner\", c2.relname as \"Table\", CASE WHEN i.indisunique='true' THEN 0 ELSE 1 END \"Unique\" FROM pg_catalog.pg_class c   JOIN pg_catalog.pg_index i ON i.indexrelid = c.oid   JOIN pg_catalog.pg_class c2 ON i.indrelid = c2.oid   LEFT JOIN pg_catalog.pg_user u ON u.usesysid = c.relowner   LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind IN ('i','') AND n.nspname NOT IN ('pg_catalog', 'pg_toast')     AND pg_catalog.pg_table_is_visible(c.oid)    AND c2.relname='${table}'    AND n.nspname='${schema}' ORDER BY 1,2";
    private static final String CAPTURE_CONSTRAINT_QUERY = "SHOW CREATE TABLE `${schema}`.`${table}`";
    private static final String CAPTURE_USERS_QUERY = "SELECT * FROM mysql.user";
    protected static final String PRIMARY_KEY_INDICATOR = "PRI";
    protected static final String ENUM_DATA_TYPE = "ENUM";
    protected static final String SET_DATA_TYPE = "SET";
    private static PostgreSQLCaptureQueries s_captureQueries;
    private String[] m_captureColumn = new String[]{BlackMessages.getString("PostgreSQLCapturer.10"), BlackMessages.getString("PostgreSQLCapturer.11"), BlackMessages.getString("PostgreSQLCapturer.12"), BlackMessages.getString("PostgreSQLCapturer.13"), BlackMessages.getString("PostgreSQLCapturer.14"), BlackMessages.getString("PostgreSQLCapturer.15"), BlackMessages.getString("PostgreSQLCapturer.16")};
    protected int m_minorVersion;
    protected int m_majorVersion;
    private String m_modelName;
    private Logger m_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");

    public PostgreSQLCapturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new PostgreSQLCaptureQueries();
        }
        return s_captureQueries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        if (captureContext.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, string, "");
            captureContext.getAudience().fireListeners(captureEvent);
            return;
        }
        try {
            if (string.equals("MD_SCHEMAS")) {
                this.captureSchemas(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_TABLES")) {
                this.captureTables(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_CATALOGS")) {
                this.storeDefaultCatalog(captureContext);
                return;
            }
            if (string.equals("MD_USERS")) {
                this.captureUsers(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_COLUMNS")) {
                this.captureColumnDetails(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_INDEXES")) {
                this.captureIndexForTable(captureContext, migrationObjectFilter);
                return;
            }
            if (!string.equals("MD_INDEX_DETAILS") && !string.equals("MD_CONSTRAINTS") && !string.equals("MD_CONSTRAINT_DETAILS")) return;
        }
        catch (SQLException sQLException) {
            throw new CaptureException((Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTables(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_TABLES_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_TABLES");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string = resultSet.getString(1))) continue;
                QueryCapture.processTableRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected void processFilter(MigrationObjectFilter migrationObjectFilter, StringBuffer stringBuffer, HashSet<String> hashSet, String string) {
        String[] stringArray;
        if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals(string)) {
            throw new IllegalArgumentException(BlackMessages.getString("PostgreSQLCapturer.18") + migrationObjectFilter.getObjectType());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
            stringBuffer = stringBuffer.append(" ").append(migrationObjectFilter.getWhereClause());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
            stringArray = migrationObjectFilter.getObjectNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                hashSet.add(string2);
            }
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 0 && migrationObjectFilter.getSelectedDatabaseListString() != null && (stringArray = migrationObjectFilter.getSelectedDatabaseListString().replaceAll("'+", "").split(",")) != null) {
            for (String string3 : stringArray) {
                hashSet.add(string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchemas(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_SCHEMAS_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_SCHEMAS");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next()) {
                String string;
                if (migrationObjectFilter != null && (migrationObjectFilter.getFilterType() == 1 || migrationObjectFilter.getFilterType() == 0) && !hashSet.contains(string = resultSet.getString(1)) || resultSet.getString(1).equalsIgnoreCase("information_schema") || resultSet.getString(1).equalsIgnoreCase("mysql")) continue;
                QueryCapture.processSchemaRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected void captureUsers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        try {
            CloseableResultSet closeableResultSet = null;
            CaptureAudience captureAudience = captureContext.getAudience();
            String string = captureContext.applyToSQLString("${schema}");
            StringBuffer stringBuffer = new StringBuffer("SELECT * FROM mysql.db WHERE Db = '" + string + "'");
            CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet2.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                StringBuffer stringBuffer2 = new StringBuffer("SELECT * FROM mysql.user WHERE USER ='" + resultSet.getString(3) + "'");
                String string2 = resultSet.getString(1);
                closeableResultSet = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet2 = closeableResultSet.getResultSet();
                while (resultSet2.next()) {
                    DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                    if (resultSet2.getString(2) == null || resultSet2.getString(2).length() <= 0 || !string2.equals(resultSet2.getString(1))) continue;
                    MdUser mdUser = new MdUser(dBObjectId, resultSet2.getString(2));
                    mdUser.setPassword(resultSet2.getString(3));
                    CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), mdUser.getUsername());
                    captureAudience.fireListeners(captureEvent);
                    mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
                    captureEvent.setEventId(4);
                    captureAudience.fireListeners(captureEvent);
                    this.createUserPrivilegeDetails(captureContext, mdUser, resultSet2);
                }
            }
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
            if (closeableResultSet2 != null) {
                closeableResultSet2.close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Could Not Capture User - " + sQLException.getLocalizedMessage(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    protected void createUserPrivilegeDetails(CaptureContext captureContext, MdUser mdUser, ResultSet resultSet) {
        try {
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string = resultSet.getString(14);
            for (int i = 1; i <= 26; ++i) {
                if (!resultSet.getString(i + 3).equals("Y") || i == 11) continue;
                String string2 = resultSet.getMetaData().getColumnName(i + 3);
                String string3 = this.getOracleSpecificPrivilege(this.getPrivilege(string2));
                boolean bl = false;
                if (string3.length() == 0) {
                    string3 = this.getPrivilege(string2);
                    bl = true;
                }
                MdPrivilege mdPrivilege = new MdPrivilege(dBObjectId, " ", "MD_USERS", string3, new ClobHelper(" "));
                mdPrivilege.setPrivelegeObjectId(mdUser.getKey());
                if (string.equals("Y")) {
                    mdPrivilege.setAdminOption("Y");
                } else {
                    mdPrivilege.setAdminOption("N");
                }
                if (bl) {
                    mdPrivilege.addProperty(new AdditionalProperty(PostgreSQLMigrationAddinArb.getString("PostgreSQL_PRIVILEGE"), string3), dBObjectId2);
                }
                CaptureEvent captureEvent = new CaptureEvent(3, "USER PRIVILEGE", resultSet.getString(2));
                captureContext.getAudience().fireListeners(captureEvent);
                mdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)mdPrivilege);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(mdUser.getKey());
                mdUserPrivilege.setPrivilegeId(mdPrivilege.getKey());
                mdUserPrivilege = (MdUserPrivilege)this.getStorer().storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    protected String getOracleSpecificPrivilege(String string) {
        if (string.equalsIgnoreCase("Select")) {
            return "SELECT";
        }
        if (string.equalsIgnoreCase("Insert")) {
            return "INSERT";
        }
        if (string.equalsIgnoreCase("Update")) {
            return "UPDATE";
        }
        if (string.equalsIgnoreCase("References")) {
            return "REFERENCES";
        }
        if (string.equalsIgnoreCase("Delete")) {
            return "DELETE";
        }
        if (string.equalsIgnoreCase("Alter")) {
            return "ALTER";
        }
        if (string.equalsIgnoreCase("Index")) {
            return "INDEX";
        }
        return "";
    }

    private String getPrivilege(String string) {
        String string2 = string.substring(0, string.lastIndexOf("_priv"));
        return string2;
    }

    protected void captureColumnDetails(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        CaptureAudience captureAudience = captureContext.getAudience();
        MdColumn mdColumn = null;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_COLUMNS_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_COLUMNS");
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        int n = 1;
        this.m_minorVersion = this.getDataBaseMinorVersion(this.m_sourceConnection);
        this.m_majorVersion = this.m_sourceConnection.getMetaData().getDatabaseMajorVersion();
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
        while (resultSet.next()) {
            String string;
            Object object;
            boolean bl = false;
            if (captureContext.shouldCancel()) {
                object = new CaptureEvent(-1, "COLUMN", "");
                captureContext.getAudience().fireListeners(object);
                closeableResultSet.close();
                return;
            }
            String string2 = resultSet.getString(4);
            object = resultSet.getString(8);
            String string3 = resultSet.getString(35);
            if (string3.equals("YES")) {
                String string4 = captureContext.applyToSQLString("${schema}");
                String string5 = captureContext.applyToSQLString("${table}");
                string = "SELECT MAX(`" + string2 + "`) FROM " + string4 + "." + string5;
                CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet2 = closeableResultSet2.getResultSet();
                long l = 0L;
                while (resultSet2.next()) {
                    l = resultSet2.getLong(1);
                }
                closeableResultSet2.close();
                mdColumn = new MdIdentityColumn(dBObjectId2, string2, Integer.valueOf(n++), 0L, 1L, l, dBObjectId);
                bl = true;
            }
            if (!bl) {
                mdColumn = new MdColumn(dBObjectId2, string2, Integer.valueOf(n++));
            }
            if (string3 != null && string3.trim().length() > 0) {
                mdColumn.addProperty(new AdditionalProperty("EXTRA", string3), dBObjectId);
            }
            mdColumn.setColumnType((String)object);
            int n2 = 0;
            int n3 = 0;
            if ("smallint".equals(object)) {
                n2 = resultSet.getInt(11);
                n3 = resultSet.getInt(13);
            } else if ("integer".equals(object)) {
                n2 = resultSet.getInt(11);
                n3 = resultSet.getInt(13);
            } else if ("bit".equals(object)) {
                n2 = resultSet.getInt(11);
                n3 = resultSet.getInt(13);
            } else if ("double precision".equals(object)) {
                n2 = resultSet.getInt(11);
                n3 = resultSet.getInt(13);
            } else if ("character".equals(object)) {
                n2 = resultSet.getInt(9);
            } else if ("varchar".equals(object)) {
                n2 = resultSet.getInt(9);
            }
            mdColumn.setPrecision(n2 == 0 ? null : Integer.valueOf(n2));
            mdColumn.setScale(n3 == 0 ? null : Integer.valueOf(n3));
            if (resultSet.getString(7).equalsIgnoreCase("YES")) {
                mdColumn.setNullable("Y");
            } else {
                mdColumn.setNullable("N");
            }
            mdColumn.setDefaultValue(resultSet.getString(6));
            string = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), mdColumn.getColumnName());
            captureAudience.fireListeners((CaptureEvent)string);
            mdColumn = (MdColumn)this.getStorer().storeObject((PersistableObject)mdColumn);
            string.setEventId(4);
            captureAudience.fireListeners((CaptureEvent)string);
        }
        closeableResultSet.close();
    }

    protected int getDataBaseMinorVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseMinorVersion();
    }

    protected int getColumnCaptureInfo(String string) {
        for (int i = 0; i < this.m_captureColumn.length; ++i) {
            if (!this.m_captureColumn[i].equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        return 1;
    }

    protected void captureColumnPrivilege(String string, CaptureContext captureContext, MdColumn mdColumn) throws PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2 == null) continue;
            MdPrivilege mdPrivilege = new MdPrivilege(dBObjectId, " ", "MD_COLUMNS", string2, new ClobHelper(" "));
            mdPrivilege.setPrivelegeObjectId(mdColumn.getKey());
            CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN PRIVILEGE", string2);
            captureContext.getAudience().fireListeners(captureEvent);
            mdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)mdPrivilege);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    protected String[] getAllValues(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "'");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3.equals(",")) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void captureIndexForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_INDEX_QUERY);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_INDEXES");
        CloseableResultSet closeableResultSet = null;
        closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        boolean bl2 = bl = !resultSet.next();
        while (!bl) {
            String string;
            int n = 1;
            if (captureContext.shouldCancel()) {
                string = new CaptureEvent(-1, "INDEX", "");
                captureContext.getAudience().fireListeners((CaptureEvent)string);
                closeableResultSet.close();
                return;
            }
            string = resultSet.getString(2);
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string)) {
                bl = !resultSet.next();
                continue;
            }
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
            int n2 = resultSet.getInt(6);
            MdIndexe mdIndexe = new MdIndexe(dBObjectId);
            mdIndexe.setIndexName(resultSet.getString(2));
            if (n2 == 0) {
                mdIndexe.setIndexType("UNIQUE");
            } else {
                mdIndexe.setIndexType("NON_UNIQUE");
            }
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            do {
                this.createIndexDetails(captureContext, mdIndexe, resultSet, n++);
            } while (!(bl = !resultSet.next()) && resultSet.getString(3).equals(mdIndexe.getIndexName()));
        }
        closeableResultSet.close();
    }

    protected MdConstraint createPrimaryIndexConstraint(CaptureContext captureContext, String string, DBObjectId dBObjectId) throws SQLException, PersistenceException {
        MdConstraint mdConstraint = new MdConstraint(dBObjectId, MY_LANGUAGE_ID);
        mdConstraint.setName(string);
        mdConstraint.setConstraintType("PK");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), string);
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        return mdConstraint;
    }

    protected void createPrimaryIndexConstraintDetails(CaptureContext captureContext, MdConstraint mdConstraint, String string, int n, DBObjectId dBObjectId) throws PersistenceException, SQLException {
        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(1));
        DBObjectId dBObjectId2 = this.getStorer().getPersistenceUtility().getIdForColumn(dBObjectId, string);
        mdConstraintDetail.setColumnId(dBObjectId2);
        mdConstraintDetail.setRefFlag("N");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    protected void createIndexDetails(CaptureContext captureContext, MdIndexe mdIndexe, ResultSet resultSet, int n) throws PersistenceException, SQLException {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = "select n.nspname as \"Schema\",    t.relname as table_name, i.relname as index_name, a.attname as column_name from pg_class t, pg_class i, pg_index ix, pg_attribute a, pg_namespace n where t.oid = ix.indrelid and i.oid = ix.indexrelid and n.oid = t.relnamespace and a.attrelid = t.oid and a.attnum = ANY(ix.indkey)     and t.relkind = 'r' and t.relname = '" + resultSet.getString(4) + "' and n.nspname='" + string + "' order by   t.relname,   i.relname ";
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string2, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet2 = closeableResultSet.getResultSet();
        boolean bl = true;
        while (resultSet2.next()) {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), persistenceUtility.getIdForColumn(mdIndexe.getTableId(), resultSet2.getString(4)), Integer.valueOf(n));
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    protected void captureConstraintForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)CAPTURE_CONSTRAINT_QUERY, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        resultSet.next();
        this.processContraintRow(captureContext, closeableResultSet, migrationObjectFilter);
        if (closeableResultSet != null) {
            closeableResultSet.close();
        }
    }

    private void processContraintRow(CaptureContext captureContext, CloseableResultSet closeableResultSet, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        PostgreSQLConstraintDetails[] postgreSQLConstraintDetailsArray;
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
        ResultSet resultSet = closeableResultSet.getResultSet();
        String string = resultSet.getString(2);
        PostgreSQLConstraintExtractor postgreSQLConstraintExtractor = new PostgreSQLConstraintExtractor(string);
        for (PostgreSQLConstraintDetails postgreSQLConstraintDetails : postgreSQLConstraintDetailsArray = postgreSQLConstraintExtractor.getConstraintDetails()) {
            Object object;
            if (captureContext.shouldCancel()) {
                object = new CaptureEvent(-1, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), "");
                captureContext.getAudience().fireListeners((CaptureEvent)object);
                closeableResultSet.close();
                return;
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                object = new HashSet();
                this.processFilter(migrationObjectFilter, new StringBuffer(), (HashSet<String>)object, "MD_CONSTRAINTS");
                if (!((HashSet)object).contains(postgreSQLConstraintDetails.getName())) {
                    continue;
                }
            } else if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                this.m_logger.log(Level.SEVERE, BlackMessages.getString("MySQLCapturer.9"), new Object[]{BlackMessages.getString("MySQLCapturer.72")});
                throw new UnsupportedOperationException(BlackMessages.getString("MySQLCapturer.8"));
            }
            MdConstraint mdConstraint = new MdConstraint(dBObjectId2, MY_LANGUAGE_ID);
            mdConstraint.setConstraintType("FOREIGN KEY");
            mdConstraint.setName(postgreSQLConstraintDetails.getName());
            object = null;
            try {
                object = persistenceUtility.getIdForTable(dBObjectId, postgreSQLConstraintDetails.getReferencedTableName());
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable((String)persistenceException.getMessage(), (String)(BlackMessages.getString("MySQLCapturer.7") + postgreSQLConstraintDetails.getName()), (Throwable)persistenceException);
            }
            if (object == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, MessageFormat.format(BlackMessages.getString("MySQLCapturer.75"), postgreSQLConstraintDetails.getName(), postgreSQLConstraintDetails.getReferencedTableName()));
                continue;
            }
            mdConstraint.setReftableId((DBObjectId)object);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
            int n = this.createConstraintDetails(dBObjectId2, mdConstraint, postgreSQLConstraintDetails.getColumnNames(), "N", 1, captureContext);
            this.createConstraintDetails((DBObjectId)object, mdConstraint, postgreSQLConstraintDetails.getReferencedColumnNames(), "Y", n, captureContext);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    protected int createConstraintDetails(DBObjectId dBObjectId, MdConstraint mdConstraint, String[] stringArray, String string, int n, CaptureContext captureContext) throws PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        int n2 = n;
        for (String string2 : stringArray) {
            MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n2++));
            DBObjectId dBObjectId2 = persistenceUtility.getIdForColumn(dBObjectId, string2);
            mdConstraintDetail.setColumnId(dBObjectId2);
            mdConstraintDetail.setRefFlag(string);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        return n2;
    }

    protected void storeDefaultCatalog(CaptureContext captureContext) throws PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdCatalog mdCatalog = new MdCatalog(dBObjectId);
        mdCatalog.setDummyFlag("Y");
        mdCatalog.setCatalogName(MY_LANGUAGE_ID);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), MY_LANGUAGE_ID);
        captureContext.getAudience().fireListeners(captureEvent);
        mdCatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                String string2 = databaseMetaData.getUserName();
                String[] stringArray2 = string2.split("@");
                this.m_modelName = stringArray2[0] + "@" + stringArray[2] + ":" + this.m_sourceConnection.getCatalog() + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                this.m_logger.log(Level.SEVERE, BlackMessages.getString("PostgreSQLCapturer.85"), new Object[]{BlackMessages.getString("PostgreSQLCapturer.86")});
                throw new CaptureException((Throwable)sQLException);
            }
        }
        return this.m_modelName;
    }

    public String putInViewPrefix(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (!string.trim().split("\n")[0].toLowerCase().startsWith("create")) {
            string = "CREATE VIEW `" + string2 + "` AS " + string;
        }
        return string;
    }
}

