/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.DimensionMetadata;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.rules.discriminator.TotalsDiscriminator;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.dss.util.xml.XMLObjectWriter;

public class UIFormat
implements Persistable,
Cloneable {
    private String m_name;
    private int m_group;
    private int m_formatType;
    private boolean m_negativeRed;
    private Discriminator m_discriminator;
    private ViewStyle m_viewStyle;
    private ViewFormat m_viewFormat;
    private int m_numberOrDate;
    private String m_numberFormatString;
    private long m_ID;
    private int m_mergeableType;
    private ConditionElement m_valueCondition;
    private boolean m_automaticName = true;
    private boolean m_bSelected = true;
    private static long m_lastID = 0L;
    public static final int HEADER_VIEWSTYLE = 0;
    public static final int DATABODY_VIEWSTYLE = 1;
    public static final int DATABODY_VIEWFORMAT = 2;
    public static final int FT_DEFAULT = 1;
    public static final int FT_APP_DEFINED = 2;
    public static final int FT_END_USER_DEFINED = 3;
    public static final int NO_NUMBER_DATE = -1;
    public static final int NUMBER_NONE = 0;
    public static final int NUMBER_DEFAULT = 1;
    public static final int NUMBER_GENERAL = 2;
    public static final int NUMBER_CURRENCY = 3;
    public static final int NUMBER_PERCENT = 4;
    public static final int NUMBER_CUSTOM = 5;
    public static final int NUMBER_NOT_SPECIFIED = 6;
    public static final int DATE_NONE = 0;
    public static final int DATE_DEFAULT = 1;
    public static final int DATE_GENERAL = 2;
    public static final int DATE_TIME = 3;
    public static final int DATE_DATETIME = 4;
    public static final int DATE_CUSTOM = 5;
    public static final int DATE_NOT_SPECIFIED = 6;
    public static final int HEADER = 1;
    public static final int DATABODY = 2;
    public static final int HEADER_EXCEPTION = 3;
    public static final int DATABODY_EXCEPTION = 4;
    public static final int DATABODY_STOPLIGHT = 5;
    public static final String TYPE = "Format";
    protected transient PersistableAttributes m_attrs = null;
    protected Hashtable m_context = null;
    private boolean m_desirableGreaterThanThreshold = true;
    private boolean m_isDirty = false;
    private List m_dimensions = null;
    private boolean m_editable = true;
    public static final String S_HEADER_TOOLBAR_FORMAT = "H1";
    public static final String S_TOOLBAR_FORMAT = "T2";
    public static final String S_HEADER_FORMAT = "H3";
    public static final String S_CONDITIONAL_FORMAT = "C4";
    public static final String S_STOPLIGHT_FORMAT = "S5";
    private static final String s_discriminator = "d";
    private static final String s_group = "u";
    private static final String s_id = "i";
    private static final String s_formatType = "t";
    private static final String s_mergeableType = "m";
    private static final String s_negativeRed = "r";
    private static final String s_numberFormatString = "f";
    private static final String s_numberOrDate = "e";
    private static final String s_positions = "p";
    private static final String s_selected = "s";
    private static final String s_viewFormat = "vf";
    private static final String s_viewStyle = "vs";
    private static final String s_dimensions = "dl";
    private static final String s_name = "n";
    private static final String s_defaultName = "l";
    private static final String s_noCondition = "h";
    private String m_position = null;
    private static UIFormat m_defaultDataSelection = null;
    private static UIFormat m_defaultHeaderFormat = null;
    private static UIFormat m_defaultDataFormat = null;
    private static UIFormat m_defaultStoplight = null;
    private static final int NOT_FOUND = -1;
    private static final int DELETE = -1;
    private static final int EDIT = -2;
    private static final int INSERT = -3;
    private static final int INSERT_LAST = -4;
    private static final String FIELD_SEPARATOR = ":";
    public static final int DEFAULT_OPTION = 0;
    public static final int POSITION_ONLY = 1;
    public static final int OUTPUT_DIMENSION_LIST = 2;
    private static boolean DEBUG = false;
    private static final String[] stateNames = new String[]{"", "H1", "T2", "H3", "C4", "S5"};
    private static final String[] defaultFormatNames = new String[]{"", "SelectionFormatPrefix", "SelectionFormatPrefix", "HeaderFormatPrefix", "ConditionalFormatPrefix", "StoplightFormatPrefix"};
    private static final String UI_FORMAT = "UIFormat";
    private static final String a_name = "name";
    private static final String a_automaticName = "autoName";
    private static final String a_id = "id";
    private static final String a_mergeableType = "mergeType";
    private static final String a_group = "group";
    private static final String a_formatType = "fmtType";
    private static final String a_negativeRed = "negRed";
    private static final String a_numberOrDate = "numOrDate";
    private static final String a_numberFormatString = "fmtStr";
    private static final String a_discriminator = "disc";
    private static final String a_viewStyle = "viewStyle";
    private static final String a_viewFormat = "viewFormat";
    private static final String a_condition = "valueCond";
    private static final String a_type = "type";
    private static final String a_selected = "selected";

    public UIFormat() {
    }

    public UIFormat(String name, int mergeableType, int formatType, int group, Discriminator discriminator, ViewStyle viewStyle, ViewFormat viewFormat, Vector conditions, boolean negativeRed, int numberOrDate, String numberFormatString) {
        this(name, mergeableType, formatType, group, discriminator, viewStyle, viewFormat, negativeRed, numberOrDate, numberFormatString);
    }

    public UIFormat(String name, int mergeableType, int formatType, int group, Discriminator discriminator, ViewStyle viewStyle, ViewFormat viewFormat, boolean negativeRed, int numberOrDate, String numberFormatString) {
        this.m_name = name;
        this.m_ID = UIFormat._createID();
        this.m_mergeableType = mergeableType;
        this.m_group = group;
        this.m_discriminator = discriminator;
        this.m_viewStyle = viewStyle;
        this.m_viewFormat = viewFormat;
        this.m_formatType = formatType;
        this.m_negativeRed = negativeRed;
        this.m_numberOrDate = numberOrDate;
        this.m_numberFormatString = numberFormatString;
    }

    public UIFormat(String name, int formatType, Discriminator discriminator, boolean negativeRed, int numberOrDate, String numberFormatString, ConditionElement valueCondition) {
        this.m_name = name;
        this.m_ID = UIFormat._createID();
        this.m_mergeableType = 1;
        this.m_group = 5;
        this.m_discriminator = discriminator;
        this.m_viewStyle = null;
        this.m_viewFormat = null;
        this.m_formatType = formatType;
        this.m_negativeRed = negativeRed;
        this.m_numberOrDate = numberOrDate;
        this.m_numberFormatString = numberFormatString;
        this.m_valueCondition = valueCondition;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setID(long id) {
        this.m_ID = id;
    }

    public long getID() {
        return this.m_ID;
    }

    public void setMergeableType(int type) {
        this.m_mergeableType = type;
    }

    public int getMergeableType() {
        return this.m_mergeableType;
    }

    public void setFormatType(int type) {
        this.m_formatType = type;
    }

    public int getFormatType() {
        return this.m_formatType;
    }

    public void setGroup(int group) {
        this.m_group = group;
    }

    public int getGroup() {
        return this.m_group;
    }

    public void setNegativeRed(boolean red) {
        this.m_negativeRed = red;
    }

    public boolean isNegativeRed() {
        return this.m_negativeRed;
    }

    public void setNumberOrDateCategory(int type) {
        this.m_numberOrDate = type;
    }

    public int getNumberOrDateCategory() {
        return this.m_numberOrDate;
    }

    public void setNumberOrDateFormatString(String patternString) {
        this.m_numberFormatString = patternString;
    }

    public String getNumberOrDateFormatString() {
        return this.m_numberFormatString;
    }

    public void setViewStyle(ViewStyle viewStyle) {
        this.m_viewStyle = viewStyle;
    }

    public ViewStyle getViewStyle() {
        return this.m_viewStyle;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        this.m_viewFormat = viewFormat;
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public void setDiscriminator(Discriminator discriminator) {
        this.m_discriminator = discriminator;
    }

    public Discriminator getDiscriminator() {
        return this.m_discriminator;
    }

    public void setConditions(Vector conditions) {
    }

    public Vector getConditions() {
        return null;
    }

    public void setValueCondition(ConditionElement condition) {
        this.m_valueCondition = condition;
    }

    public ConditionElement getValueCondition() {
        return this.m_valueCondition;
    }

    public void setSelected(boolean bSelected) {
        this.m_bSelected = bSelected;
    }

    public boolean isSelected() {
        return this.m_bSelected;
    }

    public void setAutomaticName(boolean automatic) {
        this.m_automaticName = automatic;
    }

    public boolean isAutomaticName() {
        return this.m_automaticName;
    }

    public void initialize(Hashtable env) {
        if (env != null && env.containsKey("migration") && env.containsKey("full_path_to_guid_converter")) {
            ObjectScope scope = new ObjectScope();
            scope.addObject("full_path_to_guid_converter", env.get("full_path_to_guid_converter"));
            XMLContext xmlcontext = new XMLContext();
            xmlcontext.setScope(scope);
            if (this.m_context == null) {
                this.m_context = new Hashtable();
            }
            this.m_context.put("xml_context", xmlcontext);
        }
    }

    public AggregateInfo[] getPersistableComponents() {
        return null;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (oldAttrs != null) {
            result.merge(oldAttrs);
        }
        result.setObjectType(TYPE);
        return result;
    }

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this.m_attrs = attrs;
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    public String getXMLAsString() throws BIPersistenceException {
        XMLObjectWriter writer = new XMLObjectWriter();
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode());
            return writer.toString();
        }
        catch (BIIOException biioe) {
            return null;
        }
    }

    public ObjectNode getObjectNode() {
        return this.getObjectNode(true);
    }

    public ObjectNode getObjectNode(boolean allProperties) {
        ObjectNode conditionNode;
        ObjectNode node = new ObjectNode(UI_FORMAT);
        node.addProperty(a_name, this.getName());
        if (this.isStoplightFormat()) {
            node.addProperty(a_automaticName, this.isAutomaticName());
        }
        node.addProperty(a_id, this.getID());
        node.addProperty(a_mergeableType, this.getMergeableType());
        node.addProperty(a_group, this.getGroup());
        node.addProperty(a_formatType, this.getFormatType());
        node.addProperty(a_negativeRed, this.isNegativeRed());
        node.addProperty(a_numberOrDate, this.getNumberOrDateCategory());
        node.addProperty(a_numberFormatString, this.getNumberOrDateFormatString());
        node.addProperty(a_selected, this.isSelected());
        if (this.getValueCondition() != null && (conditionNode = this.getValueCondition().getXML()) != null) {
            node.addProperty(a_condition, conditionNode);
        }
        if (!this.isSelected() || allProperties) {
            ObjectNode viewFormatNode;
            ObjectNode viewStyleNode;
            if (this.getViewStyle() != null && (viewStyleNode = this.getViewStyle().getXML(allProperties)) != null) {
                node.addProperty(a_viewStyle, viewStyleNode);
            }
            if (this.getViewFormat() != null && (viewFormatNode = this.getViewFormat().getXML(allProperties)) != null) {
                node.addProperty(a_viewFormat, viewFormatNode);
            }
            if (this.getDiscriminator() != null && this.getDiscriminator() instanceof DiscriminatorXML) {
                ObjectNode disc;
                if (this.m_context != null) {
                    if (this.getDiscriminator() instanceof QDRDiscriminator) {
                        ((QDRDiscriminator)this.getDiscriminator()).setContext(this.m_context);
                    } else if (this.getDiscriminator() instanceof CompositeDiscriminator) {
                        ((CompositeDiscriminator)this.getDiscriminator()).setContext(this.m_context);
                    }
                }
                if ((disc = ((DiscriminatorXML)this.getDiscriminator()).getXML(true, null, false)) != null) {
                    node.addProperty(a_discriminator, disc);
                }
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        XMLObjectReader reader = new XMLObjectReader(xml);
        ObjectNode node = null;
        try {
            node = reader.readObjectNode();
        }
        catch (Exception XMLException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException iOException) {}
            }
        }
        return this.setXML(node);
    }

    public boolean setXML(ObjectNode node) {
        ObjectNode vfNode;
        ObjectNode vsNode;
        ObjectNode discriminator;
        ObjectNode valueCondition;
        if (!node.getName().equals(UI_FORMAT)) {
            return false;
        }
        PropertyNode pNode = null;
        pNode = node.getProperty(a_name);
        if (pNode != null) {
            this.setName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_automaticName)) != null) {
            this.setAutomaticName(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_id)) != null) {
            this.setID(pNode.getValueAsLong());
        }
        if ((pNode = node.getProperty(a_mergeableType)) != null) {
            this.setMergeableType(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_group)) != null) {
            this.setGroup(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_formatType)) != null) {
            this.setFormatType(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_negativeRed)) != null) {
            this.setNegativeRed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_numberOrDate)) != null) {
            this.setNumberOrDateCategory(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_numberFormatString)) != null) {
            this.setNumberOrDateFormatString(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_selected)) != null) {
            this.setSelected(pNode.getValueAsBoolean());
        }
        if ((valueCondition = node.getPropertyValueAsObjectNode(a_condition, true)) != null) {
            ConditionElement cond = new ConditionElement();
            cond.setXML(valueCondition.getPropertyValueAsObjectNode());
            this.setValueCondition(cond);
        }
        if ((discriminator = node.getPropertyValueAsObjectNode(a_discriminator, true)) != null) {
            if ((discriminator = discriminator.getPropertyValueAsObjectNode()).getName().equals("ComposDisc")) {
                CompositeDiscriminator cDisc = new CompositeDiscriminator();
                if (this.m_context != null) {
                    cDisc.setContext(this.m_context);
                }
                boolean result = cDisc.setXML(discriminator, null, null, 2);
                this.setDiscriminator((Discriminator)cDisc);
            } else if (discriminator.getName().equals("NumValDisc")) {
                NumberValueDiscriminator nvd = new NumberValueDiscriminator();
                boolean result = nvd.setXML(discriminator, null, null, 2);
                this.setDiscriminator((Discriminator)nvd);
            } else if (discriminator.getName().equals("DateValDisc")) {
                DateValueDiscriminator dvd = new DateValueDiscriminator();
                boolean result = dvd.setXML(discriminator, null, null, 2);
                this.setDiscriminator((Discriminator)dvd);
            } else if (discriminator.getName().equals("QDRDisc")) {
                QDRDiscriminator qdrd = new QDRDiscriminator();
                if (this.m_context != null) {
                    qdrd.setContext(this.m_context);
                }
                boolean result = qdrd.setXML(discriminator, null, null, 2);
                this.setDiscriminator((Discriminator)qdrd);
            } else if (discriminator.getName().equals("StrValDisc")) {
                StringValueDiscriminator svd = new StringValueDiscriminator();
                boolean result = svd.setXML(discriminator, null, null, 2);
                this.setDiscriminator((Discriminator)svd);
            } else if (discriminator.getName().equals("TotDisc")) {
                TotalsDiscriminator td = new TotalsDiscriminator();
                boolean result = td.setXML(discriminator, null, null, 2);
                this.setDiscriminator((Discriminator)td);
            } else {
                pNode = discriminator.getProperty(a_type);
                if (pNode == null) {
                    return true;
                }
                String undefinedDiscriminatorPath = pNode.getValueAsString();
                try {
                    Class<?> undefinedDiscriminatorClass = Class.forName(undefinedDiscriminatorPath);
                    DiscriminatorXML undefinedDiscriminator = (DiscriminatorXML)undefinedDiscriminatorClass.newInstance();
                    boolean result = undefinedDiscriminator.setXML(discriminator, null, null, 2);
                    this.setDiscriminator((Discriminator)undefinedDiscriminator);
                }
                catch (Exception exception) {
                    return true;
                }
            }
        }
        if ((vsNode = node.getPropertyValueAsObjectNode(a_viewStyle)) != null) {
            ViewStyle vs = new ViewStyle();
            vs.setXML(vsNode, "", 2);
            this.setViewStyle(vs);
        }
        if ((vfNode = node.getPropertyValueAsObjectNode(a_viewFormat)) != null) {
            ViewFormat vf = new ViewFormat();
            vf.setXML(vfNode, "", 2);
            this.setViewFormat(vf);
        }
        return true;
    }

    private static synchronized long _createID() {
        long id = System.currentTimeMillis();
        while (id == m_lastID) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            id = System.currentTimeMillis();
        }
        m_lastID = id;
        return id;
    }

    public Object clone() {
        UIFormat myClone = new UIFormat();
        myClone.setName(this.getName());
        myClone.setID(this.getID());
        myClone.setMergeableType(this.getMergeableType());
        myClone.setGroup(this.getGroup());
        myClone.setFormatType(this.getFormatType());
        if (this.getDiscriminator() != null) {
            myClone.setDiscriminator((Discriminator)this.getDiscriminator().clone());
        }
        if (this.hasViewFormat() && this.getViewFormat() != null) {
            myClone.setViewFormat((ViewFormat)this.getViewFormat().clone());
        } else {
            myClone.setViewFormat(new ViewFormat());
        }
        if (this.hasViewStyle() && this.getViewStyle() != null) {
            myClone.setViewStyle((ViewStyle)this.getViewStyle().clone());
        } else {
            myClone.setViewStyle(new ViewStyle());
        }
        myClone.setNegativeRed(this.isNegativeRed());
        myClone.setNumberOrDateCategory(this.getNumberOrDateCategory());
        myClone.setNumberOrDateFormatString(this.getNumberOrDateFormatString());
        myClone.setSelected(this.isSelected());
        if (this.getValueCondition() != null) {
            myClone.setValueCondition((ConditionElement)((Object)this.getValueCondition().clone()));
        }
        return myClone;
    }

    public void setStateAsObjectNode(ResourceBundle rBundle, List context, ObjectNode node, UIFormat baseState) {
        if (node == null) {
            return;
        }
        String group = node.getName();
        if (!(group.equals(S_STOPLIGHT_FORMAT) || group.equals(S_CONDITIONAL_FORMAT) || group.equals(S_HEADER_FORMAT) || group.equals(S_TOOLBAR_FORMAT))) {
            return;
        }
        this.setGroup(group);
        PropertyNode pNode = null;
        pNode = node.getProperty(s_defaultName);
        if (pNode != null) {
            String defaultName = rBundle.getString(defaultFormatNames[this.getGroup()]);
            this.setName(defaultName + pNode.getValueAsString());
        } else {
            pNode = node.getProperty(s_name);
            if (pNode != null) {
                this.setName(pNode.getValueAsString());
            } else if (baseState != null) {
                this.setName(baseState.getName());
            }
        }
        pNode = node.getProperty(s_id);
        if (pNode != null) {
            this.setID(pNode.getValueAsLong());
        }
        if ((pNode = node.getProperty(s_mergeableType)) != null) {
            this.setMergeableType(pNode.getValueAsInteger());
        } else if (baseState != null) {
            this.setMergeableType(baseState.getMergeableType());
        }
        pNode = node.getProperty(s_group);
        if (pNode != null) {
            this.setGroup(pNode.getValueAsInteger());
        } else if (baseState != null) {
            this.setGroup(baseState.getGroup());
        }
        pNode = node.getProperty(s_formatType);
        if (pNode != null) {
            this.setFormatType(pNode.getValueAsInteger());
        } else if (baseState != null) {
            this.setFormatType(baseState.getFormatType());
        }
        pNode = node.getProperty(s_negativeRed);
        if (pNode != null) {
            this.setNegativeRed(Utility.getValueAsBoolean((PropertyNode)pNode));
        } else if (baseState != null) {
            this.setNegativeRed(baseState.isNegativeRed());
        }
        pNode = node.getProperty(s_selected);
        if (pNode != null) {
            this.setSelected(Utility.getValueAsBoolean((PropertyNode)pNode));
        } else if (baseState != null) {
            this.setSelected(baseState.isSelected());
        }
        pNode = node.getProperty(s_noCondition);
        if (pNode != null) {
            if (this.getGroup() == 5) {
                this.setValueCondition(new ConditionElement());
            } else {
                this.setValueCondition(null);
            }
        } else {
            ConditionElement baseCond;
            ConditionElement cond = this.getValueCondition();
            if (cond == null) {
                cond = baseState == null || baseState.getValueCondition() == null ? new ConditionElement() : (ConditionElement)((Object)baseState.getValueCondition().clone());
            }
            ConditionElement conditionElement = baseCond = baseState == null ? null : baseState.getValueCondition();
            if (this.isStoplightFormat()) {
                cond.setStateAsObjectNode(node, baseCond, true);
                this.setValueCondition(cond);
            } else if (this.isDatabodyFormat() && cond.setStateAsObjectNode(node, baseCond, false)) {
                this.setValueCondition(cond);
            }
        }
        if (context != null && context.size() > 0 && context.get(0) instanceof DimensionMetadata) {
            pNode = node.getProperty(s_dimensions);
            if (pNode != null && context != null) {
                ConditionElement.setDimensionListState((List)this.getDimensionList(context), (String)pNode.getValueAsString());
            }
        } else {
            Discriminator baseDisc = baseState == null ? null : baseState.getDiscriminator();
            DiscriminatorState discState = baseDisc instanceof DiscriminatorState ? (DiscriminatorState)baseDisc : null;
            Discriminator disc = CompositeDiscriminator.createDiscriminator((List)context, (ObjectNode)node, (DiscriminatorState)discState);
            if (disc != null) {
                this.setDiscriminator(disc);
            } else if (baseDisc == null) {
                this.setDiscriminator(null);
            } else {
                this.setDiscriminator((Discriminator)baseDisc.clone());
            }
        }
        if (this.hasViewFormat()) {
            pNode = node.getProperty(s_numberOrDate);
            if (pNode != null) {
                this.setNumberOrDateCategory(pNode.getValueAsInteger());
            } else if (baseState != null) {
                this.setNumberOrDateCategory(baseState.getNumberOrDateCategory());
            }
            pNode = node.getProperty(s_numberFormatString);
            if (pNode != null) {
                this.setNumberOrDateFormatString(pNode.getValueAsString());
            } else if (baseState != null) {
                this.setNumberOrDateFormatString(baseState.getNumberOrDateFormatString());
            }
            ObjectNode vfNode = node.getPropertyValueAsObjectNode(s_viewFormat, true);
            if (vfNode != null) {
                if (this.getViewFormat() == null) {
                    this.setViewFormat(new ViewFormat());
                }
                this.getViewFormat().setStateAsObjectNode(vfNode, baseState == null ? null : baseState.getViewFormat());
            }
        } else if (this.isDatabodyFormat()) {
            this.setViewFormat(new ViewFormat());
        } else {
            this.setViewFormat(null);
        }
        if (this.hasViewStyle()) {
            ObjectNode vsNode = node.getPropertyValueAsObjectNode(s_viewStyle, true);
            if (vsNode != null) {
                if (this.getViewStyle() == null) {
                    this.setViewStyle(new ViewStyle());
                }
                this.getViewStyle().setStateAsObjectNode(vsNode, baseState == null ? null : baseState.getViewStyle());
            }
        } else if (this.isStoplightFormat()) {
            this.setViewStyle(null);
        } else {
            this.setViewStyle(new ViewStyle());
        }
        this.setPosition(null);
    }

    public ObjectNode getStateAsObjectNode(ResourceBundle rBundle, List memberContext, UIFormat baseState, int options, boolean hasState) {
        ViewStyle vs;
        ObjectNode vsNode;
        DiscriminatorState discState;
        DiscriminatorState discriminator;
        ObjectNode disc;
        if (!this.m_editable) {
            return null;
        }
        ObjectNode node = new ObjectNode(this.getStateName());
        if ((options & 2) == 0) {
            node.addProperty(s_positions, this.getPosition());
        } else {
            node.addProperty(s_positions, FIELD_SEPARATOR);
        }
        if (options == 1) {
            return node;
        }
        if (baseState == null) {
            baseState = UIFormat.getDefaultFormat(this.getGroup());
        }
        if (!Utility.compareObj((Object)baseState.getName(), (Object)this.getName())) {
            String defaultName = rBundle.getString(defaultFormatNames[this.getGroup()]);
            if (this.getName().startsWith(defaultName)) {
                node.addProperty(s_defaultName, this.getName().substring(defaultName.length()));
            } else {
                node.addProperty(s_name, this.getName());
            }
            hasState = true;
        }
        if (baseState.getID() != this.getID()) {
            node.addProperty(s_id, this.getID());
            hasState = true;
        }
        if (baseState.getMergeableType() != this.getMergeableType()) {
            node.addProperty(s_mergeableType, this.getMergeableType());
            hasState = true;
        }
        if (baseState.getGroup() != this.getGroup()) {
            node.addProperty(s_group, this.getGroup());
            hasState = true;
        }
        if (baseState.getFormatType() != this.getFormatType()) {
            node.addProperty(s_formatType, this.getFormatType());
            hasState = true;
        }
        if (baseState.isNegativeRed() != this.isNegativeRed()) {
            node.addProperty(s_negativeRed, Utility.getBooleanAsChar((boolean)this.isNegativeRed()));
            hasState = true;
        }
        if (baseState.isSelected() != this.isSelected()) {
            node.addProperty(s_selected, Utility.getBooleanAsChar((boolean)this.isSelected()));
            hasState = true;
        }
        if ((options & 2) != 0 && this.m_dimensions != null && this.isSelectionEditable()) {
            String state = ConditionElement.getDimensionListState((List)this.m_dimensions);
            if (state != null && state.length() >= 0) {
                node.addProperty(s_dimensions, ConditionElement.getDimensionListState((List)this.m_dimensions));
                hasState = true;
            }
        } else if (!Utility.compareObj((Object)baseState.getDiscriminator(), (Object)this.getDiscriminator()) && this.getDiscriminator() instanceof DiscriminatorState && (disc = (discriminator = (DiscriminatorState)this.getDiscriminator()).getStateAsObjectNode(memberContext, discState = baseState.getDiscriminator() instanceof DiscriminatorState ? (DiscriminatorState)baseState.getDiscriminator() : null)) != null) {
            node.addProperty(disc);
            hasState = true;
        }
        if (this.hasViewFormat()) {
            ViewFormat vf;
            ObjectNode vfNode;
            if (baseState.getNumberOrDateCategory() != this.getNumberOrDateCategory()) {
                node.addProperty(s_numberOrDate, this.getNumberOrDateCategory());
                hasState = true;
            }
            if (!Utility.compareObj((Object)baseState.getNumberOrDateFormatString(), (Object)this.getNumberOrDateFormatString())) {
                node.addProperty(s_numberFormatString, this.getNumberOrDateFormatString());
                hasState = true;
            }
            if (!Utility.compareObj((Object)baseState.getViewFormat(), (Object)this.getViewFormat()) && (vfNode = (vf = this.getViewFormat() == null ? new ViewFormat() : this.getViewFormat()).getStateAsObjectNode(s_viewFormat, baseState.getViewFormat())) != null) {
                node.addProperty(vfNode);
                this.setViewFormat(vf);
                hasState = true;
            }
        }
        if (this.hasViewStyle() && !Utility.compareObj((Object)baseState.getViewStyle(), (Object)this.getViewStyle()) && (vsNode = (vs = this.getViewStyle() == null ? new ViewStyle() : this.getViewStyle()).getStateAsObjectNode(s_viewStyle, baseState.getViewStyle())) != null) {
            node.addProperty(vsNode);
            this.setViewStyle(vs);
            hasState = true;
        }
        if (this.getValueCondition() == null && baseState.getValueCondition() != null) {
            node.addProperty(s_noCondition, Utility.getBooleanAsChar((boolean)true));
            hasState = true;
        } else if (this.getValueCondition() != null && (this.isStoplightFormat() || this.isDatabodyFormat()) && this.getValueCondition().addConditionProperty(node, baseState.getValueCondition())) {
            hasState = true;
        }
        return hasState ? node : null;
    }

    public static UIFormat getDefaultHeaderFormat() {
        if (m_defaultHeaderFormat == null) {
            m_defaultHeaderFormat = UIFormat.createDefaultHeaderFormat();
        }
        return m_defaultHeaderFormat;
    }

    public static UIFormat getDefaultConditionalFormat() {
        if (m_defaultDataFormat == null) {
            m_defaultDataFormat = UIFormat.createDefaultConditionalFormat();
        }
        return m_defaultDataFormat;
    }

    public static UIFormat getDefaultStoplight() {
        if (m_defaultStoplight == null) {
            m_defaultStoplight = UIFormat.createDefaultStoplight();
        }
        return m_defaultStoplight;
    }

    public static UIFormat getDefaultDataSelection() {
        if (m_defaultDataSelection == null) {
            m_defaultDataSelection = UIFormat.createDefaultDataSelection();
        }
        return m_defaultDataSelection;
    }

    public static UIFormat createDefaultHeaderFormat() {
        UIFormat format = new UIFormat();
        format.setMergeableType(0);
        format.setGroup(3);
        format.setFormatType(3);
        format.setNumberOrDateCategory(-1);
        format.setViewStyle(new ViewStyle());
        format.setNegativeRed(false);
        format.setSelected(true);
        format.setID(UIFormat._createID());
        return format;
    }

    public static UIFormat createDefaultDataSelection() {
        UIFormat format = new UIFormat();
        format.setMergeableType(1);
        format.setGroup(2);
        format.setFormatType(3);
        format.setViewStyle(new ViewStyle());
        format.setViewFormat(new ViewFormat());
        format.setNegativeRed(false);
        format.setNumberOrDateCategory(-1);
        format.setSelected(true);
        format.setID(UIFormat._createID());
        return format;
    }

    public static UIFormat createDefaultHeaderSelection() {
        UIFormat format = new UIFormat();
        format.setMergeableType(0);
        format.setGroup(1);
        format.setFormatType(3);
        format.setViewStyle(new ViewStyle());
        format.setSelected(true);
        format.setID(UIFormat._createID());
        return format;
    }

    public static UIFormat createDefaultConditionalFormat() {
        UIFormat format = UIFormat.createDefaultDataSelection();
        format.setMergeableType(3);
        format.setGroup(4);
        return format;
    }

    public static UIFormat createDefaultToolbarStoplight() {
        UIFormat format = new UIFormat();
        format.setMergeableType(1);
        format.setGroup(5);
        format.setFormatType(3);
        format.setNegativeRed(false);
        format.setNumberOrDateCategory(-1);
        format.setSelected(true);
        format.setID(UIFormat._createID());
        return format;
    }

    public static UIFormat createDefaultStoplight() {
        return UIFormat.createDefaultToolbarStoplight();
    }

    public static UIFormat createToolbarStoplightFormat(String dataType) {
        UIFormat format = UIFormat.createDefaultToolbarStoplight();
        ConditionElement condition = new ConditionElement(null, null, dataType);
        format.setValueCondition(condition);
        return format;
    }

    public static UIFormat createStoplightFormat() {
        UIFormat format = UIFormat.createToolbarStoplightFormat(null);
        format.setFormatType(3);
        return format;
    }

    private static boolean compareMergeable(Mergeable mergeable1, Mergeable mergeable2) {
        if (mergeable1 == null && mergeable2 == null) {
            return true;
        }
        if (mergeable1 != null && mergeable2 == null) {
            return !mergeable1.isAnythingOverridden();
        }
        if (mergeable1 == null && mergeable2 != null) {
            return !mergeable2.isAnythingOverridden();
        }
        return mergeable1.equals(mergeable2);
    }

    public boolean equals(UIFormat format) {
        if (this == format) {
            return true;
        }
        if (format.getID() != this.getID()) {
            return false;
        }
        if (!Utility.compareObj((Object)format.getName(), (Object)this.getName())) {
            return false;
        }
        if (format.getMergeableType() != this.getMergeableType()) {
            return false;
        }
        if (format.getGroup() != this.getGroup()) {
            return false;
        }
        if (format.getFormatType() != this.getFormatType()) {
            return false;
        }
        if (format.isNegativeRed() != this.isNegativeRed()) {
            return false;
        }
        if (format.isSelected() != this.isSelected()) {
            return false;
        }
        if (!Utility.compareObj((Object)format.getDiscriminator(), (Object)this.getDiscriminator())) {
            return false;
        }
        if (this.hasViewFormat()) {
            if (format.getNumberOrDateCategory() != this.getNumberOrDateCategory()) {
                return false;
            }
            if (!Utility.compareObj((Object)format.getNumberOrDateFormatString(), (Object)this.getNumberOrDateFormatString())) {
                return false;
            }
            if (!UIFormat.compareMergeable((Mergeable)format.getViewFormat(), (Mergeable)this.getViewFormat())) {
                return false;
            }
        }
        if (this.hasViewStyle() && !UIFormat.compareMergeable((Mergeable)format.getViewStyle(), (Mergeable)this.getViewStyle())) {
            return false;
        }
        return !this.isStoplightFormat() && !this.isDatabodyFormat() || Utility.compareObj((Object)((Object)format.getValueCondition()), (Object)((Object)this.getValueCondition()));
    }

    public boolean equals(Object o) {
        if (o instanceof UIFormat) {
            return this.equals((UIFormat)o);
        }
        return false;
    }

    protected boolean IDequals(UIFormat format) {
        return format.getID() == this.getID();
    }

    protected void setPosition(String position) {
        this.m_position = position;
    }

    protected String getPosition() {
        return this.m_position;
    }

    protected String getStateName() {
        return stateNames[this.getGroup()];
    }

    protected void setGroup(String stateName) {
        if (this.getGroup() == 0) {
            this.setGroup(Integer.valueOf(stateName.substring(1)));
        }
    }

    public boolean isStoplightFormat() {
        return this.getGroup() == 5;
    }

    public boolean isDatabodyFormat() {
        return this.getGroup() == 4 || this.getGroup() == 2;
    }

    protected boolean hasViewFormat() {
        return (this.getMergeableType() & 2) != 0;
    }

    protected boolean hasViewStyle() {
        if (this.isStoplightFormat()) {
            return false;
        }
        if (this.getMergeableType() == 0) {
            return true;
        }
        return (this.getMergeableType() & 1) != 0;
    }

    public static UIFormat getDefaultFormat(int group) {
        UIFormat format = null;
        switch (group) {
            case 2: {
                format = UIFormat.getDefaultDataSelection();
                break;
            }
            case 3: {
                format = UIFormat.getDefaultHeaderFormat();
                break;
            }
            case 5: {
                format = UIFormat.getDefaultStoplight();
                break;
            }
            default: {
                format = UIFormat.getDefaultConditionalFormat();
            }
        }
        return format;
    }

    public static void setFormatState(ResourceBundle rBundle, List memberContext, ObjectNode node, List formatList, List currentList) {
        boolean isCheckpoint = false;
        PropertyNode pNode = node.getProperty(s_positions);
        if (pNode == null) {
            return;
        }
        String position = pNode.getValueAsString();
        int separator = position.indexOf(FIELD_SEPARATOR);
        if (separator == -1) {
            int index = Integer.valueOf(position);
            UIFormat source = (UIFormat)formatList.get(index);
            UIFormat current = (UIFormat)source.clone();
            current.setStateAsObjectNode(rBundle, memberContext, node, source);
            formatList.set(index, current);
        } else {
            boolean hasIndex2;
            String index1 = position.substring(0, separator);
            String index2 = position.substring(separator + 1);
            boolean hasIndex1 = index1 != null && index1.length() > 0;
            boolean bl = hasIndex2 = index2 != null && index2.length() > 0;
            if (hasIndex1 && !hasIndex2) {
                formatList.remove(Integer.valueOf(index1));
            } else if (!hasIndex1) {
                String groupString = node.getName().substring(1);
                int group = Integer.valueOf(groupString);
                UIFormat format = (UIFormat)UIFormat.getDefaultFormat(group).clone();
                format.setStateAsObjectNode(rBundle, memberContext, node, null);
                if (hasIndex2) {
                    formatList.add(Integer.valueOf(index2), format);
                } else {
                    formatList.add(format);
                }
            } else {
                int fromIndex = Integer.valueOf(index1);
                int toIndex = Integer.valueOf(index2);
                UIFormat source = (UIFormat)formatList.get(fromIndex);
                UIFormat current = (UIFormat)source.clone();
                current.setStateAsObjectNode(rBundle, memberContext, node, source);
                formatList.remove(fromIndex);
                formatList.add(toIndex, current);
            }
        }
    }

    public static void setFormatListState(ResourceBundle rBundle, List memberContext, ContainerNode formatsNode, List formatList, List currentList) {
        if (DEBUG) {
            UIFormat.dumpList("Source list", formatList);
        }
        Enumeration e = formatsNode.getContainedObject();
        while (e.hasMoreElements()) {
            ObjectNode node = (ObjectNode)e.nextElement();
            String stateName = node.getName();
            if (!stateName.equals(S_STOPLIGHT_FORMAT) && !stateName.equals(S_HEADER_FORMAT) && !stateName.equals(S_CONDITIONAL_FORMAT) && !stateName.equals(S_TOOLBAR_FORMAT)) continue;
            UIFormat.setFormatState(rBundle, memberContext, node, formatList, currentList);
        }
        if (DEBUG) {
            UIFormat.dumpList("Destination list", formatList);
        }
    }

    protected ObjectNode addDeltaState(ResourceBundle rBundle, List memberContext, ContainerNode formatsNode, UIFormat baseState, int index, int index2) {
        if (this.getPosition() != null) {
            return null;
        }
        StringBuffer position = new StringBuffer();
        int positionOnly = 0;
        boolean hasState = true;
        switch (index2) {
            case -1: {
                position.append(index + FIELD_SEPARATOR);
                positionOnly = 1;
                break;
            }
            case -2: {
                position.append(index);
                hasState = false;
                break;
            }
            case -3: {
                position.append(FIELD_SEPARATOR + index);
                break;
            }
            case -4: {
                position.append(FIELD_SEPARATOR);
                break;
            }
            default: {
                position.append(index + FIELD_SEPARATOR + index2);
            }
        }
        this.setPosition(position.toString());
        ObjectNode node = this.getStateAsObjectNode(rBundle, memberContext, baseState, positionOnly, hasState);
        if (node != null) {
            formatsNode.addContainedObject((BaseNode)node);
        }
        return node;
    }

    public static boolean getFormatListState(ResourceBundle rBundle, List memberContext, ContainerNode formatsNode, List source, List destination) {
        UIFormat srcEntry;
        if (source != null) {
            for (int src = 0; src < source.size(); ++src) {
                UIFormat srcEntry2 = (UIFormat)source.get(src);
                srcEntry2.setPosition(null);
            }
        }
        if (destination != null && destination.size() > 0) {
            for (int dest = 0; dest < destination.size(); ++dest) {
                UIFormat destEntry = (UIFormat)destination.get(dest);
                destEntry.setPosition(null);
            }
        }
        boolean hasState = false;
        int src = 0;
        int dest = 0;
        if (DEBUG) {
            UIFormat.dumpList("Source list:", source);
            UIFormat.dumpList("Destination list:", destination);
        }
        while (destination != null && source != null && dest < destination.size() && src < source.size()) {
            Object obj;
            UIFormat destEntry;
            srcEntry = (UIFormat)source.get(src);
            if (srcEntry.IDequals(destEntry = (UIFormat)destination.get(dest))) {
                if (destEntry.addDeltaState(rBundle, memberContext, formatsNode, srcEntry, src, -2) != null) {
                    hasState = true;
                }
                ++dest;
                ++src;
                continue;
            }
            int destIndex = UIFormat.search(destination, srcEntry, dest + 1);
            int srcIndex = -1;
            if (destIndex == -1) {
                srcEntry.addDeltaState(rBundle, memberContext, formatsNode, null, src, -1);
                source.remove(src);
                hasState = true;
                continue;
            }
            srcIndex = UIFormat.search(source, destEntry, src + 1);
            if (srcIndex == -1) {
                hasState = true;
                destEntry.addDeltaState(rBundle, memberContext, formatsNode, null, src, -3);
                source.add(src, destEntry.clone());
                ++src;
                ++dest;
                continue;
            }
            if (src + 1 == srcIndex && UIFormat.lookAhead(source, destination, src + 2, dest + 1, destIndex) == destIndex) {
                srcIndex = destIndex;
                UIFormat target = (UIFormat)destination.get(destIndex);
                target.addDeltaState(rBundle, memberContext, formatsNode, srcEntry, src, srcIndex);
                obj = source.remove(src);
                source.add(srcIndex, obj);
                hasState = true;
                continue;
            }
            UIFormat origin = (UIFormat)source.get(srcIndex);
            destEntry.addDeltaState(rBundle, memberContext, formatsNode, origin, srcIndex, src);
            obj = source.remove(srcIndex);
            source.add(src, obj);
            hasState = true;
            ++src;
            ++dest;
        }
        while (source != null && src < source.size()) {
            hasState = true;
            srcEntry = (UIFormat)source.get(src);
            srcEntry.addDeltaState(rBundle, memberContext, formatsNode, null, src, -1);
            source.remove(src);
        }
        while (destination != null && dest < destination.size()) {
            hasState = true;
            UIFormat destEntry = (UIFormat)destination.get(dest);
            destEntry.addDeltaState(rBundle, memberContext, formatsNode, null, dest, -3);
            ++dest;
        }
        return hasState;
    }

    private static void dumpList(String header, List list) {
        System.out.println(header);
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            UIFormat entry = (UIFormat)list.get(i);
            System.out.println("i = " + i + ": " + entry.getID() + "; state: " + stateNames[entry.getGroup()]);
        }
    }

    protected static UIFormat getFormat(List list, UIFormat entry, int start) {
        for (int i = start; i < list.size(); ++i) {
            if (!((UIFormat)list.get(i)).IDequals(entry)) continue;
            return (UIFormat)list.get(i);
        }
        return (UIFormat)entry.clone();
    }

    protected static int search(List list, UIFormat entry, int start) {
        int index = -1;
        for (int i = start; i < list.size(); ++i) {
            if (!((UIFormat)list.get(i)).IDequals(entry)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected static int lookAhead(List source, List destination, int sbegin, int dbegin, int dend) {
        int s = sbegin;
        for (int d = dbegin; s < source.size() && d < dend; ++s, ++d) {
            UIFormat dEntry;
            UIFormat sEntry = (UIFormat)source.get(s);
            if (sEntry.IDequals(dEntry = (UIFormat)destination.get(d))) continue;
            return s;
        }
        return s - 1;
    }

    public static boolean compareList(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 != null && list2 == null || list1 == null && list2 != null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.equals(list2);
    }

    public static List deepCloneFormats(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> cloneList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof UIFormat)) continue;
            cloneList.add(((UIFormat)obj).clone());
        }
        return cloneList;
    }

    public static List shallowCloneFormats(List list) {
        if (list == null) {
            return null;
        }
        return (List)((ArrayList)list).clone();
    }

    public void setDirty(boolean flag) {
        this.m_isDirty = flag;
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDimensionList(List dimensions) {
        this.m_dimensions = dimensions;
    }

    public List getDimensionList(List defaultDimMemList) {
        if (defaultDimMemList != null && this.m_dimensions == null) {
            this.m_dimensions = this.createDimensionMemberList(defaultDimMemList);
        }
        return this.m_dimensions;
    }

    private List createDimensionMemberList(List defaultList) {
        DimensionMetadata dimension;
        QDR qdr;
        ArrayList<ConditionElement> list = new ArrayList<ConditionElement>();
        ConditionElement condition = null;
        QDRDiscriminator disc = this.getQDRDiscriminator();
        QDR qDR = qdr = disc == null ? null : disc.getQDR();
        if (qdr == null) {
            for (int i = 0; i < defaultList.size(); ++i) {
                if (!(defaultList.get(i) instanceof DimensionMetadata)) continue;
                dimension = (DimensionMetadata)defaultList.get(i);
                condition = new ConditionElement(dimension.getDimID(), (String)null);
                condition.setMetadata(dimension);
                condition.setStoplightOK(dimension.isMeasure());
                condition.setSelected(false);
                list.add(condition);
            }
        } else {
            for (int i = 0; i < defaultList.size(); ++i) {
                if (!(defaultList.get(i) instanceof DimensionMetadata)) continue;
                dimension = (DimensionMetadata)defaultList.get(i);
                String dimID = dimension.getDimID();
                QDRMember member = qdr.getDimMember(dimID);
                if (member == null) {
                    condition = new ConditionElement(dimID, (Object)null);
                } else if (member.getData() instanceof Vector) {
                    Vector memberData = (Vector)member.getData();
                    condition = new ConditionElement(dimID, new Vector(memberData));
                    Enumeration elements = memberData.elements();
                    while (elements.hasMoreElements() && this.m_editable) {
                        String element = (String)elements.nextElement();
                        if (dimension.getMemberLabel(element) != null) continue;
                        this.m_editable = false;
                    }
                } else {
                    condition = new ConditionElement(dimID, member.getData());
                    if (dimension.getMemberLabel((String)member.getData()) == null) {
                        this.m_editable = false;
                    }
                }
                condition.setMetadata(dimension);
                condition.setSelected(false);
                condition.setStoplightOK(dimension.isMeasure());
                list.add(condition);
            }
            String measureDim = qdr.getMeasureDim();
            Object data = null;
            if (measureDim != null && qdr.getDimMember(measureDim) != null) {
                data = qdr.getDimMember(measureDim).getData();
            }
            if (data instanceof Vector) {
                Vector vector = (Vector)data;
                for (int i = 0; i < vector.size(); ++i) {
                    this._setConditionSelected(list, (String)vector.elementAt(i));
                }
            } else if (data != null) {
                this._setConditionSelected(list, (String)data);
            }
        }
        if (this.isHeaderFormat()) {
            ArrayList<Object> target = null;
            if (qdr != null) {
                target = new ArrayList<Object>();
                QDRMember member = qdr.getTarget();
                if (member != null && member.getData() != null) {
                    Object data = member.getData();
                    if (member.getType() == 0) {
                        target.add(member.getData());
                    } else if (member.getType() == 3) {
                        target.addAll((Vector)member.getData());
                    }
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                condition = (ConditionElement)((Object)list.get(i));
                if (target == null || !target.contains(condition.getDimension())) continue;
                condition.setSelected(true);
            }
        }
        return list;
    }

    private void _setConditionSelected(List list, String member) {
        for (int i = 0; i < list.size(); ++i) {
            ConditionElement condition = (ConditionElement)((Object)list.get(i));
            if (condition == null || !condition.getDimension().equals(member)) continue;
            condition.setSelected(true);
            break;
        }
    }

    public void setUIDiscriminator() {
        QDRDiscriminator qdrDisc;
        if (!this.isSelectionEditable()) {
            return;
        }
        ValueDiscriminator valueDisc = null;
        if (this.getValueCondition() != null && (this.getGroup() == 4 || this.getGroup() == 2)) {
            valueDisc = this.getValueCondition().toValueDiscriminator();
        }
        QDR qdr = new QDR();
        List dimensionList = this.m_dimensions;
        Vector<String> target = null;
        if (dimensionList != null) {
            if (this.isHeaderFormat()) {
                target = new Vector<String>();
            }
            for (int i = 0; i < dimensionList.size(); ++i) {
                ConditionElement condition = (ConditionElement)((Object)dimensionList.get(i));
                String dimension = condition.getDimension();
                Object data = condition.getData();
                QDRMember member = null;
                if (data != null) {
                    member = data instanceof Vector ? new QDRMember(3, data) : new QDRMember(0, data);
                    qdr.addDimMemberPair(dimension, member);
                    if (target == null) continue;
                    target.add(dimension);
                    continue;
                }
                if (target == null || !condition.isSelected()) continue;
                target.add(dimension);
            }
            if (target != null) {
                if (target.size() == 0) {
                    qdr.setTarget(null);
                } else if (target.size() == 1) {
                    qdr.setTarget(new QDRMember(0, target.elementAt(0)));
                } else {
                    qdr.setTarget(new QDRMember(3, target));
                }
            }
        }
        if ((qdrDisc = this.getQDRDiscriminator()) == null) {
            qdrDisc = new QDRDiscriminator(qdr, 4);
        } else {
            qdrDisc.setQDR(qdr);
        }
        if (valueDisc == null) {
            this.setDiscriminator((Discriminator)qdrDisc);
        } else {
            CompositeDiscriminator disc = new CompositeDiscriminator((Discriminator)qdrDisc, (Discriminator)valueDisc, 0);
            this.setDiscriminator((Discriminator)new CompositeDiscriminator((Discriminator)new TotalsDiscriminator(), (Discriminator)disc, 0));
        }
    }

    public void setUIDiscriminator(String measureID) {
        QDRDiscriminator qdrDisc;
        if (!this.isSelectionEditable()) {
            return;
        }
        ValueDiscriminator valueDisc = null;
        if (this.getValueCondition() != null && (this.getGroup() == 4 || this.getGroup() == 2)) {
            valueDisc = this.getValueCondition().toValueDiscriminator();
        }
        QDR qdr = null;
        List dimensionList = this.m_dimensions;
        Vector<String> data = new Vector<String>();
        if (dimensionList != null) {
            for (int i = 0; i < dimensionList.size(); ++i) {
                ConditionElement condition = (ConditionElement)((Object)dimensionList.get(i));
                if (!condition.isSelected()) continue;
                data.add(condition.getDimension());
            }
            switch (data.size()) {
                case 0: {
                    qdr = new QDR();
                    break;
                }
                case 1: {
                    qdr = new QDR(measureID, measureID, (String)data.get(0));
                    break;
                }
                default: {
                    qdr = new QDR(measureID, measureID, new QDRMember(3, data));
                }
            }
        }
        if ((qdrDisc = this.getQDRDiscriminator()) == null) {
            qdrDisc = new QDRDiscriminator(qdr, 4);
        } else {
            qdrDisc.setQDR(qdr);
        }
        if (valueDisc == null) {
            this.setDiscriminator((Discriminator)qdrDisc);
        } else {
            CompositeDiscriminator disc = new CompositeDiscriminator((Discriminator)qdrDisc, (Discriminator)valueDisc, 0);
            this.setDiscriminator((Discriminator)new CompositeDiscriminator((Discriminator)new TotalsDiscriminator(), (Discriminator)disc, 0));
        }
    }

    private QDRDiscriminator getQDRDiscriminatorSkipTotals(Discriminator disc) {
        if (disc instanceof QDRDiscriminator) {
            return (QDRDiscriminator)disc;
        }
        if (disc instanceof CompositeDiscriminator) {
            CompositeDiscriminator comp = (CompositeDiscriminator)disc;
            if (comp.getLeft() instanceof TotalsDiscriminator && (disc = this.getQDRDiscriminatorSkipTotals(comp.getRight())) != null) {
                return (QDRDiscriminator)disc;
            }
            if (comp.getRight() instanceof TotalsDiscriminator && (disc = this.getQDRDiscriminatorSkipTotals(comp.getLeft())) != null) {
                return (QDRDiscriminator)disc;
            }
            disc = this.getQDRDiscriminatorSkipTotals(comp.getLeft());
            if (disc != null) {
                return (QDRDiscriminator)disc;
            }
            disc = this.getQDRDiscriminatorSkipTotals(comp.getRight());
            if (disc != null) {
                return (QDRDiscriminator)disc;
            }
        }
        return null;
    }

    private QDRDiscriminator getQDRDiscriminator() {
        Discriminator disc = this.getDiscriminator();
        return this.getQDRDiscriminatorSkipTotals(disc);
    }

    public static Discriminator getDiscriminatorStripTotals(Discriminator disc) {
        if (disc instanceof QDRDiscriminator || disc instanceof ValueDiscriminator) {
            return disc;
        }
        if (disc instanceof CompositeDiscriminator) {
            CompositeDiscriminator comp = (CompositeDiscriminator)disc;
            if (comp.getLeft() instanceof TotalsDiscriminator) {
                return UIFormat.getDiscriminatorStripTotals(comp.getRight());
            }
            if (comp.getRight() instanceof TotalsDiscriminator) {
                return UIFormat.getDiscriminatorStripTotals(comp.getLeft());
            }
            if (comp.getRight() instanceof ValueDiscriminator) {
                return comp.getLeft();
            }
            if (comp.getLeft() instanceof ValueDiscriminator) {
                return comp.getRight();
            }
        }
        return disc;
    }

    public boolean isSelectionEditable() {
        if (this.m_editable) {
            Discriminator disc = this.getDiscriminator();
            if (disc == null || disc instanceof QDRDiscriminator) {
                return true;
            }
            if (this.getGroup() == 4 || this.getGroup() == 5) {
                return !((disc = UIFormat.getDiscriminatorStripTotals(disc)) instanceof CompositeDiscriminator);
            }
        }
        return false;
    }

    public void clearCache() {
        this.m_dimensions = null;
    }

    public boolean isHeaderFormat() {
        return this.getGroup() == 3 || this.getGroup() == 1;
    }

    public void setDesirableGreaterThanThreshold(boolean flag) {
        this.m_desirableGreaterThanThreshold = flag;
    }

    public boolean isDesirableGreaterThanThreshold() {
        return this.m_desirableGreaterThanThreshold;
    }
}

