/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Frame;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.ewt.help.HelpProvider;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PageSetupDialog;
import oracle.dss.dataView.gui.PreviewDialog;
import oracle.dss.dataView.gui.PreviewDialogProvider;
import oracle.dss.dataView.gui.PrintDialog;
import oracle.dss.dataView.gui.PrintDialogsProvider;

public class PrintDialogsAdapter
implements PrintDialogsProvider,
PreviewDialogProvider {
    protected HelpProvider m_helpProvider;
    private PrintDialog m_printDialog = null;
    private PrinterJob m_printerJob = null;
    private Locale m_locale = null;
    private PageSetupDialog m_pageSetup = null;
    private ViewPrinter m_viewPrinter;
    private ResourceBundle dvStrings = null;

    public PrintDialogsAdapter(ViewPrinter printer, PrintDialog dialog, PrinterJob printerJob) {
        this.m_printerJob = printerJob;
        this.m_printDialog = dialog;
        this.m_viewPrinter = printer;
        this.setLocale(this.m_viewPrinter.getDataview().getLocale());
    }

    @Override
    public void showPrintDialog(Frame f) {
        if (this.m_printDialog != null && this.m_printDialog.isSystemPrintDialogDisplayed() && !this.m_printerJob.printDialog()) {
            return;
        }
        if (this.m_viewPrinter.startPrint(false)) {
            try {
                this.m_printerJob.setPrintable((Printable)this.m_viewPrinter, this.m_viewPrinter.getPageFormat());
                this.m_printerJob.print();
            }
            catch (PrinterException pe) {
                this.m_viewPrinter.getDataview().getErrorHandler().log("java.awt.print.PrinterException", this.getClass().getName(), "showPrintDialog(Frame f)");
            }
        }
        this.m_printDialog.setVisible(false);
    }

    @Override
    public void showPageSetupDialog(Frame f) {
        ViewPrinter[] prns = new ViewPrinter[]{this.m_viewPrinter};
        this.m_pageSetup = new PageSetupDialog(f, this.dvStrings.getString("pgsetup"), true, prns, (PreviewDialogProvider)this);
        if (this.m_pageSetup != null) {
            this.m_pageSetup.setHelpProvider(this.getHelpProvider());
        }
        this.m_pageSetup.setVisible(true);
    }

    @Override
    public void showPreviewDialog(Frame f) {
        ViewPrinter[] vp = new ViewPrinter[]{this.m_viewPrinter};
        PreviewDialog dialog = new PreviewDialog(f, this.dvStrings.getString("Print Preview"), vp, (PrintDialogsProvider)this);
        if (dialog != null) {
            dialog.setHelpProvider(this.getHelpProvider());
        }
        dialog.setVisible(true);
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
        this.updateResourceBundle();
    }

    private void updateResourceBundle() {
        try {
            this.dvStrings = this.m_locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", this.m_locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException e) {
            this.dvStrings = null;
        }
    }
}

