/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.ErrorHandler;

public class PageSetupGraphPanel
extends JPanel
implements ActionListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected JPanel m_mainPanel;
    protected JRadioButton m_actualSizeRadioButton;
    protected JRadioButton m_graphFitToRadioButton;
    protected JCheckBox m_pRatioCheckBox;
    protected JCheckBox m_pFontSizeCheckBox;
    protected JLabel m_scaleLabel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected String m_strHelpContextID;
    private ResourceBundle rBundle = null;
    private boolean m_bSuperCalled = true;
    private int m_viewType;

    public PageSetupGraphPanel(ViewPrinter[] viewPrinter) {
        this((UIViewPrinter[])viewPrinter);
    }

    public PageSetupGraphPanel(UIViewPrinter[] viewPrinter) {
        if (viewPrinter == null) {
            return;
        }
        this.m_viewPrinter = viewPrinter;
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_viewType = viewPrinter[0].getViewPrinterType();
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        String translatedText = this.rBundle.getString("Graph Scaling");
        this.m_scaleLabel = new JLabel(translatedText);
        this.m_scaleLabel.setAlignmentX(0.0f);
        this.m_scaleLabel.setMinimumSize(this.m_scaleLabel.getPreferredSize());
        this.m_scaleLabel.setMaximumSize(this.m_scaleLabel.getPreferredSize());
        this.m_mainPanel.add(this.m_scaleLabel);
        translatedText = this.rBundle.getString("Actual size(100%)");
        this.m_actualSizeRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_actualSizeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_actualSizeRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("ActualSizeADA"));
        this.m_actualSizeRadioButton.setAlignmentX(0.0f);
        this.m_mainPanel.add(this.m_actualSizeRadioButton);
        translatedText = this.rBundle.getString("Fit to page");
        this.m_graphFitToRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_graphFitToRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_graphFitToRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("FitToPageADA"));
        this.m_graphFitToRadioButton.setAlignmentX(0.0f);
        this.m_mainPanel.add(this.m_graphFitToRadioButton);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.m_actualSizeRadioButton);
        buttonGroup1.add(this.m_graphFitToRadioButton);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Preserve the ratio of height and width");
        this.m_pRatioCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_pRatioCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_pRatioCheckBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("PreserveTheRatioADA"));
        this.m_pRatioCheckBox.setAlignmentX(0.0f);
        tmpPanel.add(Box.createHorizontalStrut(25));
        tmpPanel.add(this.m_pRatioCheckBox);
        this.m_mainPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Preserve the actual font size");
        this.m_pFontSizeCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_pFontSizeCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_pFontSizeCheckBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("PreserveTheActualADA"));
        this.m_pFontSizeCheckBox.setAlignmentX(0.0f);
        tmpPanel.add(Box.createHorizontalStrut(25));
        tmpPanel.add(this.m_pFontSizeCheckBox);
        this.m_mainPanel.add(tmpPanel);
        this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
        this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
        this.m_graphFitToRadioButton.addActionListener(this);
        this.m_actualSizeRadioButton.addActionListener(this);
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        this._initiate();
    }

    private void _initiate() {
        block0 : switch (this.m_viewPrinter[0].getGraphPrintScaleType()) {
            case 0: {
                this.m_actualSizeRadioButton.setSelected(true);
                this.m_graphFitToRadioButton.setSelected(false);
                this.m_pRatioCheckBox.setEnabled(false);
                this.m_pFontSizeCheckBox.setEnabled(false);
                break;
            }
            case 3: {
                this.m_graphFitToRadioButton.setSelected(true);
                switch (this.m_viewPrinter[0].getScaleFontSize()) {
                    case 0: {
                        this.m_pFontSizeCheckBox.setSelected(true);
                        break;
                    }
                    case -1: {
                        this.m_pFontSizeCheckBox.setSelected(false);
                    }
                }
                break;
            }
            case 4: {
                this.m_graphFitToRadioButton.setSelected(true);
                this.m_pRatioCheckBox.setSelected(true);
                this.m_pRatioCheckBox.setEnabled(true);
                this.m_pFontSizeCheckBox.setEnabled(true);
                switch (this.m_viewPrinter[0].getScaleFontSize()) {
                    case 0: {
                        this.m_pFontSizeCheckBox.setSelected(true);
                        break block0;
                    }
                    case -1: {
                        this.m_pFontSizeCheckBox.setSelected(false);
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_graphFitToRadioButton) {
            this.m_pRatioCheckBox.setEnabled(this.m_graphFitToRadioButton.isSelected());
            this.m_pFontSizeCheckBox.setEnabled(this.m_graphFitToRadioButton.isSelected());
        } else if (e.getSource() == this.m_actualSizeRadioButton) {
            this.m_pRatioCheckBox.setEnabled(!this.m_actualSizeRadioButton.isSelected());
            this.m_pFontSizeCheckBox.setEnabled(!this.m_actualSizeRadioButton.isSelected());
        }
    }

    public void apply() {
        for (int i = 0; i < this.m_viewPrinter.length; ++i) {
            if (this.m_actualSizeRadioButton.isSelected()) {
                this.m_viewPrinter[i].setGraphPrintScaleType(0);
                continue;
            }
            if (!this.m_graphFitToRadioButton.isSelected()) continue;
            if (this.m_pFontSizeCheckBox.isSelected()) {
                this.m_viewPrinter[i].setScaleFontSize(0);
            } else {
                this.m_viewPrinter[i].setScaleFontSize(-1);
            }
            if (this.m_pRatioCheckBox.isSelected()) {
                this.m_viewPrinter[i].setGraphPrintScaleType(4);
                continue;
            }
            this.m_viewPrinter[i].setGraphPrintScaleType(3);
        }
    }

    public void setViewPrinter(ViewPrinter[] viewPrinter) {
        if (viewPrinter != null) {
            this.m_viewPrinter = viewPrinter;
        }
        this._init();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this._init();
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        this.m_viewPrinter = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        this.m_actualSizeRadioButton.removeActionListener(this);
        this.m_actualSizeRadioButton = null;
        this.m_graphFitToRadioButton.removeActionListener(this);
        this.m_graphFitToRadioButton = null;
        this.m_pRatioCheckBox = null;
        this.m_pFontSizeCheckBox = null;
        this.m_scaleLabel = null;
        this.m_eh = null;
        this.m_strHelpContextID = null;
        this.rBundle = null;
        super.removeAll();
        this.removeAll();
    }
}

