/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.JComponent;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.FontUtils;

public class DataviewDialogBarLayout
implements LayoutManager2 {
    private static final int _BUTTON_GAP = 1;
    private static final int _GROUP_GAP = 8;
    private static final int _COMP_INDEX_HELP = 0;
    private static final int _COMP_INDEX_YES = 1;
    private static final int _COMP_INDEX_NO = 2;
    private static final int _COMP_INDEX_CANCEL = 3;
    private static final int _COMP_INDEX_BACK = 4;
    private static final int _COMP_INDEX_NEXT = 5;
    private static final int _COMP_INDEX_FINISH = 6;
    private static final int _COMP_INDEX_APPLY = 7;
    private static final int _COMP_INDEX_NULL = 8;
    private static final int _NUM_COMPS = 9;
    private static final int[] _NORMAL_SPECIAL_START = new int[]{0};
    private static final int[] _NORMAL_SPECIAL_END = new int[]{3, 2, 1, 7, 6, 5, 4};
    private static final int[] _WIZARD_SPECIAL_START = new int[]{3, 0, 7};
    private static final int[] _WIZARD_SPECIAL_END = new int[]{2, 1, 6, 5, 4};
    private Hashtable _compToConstraintMap = new Hashtable(13);
    private Component[] _specialComponents = new Component[9];
    private Container _container;
    private Component prevButton;
    private transient Dimension _cellSize = null;
    private transient Dimension _specialCellSize = null;
    private static final String _RESERVED_WIZARD_BUTTONS = "WizardReservedButtonSpaces";

    public DataviewDialogBarLayout(Container container) {
        this._container = container;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void addLayoutComponent(String constraintName, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        int specialIndex = (Integer)this._compToConstraintMap.remove(comp);
        if (this._specialComponents[specialIndex] == comp) {
            this._specialComponents[specialIndex] = null;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Component oldSpecial;
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (constraints == null) {
            constraints = DialogButtonBar.CONSTRAINT_NULL;
        }
        Integer intConstraint = (Integer)constraints;
        this._compToConstraintMap.put(comp, intConstraint);
        int specialIndex = intConstraint;
        if (specialIndex != 8 && (oldSpecial = this._specialComponents[specialIndex]) != null) {
            this._compToConstraintMap.put(comp, DialogButtonBar.CONSTRAINT_NULL);
        }
        this._specialComponents[specialIndex] = comp;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension innerSize = this._calculateSize(target);
        Insets borderInsets = target.getInsets();
        innerSize.width += borderInsets.left + borderInsets.right;
        innerSize.height += borderInsets.top + borderInsets.bottom;
        return innerSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container target) {
        int availableWidth;
        int shiftStart;
        Dimension availableSize = target.getSize();
        Insets insets = target.getInsets();
        int startX = insets.left;
        int endX = availableSize.width - insets.right;
        int startY = insets.top;
        int availableHeight = availableSize.height - startY - insets.bottom;
        Dimension cellSize = this._getCellSize(target);
        Dimension specialCellSize = this._getSpecialCellSize(target);
        int cellWidth = cellSize.width;
        int cellHeight = cellSize.height;
        int extraHeight = availableHeight - cellHeight;
        if (extraHeight < 0) {
            cellHeight = availableHeight;
            extraHeight = 0;
        }
        startX = this._layoutSpecialComponents(this._getSpecialLeft(), true, startX, endX, startY, extraHeight, cellWidth, cellHeight);
        endX = this._layoutSpecialComponents(this._getSpecialRight(), false, startX, endX, startY, extraHeight, cellWidth, cellHeight);
        cellWidth = specialCellSize.width;
        int numVisibleSpecial = this._getNumVisibleSpecial();
        int numVisibleChildren = this._getNumVisible(target);
        int numVisibleNonSpecial = numVisibleChildren - numVisibleSpecial;
        int nonSpecialSize = numVisibleNonSpecial * cellWidth;
        if (numVisibleNonSpecial > 0) {
            nonSpecialSize += (numVisibleNonSpecial - 1) * 8;
        }
        if ((shiftStart = ((availableWidth = endX - startX) - nonSpecialSize) / 2) > 0) {
            startX += shiftStart;
            availableWidth -= shiftStart;
        }
        int numChildren = target.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            Component currComponent = target.getComponent(i);
            if (!currComponent.isVisible() || this._isSpecial(currComponent)) continue;
            if (cellWidth > availableWidth) {
                cellWidth = availableWidth;
            }
            int currY = 0;
            if (extraHeight > 0) {
                currY = (int)((float)extraHeight * currComponent.getAlignmentY());
            }
            currComponent.setBounds(startX, startY + currY, cellWidth, cellHeight);
            int sizeIncrement = cellWidth + 8;
            startX += sizeIncrement;
            availableWidth -= sizeIncrement;
        }
    }

    private int _layoutSpecialComponents(int[] specialIndices, boolean isStart, int startX, int endX, int startY, int extraHeight, int cellWidth, int cellHeight) {
        for (int i = 0; i < specialIndices.length; ++i) {
            Component nextComponent;
            int nextSpecialIndex;
            int availableWidth = endX - startX;
            int currSpecialIndex = specialIndices[i];
            Component currComponent = this._specialComponents[currSpecialIndex];
            if (currComponent == null || !currComponent.isVisible()) continue;
            if (currSpecialIndex == 6) {
                cellWidth = currComponent.getPreferredSize().width;
            }
            if (cellWidth > availableWidth) {
                cellWidth = availableWidth;
            }
            int currY = 0;
            if (extraHeight > 0) {
                currY = (int)((float)extraHeight * currComponent.getAlignmentY());
            }
            int currX = startX;
            if (!isStart) {
                currX = endX - cellWidth;
            }
            currComponent.setBounds(currX, startY + currY, cellWidth, cellHeight);
            int gapSize = 8;
            if (currSpecialIndex == 5 && i + 1 < specialIndices.length && (nextSpecialIndex = specialIndices[i + 1]) == 4 && (nextComponent = this._specialComponents[nextSpecialIndex]) != null && nextComponent.isVisible()) {
                gapSize = 1;
            }
            int sizeIncrement = cellWidth + gapSize;
            if (isStart) {
                startX += sizeIncrement;
                continue;
            }
            endX -= sizeIncrement;
        }
        if (isStart) {
            return startX;
        }
        return endX;
    }

    @Override
    public void invalidateLayout(Container target) {
        this._cellSize = null;
    }

    private Dimension _getCellSize(Container target) {
        if (this._cellSize == null) {
            this._cellSize = this._calculateCellSize(target);
        }
        return this._cellSize;
    }

    private Dimension _getSpecialCellSize(Container target) {
        if (this._specialCellSize == null) {
            this._specialCellSize = this._calculateSpecialCellSize(target);
        }
        return this._specialCellSize;
    }

    private Dimension _calculateSize(Container target) {
        int numVisibleChildren = this._getNumVisible(target);
        Dimension cellSize = this._getCellSize(target);
        Dimension specialCellSize = this._getSpecialCellSize(target);
        int newWidth = cellSize.width * (numVisibleChildren - 1);
        newWidth += specialCellSize.width;
        if (numVisibleChildren > 0) {
            newWidth += (numVisibleChildren - 1) * 8;
        }
        int newHeight = cellSize.height;
        return new Dimension(newWidth, newHeight);
    }

    private Dimension _calculateSpecialCellSize(Container target) {
        int numChildren = target.getComponentCount();
        int currMaxHeight = 0;
        int currMaxWidth = 0;
        Font font = null;
        for (int i = 0; i < numChildren; ++i) {
            Component currChild;
            if (i == 0 || i > 1 || !(currChild = target.getComponent(i)).isVisible()) continue;
            Dimension currPreferred = currChild.getPreferredSize();
            if (font == null) {
                font = currChild.getFont();
            }
            currMaxWidth = currPreferred.width;
            currMaxHeight = currPreferred.height;
        }
        if (font != null) {
            currMaxWidth += 3 * FontUtils.getAverageWidth(font);
        }
        return new Dimension(currMaxWidth, currMaxHeight);
    }

    private Dimension _calculateCellSize(Container target) {
        int numChildren = target.getComponentCount();
        int currMaxHeight = 0;
        int currMaxWidth = 0;
        Font font = null;
        for (int i = 0; i < numChildren; ++i) {
            Component currChild;
            if (i == 1 || !(currChild = target.getComponent(i)).isVisible()) continue;
            Dimension currPreferred = currChild.getPreferredSize();
            if (font == null) {
                font = currChild.getFont();
            }
            if (currPreferred.width > currMaxWidth) {
                currMaxWidth = currPreferred.width;
            }
            if (currPreferred.height <= currMaxHeight) continue;
            currMaxHeight = currPreferred.height;
        }
        if (font != null) {
            currMaxWidth += 3 * FontUtils.getAverageWidth(font);
        }
        return new Dimension(currMaxWidth, currMaxHeight);
    }

    private int _getNumVisible(Container target) {
        Object o;
        int numVisible = 0;
        int numChildren = target.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            if (!target.getComponent(i).isVisible()) continue;
            ++numVisible;
        }
        if (this._isWizardConfiguration() && target instanceof JComponent && (o = ((JComponent)target).getClientProperty(_RESERVED_WIZARD_BUTTONS)) instanceof Integer) {
            numVisible += ((Integer)o).intValue();
        }
        return numVisible;
    }

    private int _getGroupCount() {
        if (this._containsAnElement(this._getSpecialStart()) && this._containsAnElement(this._getSpecialEnd())) {
            return 2;
        }
        return 1;
    }

    private boolean _containsAnElement(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            if (this._specialComponents[indices[i]] == null) continue;
            return true;
        }
        return false;
    }

    private boolean _isSpecial(Component comp) {
        return (Integer)this._compToConstraintMap.get(comp) != 8;
    }

    private int _getNumVisibleSpecial() {
        int numSpecial = 0;
        for (int i = 0; i < 8; ++i) {
            Component currSpecial = this._specialComponents[i];
            if (currSpecial == null || !currSpecial.isVisible()) continue;
            ++numSpecial;
        }
        return numSpecial;
    }

    private int[] _getSpecialLeft() {
        if (this._isLeftToRight()) {
            return this._getSpecialStart();
        }
        return this._getSpecialEnd();
    }

    private int[] _getSpecialRight() {
        if (this._isLeftToRight()) {
            return this._getSpecialEnd();
        }
        return this._getSpecialStart();
    }

    private int[] _getSpecialStart() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_START;
        }
        return _NORMAL_SPECIAL_START;
    }

    private int[] _getSpecialEnd() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_END;
        }
        return _NORMAL_SPECIAL_END;
    }

    private boolean _isWizardConfiguration() {
        return this._specialComponents[4] != null || this._specialComponents[5] != null || this._specialComponents[7] != null || this._specialComponents[6] != null;
    }

    private boolean _isLeftToRight() {
        return true;
    }
}

