/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.Component;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class BIJOptionPane {
    public static String showInputDialog(Object message) {
        return BIJOptionPane.showInputDialog(null, message);
    }

    public static String showInputDialog(Component parentComponent, Object message) {
        return BIJOptionPane.showInputDialog(parentComponent, message, "Input", 3);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) {
        return (String)BIJOptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.getAccessibleContext().setAccessibleName(message.toString());
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        BIJOptionPane.showMessageDialog(parentComponent, message, "Message", 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        BIJOptionPane.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        BIJOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message) {
        return BIJOptionPane.showConfirmDialog(parentComponent, message, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return BIJOptionPane.showConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return BIJOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        return BIJOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, null);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, Locale locale) {
        return BIJOptionPane.showOptionDialog(parentComponent, message, title, optionType, 3, null, null, null, locale);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, Locale locale) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setLocale(locale != null ? locale : Locale.getDefault());
        pane.setInitialValue(initialValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }
}

