/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.BIException;

public class BIExceptionPanel
extends JPanel
implements ListSelectionListener {
    private Throwable m_exception;
    private String m_message;
    private boolean m_detailVisible;
    private JList m_expList;
    private JTextArea m_stkTxtArea;
    private JPanel m_expStackPanel;
    private JDialog m_dialog;
    private ResourceBundle m_bundle;
    private Dimension m_prevDim;

    public BIExceptionPanel(JDialog dialog, Throwable excep, String msg, ResourceBundle bundle) {
        this.m_dialog = dialog;
        this.m_exception = excep;
        this.m_bundle = bundle;
        this.m_message = msg;
        this.init();
    }

    public void init() {
        this.m_detailVisible = false;
        String showStr = this.m_bundle.getString("Show Details");
        final JButton showHide = new JButton(StringUtils.stripMnemonic((String)showStr));
        showHide.setMnemonic(StringUtils.getMnemonicKeyCode((String)showStr));
        this.m_expList = new JList();
        this.m_stkTxtArea = new JTextArea(10, 20);
        this.m_stkTxtArea.setEditable(false);
        this.setLayout(new BoxLayout(this, 1));
        JButton iconButton = new JButton(new ImageIcon(ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/ewt/olaf/icons/Error.gif")));
        iconButton.setFocusPainted(false);
        iconButton.setHorizontalAlignment(2);
        iconButton.setVerticalAlignment(1);
        iconButton.setBorder(BorderFactory.createEmptyBorder());
        JPanel errPanel = new JPanel(new BorderLayout());
        MultiLineLabel errLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_message);
        errPanel.add((Component)iconButton, "West");
        errPanel.add((Component)errLabel, "Center");
        this.add(errPanel);
        JPanel _showButtonPanel = new JPanel(new FlowLayout(2));
        _showButtonPanel.add(showHide);
        this.add(_showButtonPanel);
        this.m_expStackPanel = new JPanel(new BorderLayout(5, 5));
        this.add(this.m_expStackPanel);
        showHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (BIExceptionPanel.this.m_detailVisible) {
                    showHide.setText(StringUtils.stripMnemonic((String)BIExceptionPanel.this.m_bundle.getString("Show Details")));
                } else {
                    showHide.setText(StringUtils.stripMnemonic((String)BIExceptionPanel.this.m_bundle.getString("Hide Details")));
                }
                BIExceptionPanel.this.showHideDetail();
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Throwable _thr = this.m_exception instanceof BIException ? ((BIException)this.m_exception).elementAt(this.m_expList.getSelectedIndex()) : this.m_exception;
        if (_thr != null) {
            StringWriter _strWrt = new StringWriter();
            PrintWriter _prtWrt = new PrintWriter(_strWrt);
            _thr.printStackTrace(_prtWrt);
            this.m_stkTxtArea.setText(_strWrt.toString());
        }
        this.m_stkTxtArea.setCaretPosition(0);
    }

    public void showHideDetail() {
        if (!this.m_detailVisible) {
            this.m_prevDim = this.m_dialog.getSize();
            if (this.m_exception instanceof BIException) {
                Vector<String> vec = new Vector<String>(((BIException)this.m_exception).size());
                Enumeration e = ((BIException)this.m_exception).elements();
                while (e.hasMoreElements()) {
                    vec.addElement(((Throwable)e.nextElement()).getLocalizedMessage());
                }
                this.m_expList.setListData(vec);
            } else {
                this.m_expList.setListData(new Object[]{this.m_exception.getLocalizedMessage()});
            }
            this.m_expList.setBackground(UIManager.getColor("darkLook"));
            this.m_expList.addListSelectionListener(this);
            String _expStr = this.m_bundle.getString("Exception chain");
            JLabel _expLabel = new JLabel(StringUtils.stripMnemonic((String)_expStr));
            _expLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)_expStr));
            _expLabel.setLabelFor(this.m_expList);
            JScrollPane _expListPane = new JScrollPane(this.m_expList);
            JPanel _expPanel = new JPanel(new BorderLayout());
            _expPanel.add((Component)_expLabel, "North");
            _expPanel.add((Component)_expListPane, "Center");
            _expPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            _expPanel.setPreferredSize(new Dimension(500, 150));
            this.m_expStackPanel.add((Component)_expPanel, "North");
            String _stkStr = this.m_bundle.getString("Stack trace");
            JLabel _stkLabel = new JLabel(StringUtils.stripMnemonic((String)_stkStr));
            _stkLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)_stkStr));
            _stkLabel.setLabelFor(this.m_stkTxtArea);
            JScrollPane m_stackTracePane = new JScrollPane(this.m_stkTxtArea);
            JPanel _stkPanel = new JPanel(new BorderLayout());
            _stkPanel.add((Component)_stkLabel, "North");
            _stkPanel.add((Component)m_stackTracePane, "Center");
            _stkPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.m_expStackPanel.add((Component)_stkPanel, "Center");
            this.m_expList.setSelectedIndex(0);
            this.m_dialog.pack();
            this.m_dialog.show();
            this.m_detailVisible = true;
        } else {
            this.m_expStackPanel.removeAll();
            this.m_dialog.setSize(this.m_prevDim);
            this.m_dialog.show();
            this.m_detailVisible = false;
        }
    }
}

