/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.em_cm.CmAddinArb;
import oracle.dbtools.em_cm.CmController;
import oracle.dbtools.em_cm.CmUtil;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;

class CmTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int ACTION = 0;
    public static final int TYPE = 1;
    public static final int NAME = 2;
    public static final int SCHEMA = 3;
    public static final int CLIENT_SOURCE = 4;
    public static final int EM_SOURCE = 5;
    public static final int GLOBAL_NAME = 6;
    public static final int DESCR = 7;
    protected List<Object> columnNames = new ArrayList<Object>();
    protected List<ChangeItemInfo> dataVector = new ArrayList<ChangeItemInfo>();

    @Override
    public Class<?> getColumnClass(int n) {
        if (this.getValueAt(0, n) == null) {
            return String.class;
        }
        return this.getValueAt(0, n).getClass();
    }

    public void addColumn(Object object) {
        this.columnNames.add(object);
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n).toString();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    public ChangeItemInfo getRow(int n) {
        return this.dataVector.get(n);
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    public void addRow(ChangeItemInfo changeItemInfo) {
        this.dataVector.add(changeItemInfo);
        this.fireTableDataChanged();
    }

    public void addRows(ChangeItemInfo[] changeItemInfoArray) {
        for (ChangeItemInfo changeItemInfo : changeItemInfoArray) {
            this.dataVector.add(changeItemInfo);
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        this.dataVector = new ArrayList<ChangeItemInfo>();
        this.fireTableDataChanged();
    }

    public void updateRow(ChangeItemInfo changeItemInfo, int n) {
        this.dataVector.set(n, changeItemInfo);
        this.fireTableDataChanged();
    }

    public void removeRow(ChangeItemInfo changeItemInfo) {
        if (this.dataVector.contains(changeItemInfo)) {
            this.dataVector.remove(changeItemInfo);
        }
        this.fireTableDataChanged();
    }

    public void removeRows(ChangeItemInfo[] changeItemInfoArray) {
        for (ChangeItemInfo changeItemInfo : changeItemInfoArray) {
            if (!this.dataVector.contains(changeItemInfo)) continue;
            this.dataVector.remove(changeItemInfo);
        }
        this.fireTableDataChanged();
    }

    public int rowExists(String string, String string2, String string3) {
        for (int i = 0; i < this.dataVector.size(); ++i) {
            ChangeItemInfo changeItemInfo = this.dataVector.get(i);
            if (!changeItemInfo.getObjectName().equals(string) || !changeItemInfo.getObjectType().equals(string2) || !changeItemInfo.getObjectSchema().equals(string3)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 7;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            if (n2 == 7) {
                ChangeItemInfo changeItemInfo = CmUtil.getTableModel().getRow(n);
                ChangeItem changeItem = CmUtil.getPlan().getOneChangeItem(changeItemInfo);
                changeItem.setDescription((String)object);
                ChangePlan changePlan = CmUtil.getPlan();
                changePlan.updateChangeItem(changeItem);
                CmController.getInstance().getConnection().commit();
                CmUtil.getTableModel().updateRow((ChangeItemInfo)changeItem, n);
                CmUtil.getTableModel().fireTableDataChanged();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ChangeItemInfo changeItemInfo = this.dataVector.get(n);
        switch (n2) {
            case 0: {
                switch (changeItemInfo.getItemAction()) {
                    case 1: {
                        return CmAddinArb.getString("TABLE_ADD");
                    }
                    case 3: {
                        return CmAddinArb.getString("TABLE_DROP");
                    }
                    case 2: {
                        return CmAddinArb.getString("TABLE_MODIFY");
                    }
                    case 4: {
                        return CmAddinArb.getString("TABLE_MONITOR");
                    }
                    case 0: {
                        return CmAddinArb.getString("TABLE_NO_ACTION");
                    }
                }
                return CmAddinArb.getString("TABLE_UNKNOWN");
            }
            case 1: {
                return changeItemInfo.getObjectType();
            }
            case 2: {
                return changeItemInfo.getObjectName();
            }
            case 3: {
                return changeItemInfo.getObjectSchema();
            }
            case 4: {
                return changeItemInfo.getClientSourceDatabase();
            }
            case 5: {
                return changeItemInfo.getEntMgrSourceDatabase();
            }
            case 6: {
                return changeItemInfo.getGlobalSourceDatabase();
            }
            case 7: {
                return changeItemInfo.getDescription();
            }
        }
        return new Object();
    }
}

