/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.dbtools.em_cm.ChangePlansModel;
import oracle.dbtools.em_cm.CmAddin;
import oracle.dbtools.em_cm.CmAddinArb;
import oracle.dbtools.em_cm.CmController;
import oracle.dbtools.em_cm.CmDropListener;
import oracle.dbtools.em_cm.CmPopupListener;
import oracle.dbtools.em_cm.CmTableModel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.ConnectionException;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;

public class CmPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Toolbar _toolbar;
    private Toolbar _tableTb;
    private CustomTabbedPane _tabs = new CustomTabbedPane(1);
    private boolean _init = false;
    private OracleConnectionComboBox conComboBox = new OracleConnectionComboBox();
    private JComboBox plansComboBox = new JComboBox(new ChangePlansModel());
    private JTable objs = new JTable();
    private TableSorter ts;
    private JScrollPane oScroll = new JScrollPane(this.objs);
    private JPanel panel = new JPanel(new GridBagLayout());

    public CmPanel() {
        super(new GridBagLayout());
        new DropTarget((Component)this._tabs, new CmDropListener());
    }

    public void loadItemTable(ChangePlanInfo changePlanInfo) {
        try {
            ChangePlan changePlan = CmAddin.getCpAccess().getOneChangePlan(changePlanInfo.getPlanName(), changePlanInfo.getPlanOwner());
            ChangeItemInfo[] changeItemInfoArray = changePlan.getChangeItems();
            if (changeItemInfoArray != null && changeItemInfoArray.length > 0) {
                this.getTableModel().clear();
                this.getTableModel().addRows(changeItemInfoArray);
            } else {
                this.getTableModel().clear();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            this._tableTb = new Toolbar();
            this.conComboBox.getJComboBox().setName("conComboBox");
            this.plansComboBox.setName("plansComboBox");
            this.panel.add((Component)this._tableTb, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.oScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            ColumnAutoSizer.autoResizeTable((JTable)this.objs, (String)ColumnAutoSizer.AUTO_FIT_OPTIMUM);
            this.objs.setSelectionMode(0);
            CmTableModel cmTableModel = new CmTableModel();
            cmTableModel.addColumn(CmAddinArb.getString("ACTION"));
            cmTableModel.addColumn(CmAddinArb.getString("TYPE"));
            cmTableModel.addColumn(CmAddinArb.getString("NAME"));
            cmTableModel.addColumn(CmAddinArb.getString("SCHEMA"));
            cmTableModel.addColumn(CmAddinArb.getString("CLIENT_SOURCE"));
            cmTableModel.addColumn(CmAddinArb.getString("EM_SOURCE"));
            cmTableModel.addColumn(CmAddinArb.getString("GLOBAL_NAME"));
            cmTableModel.addColumn(CmAddinArb.getString("DESCRIPTION"));
            this.ts = new TableSorter((TableModel)cmTableModel, this.objs.getTableHeader());
            this.objs.setModel((TableModel)this.ts);
            this.objs.addMouseListener(new CmPopupListener());
            this.conComboBox.getJComboBox().addItemListener(new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        CmController.getInstance().Logout(true);
                    } else if (itemEvent.getStateChange() == 1) {
                        boolean bl = true;
                        try {
                            Connection connection = CmPanel.this.getConnection();
                            if (connection != null) {
                                CmController.getInstance().Login(connection);
                                bl = false;
                            }
                        }
                        catch (Exception exception) {
                            ExceptionHandler.handleException((Throwable)exception);
                        }
                        finally {
                            if (bl) {
                                CmPanel.this.clearConnection();
                            }
                        }
                    }
                }
            });
            this.plansComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ChangePlanInfo changePlanInfo = CmPanel.this.getPlanModel().getSelectedInfo();
                        if (changePlanInfo == null) {
                            CmPanel.this.getTableModel().clear();
                        } else {
                            CmPanel.this.loadItemTable(changePlanInfo);
                        }
                    }
                }
            });
            this._tabs.addTab(null, CmAddinArb.getString("TAB_OBJECTS"), (Component)this.panel);
            this._toolbar = new Toolbar();
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(CmAddinArb.getString("CON_LABEL")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
            this.add((Component)this.conComboBox.getJComboBox(), new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 0, 10), 0, 0));
            this.add((Component)new JLabel(CmAddinArb.getString("PLANS_LABEL")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.plansComboBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
            JButton jButton = new JButton((Action)CmController.getInstance().getPlanAddAction());
            jButton.setName("addPlan");
            jButton.setHideActionText(true);
            jButton.setPreferredSize(new Dimension(20, 20));
            jButton.setMinimumSize(new Dimension(20, 20));
            jButton.setToolTipText((String)CmController.getInstance().getPlanAddAction().getValue("Name"));
            this.add((Component)jButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 1, 0, 0), 0, 0));
            JButton jButton2 = new JButton((Action)CmController.getInstance().getPlanRemAction());
            jButton2.setName("delPlan");
            jButton2.setHideActionText(true);
            jButton2.setPreferredSize(new Dimension(20, 20));
            jButton2.setMinimumSize(new Dimension(20, 20));
            jButton2.setToolTipText((String)CmController.getInstance().getPlanRemAction().getValue("Name"));
            this.add((Component)jButton2, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 1, 0, 0), 0, 0));
            JButton jButton3 = new JButton((Action)CmController.getInstance().getPlanRefAction());
            jButton3.setName("refPlan");
            jButton3.setHideActionText(true);
            jButton3.setPreferredSize(new Dimension(20, 20));
            jButton3.setMinimumSize(new Dimension(20, 20));
            jButton3.setToolTipText((String)CmController.getInstance().getPlanRefAction().getValue("Name"));
            this.add((Component)jButton3, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 1, 0, 10), 0, 0));
            this.add((Component)this._tabs, new GridBagConstraints(0, 5, 5, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_cmpanel_html");
        }
    }

    public ChangePlansModel getPlanModel() {
        return (ChangePlansModel)this.plansComboBox.getModel();
    }

    public JComboBox getConnectionBox() {
        return this.conComboBox.getJComboBox();
    }

    public JComboBox getPlanBox() {
        return this.plansComboBox;
    }

    public CmTableModel getTableModel() {
        return (CmTableModel)this.ts.getTableModel();
    }

    public int getsortRow(int n) {
        return this.ts.modelIndex(n);
    }

    public JTable getTable() {
        return this.objs;
    }

    public Connection getConnection() throws ConnectionException {
        String string = this.conComboBox.getCurrentConnectionName();
        Connection connection = null;
        if (string != null) {
            connection = Connections.getInstance().getUniqueConnection(string);
        }
        return connection;
    }

    public void clearConnection() {
        this.conComboBox.getJComboBox().setSelectedIndex(-1);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public Toolbar getTableToolBar() {
        return this._tableTb;
    }
}

