/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MakeWritableHelper;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.GenericWizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdevimpl.wizard.project.ProjectWizardKeys;
import oracle.jdevimpl.wizard.project.Res;
import oracle.jdevimpl.wizard.project.WizardApplyHandler;

public final class ProjectWizardLauncher
extends GenericWizardLauncher
implements ProjectWizardKeys {
    public static final String HTML_SOURCE_DIR_KEY = "HtmlSourceDir";

    public ProjectWizardLauncher(Context initContext) {
        super(initContext);
    }

    public ProjectWizardLauncher(Context initContext, String wizardTitle) {
        super(initContext, wizardTitle);
    }

    public Project runWizard() {
        Project result = null;
        Namespace ns = this.getNamespace();
        try {
            Context ctx = (Context)ns.get("Context");
            Workspace wksp = ctx.getWorkspace();
            ApplicationContent content = ApplicationContent.getInstance((Workspace)wksp);
            String packagePrefix = content.getAppPackagePrefix();
            if (packagePrefix != null) {
                ns.put("DefaultPackage", (Object)packagePrefix);
            }
            URL projURL = this._getProjectURL(wksp);
            ns.put("ProjectURL", (Object)projURL);
            if (this.runGenericWizard()) {
                if (this.isWritable(wksp)) {
                    projURL = (URL)ns.get("ProjectURL");
                    result = NewEmptyProjectCommand.createProjectInWorkspace(projURL, wksp);
                    if (result != null) {
                        WizardApplyHandler.applyWizardChanges(result, ns, wksp);
                        result.save();
                    }
                } else {
                    String url = URLFileSystem.getPlatformPathName((URL)wksp.getURL());
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Res.format(1, url), (String)Res.getString(0), null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
        }
        return result;
    }

    private boolean isWritable(Workspace workspace) {
        if (workspace != null) {
            URL appURL = workspace.getURL();
            if (URLFileSystem.canWrite((URL)appURL)) {
                return true;
            }
            URL[] urls = new URL[]{appURL};
            if (Ide.getMainWindow() != null && SwingUtilities.isEventDispatchThread() && MakeWritableHelper.makeWritable((URL[])urls)) {
                return true;
            }
        }
        return false;
    }

    private URL _getProjectURL(Workspace wksp) {
        DefaultNameGenerator nameGen = new DefaultNameGenerator(Project.getDefaultName(), null, 1);
        URL wkspURL = wksp.getURL();
        URL dirURL = URLFileSystem.getParent((URL)wkspURL);
        URL projDir = URLFactory.newUniqueURL((URL)dirURL, (NameGenerator)nameGen);
        String fName = URLFileSystem.getFileName((URL)projDir);
        if (!URLFileSystem.isDirectoryPath((URL)projDir)) {
            projDir = URLFactory.newDirURL((URL)dirURL, (String)fName);
        }
        return URLFactory.newURL((URL)projDir, (String)(fName + ".jpr"));
    }
}

