/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.lang.reflect.Modifier;
import javax.swing.Icon;
import oracle.bali.ewt.graphics.JoiningIcon;
import oracle.ide.controls.OverlayIcon;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.ui.EmptyIcon;

public final class JavaIcons
implements JavaConstants {
    private JavaIcons() {
    }

    public static Icon getIcon(JavaElement item) {
        return JavaIcons.getIcon(item, true);
    }

    public static Icon getIcon(JavaElement item, boolean showAccess) {
        return JavaIcons.getIcon(item, showAccess, null);
    }

    public static Icon getIcon(JavaElement item, boolean showAccess, Icon forcedItemIcon) {
        Icon accessIcon;
        Object itemIcon = new EmptyIcon(OracleIcons.getIcon((String)"interface.png"));
        int type = item.getElementKind();
        boolean canBeAbstract = false;
        switch (type) {
            case 3: 
            case 10: {
                JavaType t = (JavaType)item;
                if (t.isInterface()) {
                    itemIcon = OracleIcons.getIcon((String)"interface.png");
                    break;
                }
                itemIcon = OracleIcons.getIcon((String)"class.png");
                canBeAbstract = true;
                break;
            }
            case 4: 
            case 8: {
                if (item instanceof JavaMethod && ((JavaMethod)item).isConstructor()) {
                    itemIcon = OracleIcons.getIcon((String)"constructor.png");
                    break;
                }
                itemIcon = OracleIcons.getIcon((String)"method.png");
                JavaClass owningClass = ((JavaMethod)item).getOwningClass();
                if (owningClass == null) break;
                canBeAbstract = !owningClass.isInterface();
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 23: {
                itemIcon = OracleIcons.getIcon((String)"field.png");
                break;
            }
            case 1: {
                break;
            }
            case 20: {
                itemIcon = OracleIcons.getIcon((String)"import.png");
                break;
            }
            case 9: {
                itemIcon = OracleIcons.getIcon((String)"package.png");
            }
        }
        if (item instanceof SourceError) {
            return OracleIcons.getIcon((String)"error.png");
        }
        if (item instanceof SourceTypeReference) {
            return OracleIcons.getIcon((String)"superclass.png");
        }
        if (item instanceof SourceImport) {
            return OracleIcons.getIcon((String)"import.png");
        }
        if (item instanceof SourcePackage) {
            return OracleIcons.getIcon((String)"package.png");
        }
        if (item instanceof SourceClassInitializer) {
            itemIcon = forcedItemIcon != null ? forcedItemIcon : OracleIcons.getIcon((String)"surround_with.png");
            accessIcon = OracleIcons.getIcon((String)"overlay/package.gif");
            if (item instanceof SourceClassInitializer && ((SourceClassInitializer)item).isStatic()) {
                accessIcon = new OverlayIcon(accessIcon, OracleIcons.getIcon((String)"overlay/static.png"));
            }
            itemIcon = new JoiningIcon((Icon)itemIcon, accessIcon, 1);
        } else if (showAccess) {
            accessIcon = new EmptyIcon(OracleIcons.getIcon((String)"overlay/public.png"));
            if (type == 3 || type == 4 || type == 8 || type == 5) {
                int modifiers = item.getModifiers();
                accessIcon = Modifier.isPublic(modifiers) ? OracleIcons.getIcon((String)"overlay/public.png") : (Modifier.isProtected(modifiers) ? OracleIcons.getIcon((String)"overlay/protected.png") : (Modifier.isPrivate(modifiers) ? OracleIcons.getIcon((String)"overlay/private.png") : OracleIcons.getIcon((String)"overlay/package.gif")));
                if (Modifier.isStatic(modifiers)) {
                    Icon staticIcon = OracleIcons.getIcon((String)"overlay/static.png");
                    accessIcon = new OverlayIcon(accessIcon, staticIcon);
                }
                if (Modifier.isFinal(modifiers)) {
                    Icon finalIcon = OracleIcons.getIcon((String)"overlay/final.png");
                    accessIcon = new OverlayIcon(accessIcon, finalIcon);
                } else if (Modifier.isAbstract(modifiers) && canBeAbstract) {
                    Icon abstractIcon = OracleIcons.getIcon((String)"overlay/abstract.png");
                    accessIcon = new OverlayIcon(accessIcon, abstractIcon);
                }
            }
            if (forcedItemIcon != null) {
                itemIcon = forcedItemIcon;
            }
            itemIcon = new JoiningIcon((Icon)itemIcon, accessIcon, 1);
        }
        return itemIcon;
    }
}

