/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;

public abstract class Context2ParserHelper {
    private TextBuffer textBuffer = null;

    public static Context2ParserHelper createHelper(Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return new HasContextHelper(context);
    }

    public abstract Context getContext();

    protected Context2ParserHelper() {
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    public Project getProject() {
        Project ret = null;
        Context context = this.getContext();
        ret = Context2ParserHelper.getProject(context);
        return ret;
    }

    public static Project getProject(Context context) {
        Project ret = null;
        if (context != null) {
            ret = context.getProject();
        }
        if (ret == null) {
            ret = Ide.getActiveProject();
        }
        if (ret == null) {
            ret = Ide.getDefaultProject();
        }
        return ret;
    }

    public Project getProject2() {
        Project p;
        Context context = this.getContext();
        if (context != null && (p = context.getProject()) != null) {
            return Ide.getActiveProject();
        }
        return Ide.getDefaultProject();
    }

    public URL getURL() {
        Context context = this.getContext();
        if (context != null) {
            return context.getNode().getURL();
        }
        return null;
    }

    public JavaManager getJavaManager() {
        Project p = this.getProject();
        return JavaManager.getAnyJavaManager(p);
    }

    public JavaProvider getJavaProvider() {
        return this.getJavaManager();
    }

    public SourceFile getSourceFile() {
        JavaManager provider = this.getJavaManager();
        URL url = this.getURL();
        if (url != null) {
            return provider.getSourceFile(url);
        }
        return null;
    }

    private TextNode getTextNode() {
        Context context = this.getContext();
        Node node = context.getNode();
        if (node instanceof TextNode) {
            return (TextNode)node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock() {
        Context2ParserHelper context2ParserHelper = this;
        synchronized (context2ParserHelper) {
            if (this.textBuffer != null) {
                return;
            }
            TextNode textNode = this.getTextNode();
            if (textNode != null) {
                this.textBuffer = textNode.acquireTextBuffer();
                if (this.textBuffer != null) {
                    this.textBuffer.readLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Context2ParserHelper context2ParserHelper = this;
        synchronized (context2ParserHelper) {
            if (this.textBuffer != null) {
                this.textBuffer.readUnlock();
                TextNode textNode = this.getTextNode();
                if (textNode != null) {
                    textNode.releaseTextBuffer();
                    this.textBuffer = null;
                }
            }
        }
    }

    private static class HasContextHelper
    extends Context2ParserHelper {
        private final Context context;

        private HasContextHelper(Context context) {
            this.context = context;
        }

        @Override
        public Context getContext() {
            return this.context;
        }
    }
}

