/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtMethodCall;
import oracle.jdeveloper.cmt.CmtMethodSource;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.CmtValue;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdevimpl.cmtimpl.JbComponentManager;
import oracle.jdevimpl.cmtimpl.JbMethod;
import oracle.jdevimpl.cmtimpl.JbValue;

final class JbMethodCall
implements CmtMethodCall {
    private static final Object[] NO_PARAMS = new Object[0];
    private JbMethod method;
    private CmtSubcomponent subcomponent;
    private SourceMethodCallExpression jotMethodCall;
    private CmtComponent outer;
    private Method reflectionMethod;
    private Object[] parameterValues;
    private Class[] parameterTypes;
    private ArrayList arguments;

    @Override
    public CmtMethodSource getParent() {
        return this.method;
    }

    public JbMethodCall(JbMethod method, SourceMethodCallExpression jMethodCall) {
        this(jMethodCall, method.getComponent());
        this.method = method;
    }

    public JbMethodCall(SourceMethodCallExpression jMethodCall, CmtComponent outer) {
        this.jotMethodCall = jMethodCall;
        this.outer = outer;
        SourceExpression jExpr = jMethodCall.getLhsOperand();
        if (jExpr == null) {
            this.subcomponent = outer.getSubcomponent(null);
        } else {
            JbValue value = new JbValue(outer, jExpr);
            this.subcomponent = value.getSubcomponent();
            if (this.subcomponent == null && jExpr.getSymbolKind() == 69) {
                String delegate;
                SourceMethodCallExpression jCall = (SourceMethodCallExpression)jExpr;
                String name = jCall.getName();
                jExpr = jCall.getLhsOperand();
                if (jExpr == null) {
                    this.subcomponent = outer.getSubcomponent(null);
                } else {
                    value = new JbValue(outer, jExpr);
                    this.subcomponent = value.getSubcomponent();
                }
                if (!(this.subcomponent == null || (delegate = this.subcomponent.getComponent().getContainerDelegate()) != null && delegate.equals(name))) {
                    this.subcomponent = null;
                }
            }
        }
    }

    @Override
    public SourceMethodCallExpression getJotMethodCall() {
        return this.jotMethodCall;
    }

    @Override
    public CmtSubcomponent getSubcomponent() {
        return this.subcomponent;
    }

    @Override
    public String getMethodName() {
        return this.getJotMethodCall().getName();
    }

    @Override
    public CmtValue[] getArguments() {
        if (this.arguments == null) {
            this.buildArguments();
        }
        CmtValue[] args = new JbValue[this.arguments.size()];
        this.arguments.toArray(args);
        for (int i = 0; i < args.length; ++i) {
            ((JbValue)args[i]).outer = this.outer;
        }
        return args;
    }

    @Override
    public CmtValue addArgument(CmtValue marker, boolean before, String text) {
        SourceMethodCallExpression jotMethodCall = this.getJotMethodCall();
        if (jotMethodCall != null) {
            if (this.arguments == null) {
                this.buildArguments();
            }
            SourceExpression jArg = Jot2Utils.addArgument(jotMethodCall, marker != null ? marker.getExpression() : null, before, text);
            JbValue cmtArg = new JbValue(this.method.component, jArg);
            int pos = marker != null ? (before ? this.arguments.indexOf(marker) : this.arguments.indexOf(marker) + 1) : (before ? 0 : this.arguments.size());
            this.arguments.add(pos, cmtArg);
            return cmtArg;
        }
        return null;
    }

    @Override
    public CmtValue addArgument(CmtValue marker, boolean before, CmtSubcomponent subcomponent) {
        return this.addArgument(marker, before, subcomponent.getName());
    }

    @Override
    public void removeArgument(CmtValue argument) {
        SourceMethodCallExpression jotMethodCall = this.getJotMethodCall();
        if (jotMethodCall != null && ((JbValue)argument).value != null) {
            if (this.arguments == null) {
                this.buildArguments();
            }
            ((JbValue)argument).value.removeSelf();
            this.arguments.remove(argument);
        }
    }

    public static final JavaType getJotTypeFromClass(CmtComponent cmt, Class c) {
        return cmt.getComponents().getPackages().getClass(JotNames.dotSignatureToType(c.getName()));
    }

    void buildArguments() {
        SourceMethodCallExpression jotMethodCall = this.getJotMethodCall();
        if (jotMethodCall != null) {
            SourceListExpression args = jotMethodCall.getArgumentList();
            List list = args != null ? args.getOperands() : null;
            Iterator lIter = list != null ? list.iterator() : null;
            this.arguments = new ArrayList();
            if (lIter != null) {
                while (lIter.hasNext()) {
                    this.arguments.add(new JbValue(this.outer, (SourceExpression)lIter.next()));
                }
            }
        }
    }

    public String toString1(boolean showName) {
        StringBuffer b = new StringBuffer();
        if (showName) {
            b.append(this.subcomponent != null ? this.subcomponent.getName() : "<this?>");
        }
        b.append("." + this.getJotMethodCall().getName() + "(");
        CmtValue[] args = this.getArguments();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    b.append(",");
                }
                b.append(args[i].getText());
            }
        } else {
            b.append("<null mc args>");
        }
        b.append(")");
        return b.toString();
    }

    public String toString() {
        return this.toString1(true);
    }

    private Method getReflectionMethod(Class objectClass) {
        if (this.reflectionMethod != null) {
            return this.reflectionMethod;
        }
        if (objectClass == null) {
            return null;
        }
        Method candidateMethod = null;
        Class[] candidateTypes = null;
        Object[] candidateValues = null;
        SourceMethodCallExpression jotMethodCall = this.getJotMethodCall();
        String methodName = jotMethodCall.getName();
        try {
            CmtComponents mgr = this.outer != null ? this.outer.getComponents() : null;
            SourceListExpression jotArgs = jotMethodCall.getArgumentList();
            int argCount = jotArgs != null ? jotArgs.getOperandCount() : 0;
            Class[] workingTypes = null;
            Object[] workingValues = argCount > 0 ? new Object[argCount] : NO_PARAMS;
            candidateValues = new Object[argCount];
            Method[] methods = mgr instanceof JbComponentManager ? ((JbComponentManager)mgr).getClassMethods(objectClass) : objectClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName) || (workingTypes = methods[i].getParameterTypes()).length != argCount || !this.evaluateArguments(workingTypes, workingValues)) continue;
                if (candidateMethod != null) {
                    Class<?> methodClass;
                    Class<?> candidateClass = candidateMethod.getDeclaringClass();
                    if (!candidateClass.isAssignableFrom(methodClass = methods[i].getDeclaringClass())) continue;
                    candidateMethod = methods[i];
                    candidateTypes = workingTypes;
                    for (int j = 0; j < candidateValues.length; ++j) {
                        candidateValues[j] = workingValues[j];
                    }
                    continue;
                }
                candidateMethod = methods[i];
                candidateTypes = workingTypes;
                for (int j = 0; j < candidateValues.length; ++j) {
                    candidateValues[j] = workingValues[j];
                }
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            candidateMethod = null;
            candidateTypes = null;
            candidateValues = null;
        }
        this.reflectionMethod = candidateMethod;
        this.parameterTypes = candidateTypes;
        this.parameterValues = candidateValues;
        return this.reflectionMethod;
    }

    private boolean evaluateArguments(Class[] argTypes, Object[] workingValues) {
        block24: {
            try {
                int length;
                if (this.arguments == null) {
                    this.buildArguments();
                }
                int n = length = argTypes != null ? argTypes.length : 0;
                if (length <= 0) break block24;
                for (int i = 0; i < length; ++i) {
                    JbValue jbValue = (JbValue)this.arguments.get(i);
                    JavaType jTargetType = JbMethodCall.getJotTypeFromClass(this.outer, argTypes[i]);
                    try {
                        workingValues[i] = jbValue.getValue(jTargetType);
                    }
                    catch (CmtParseException e) {
                        return false;
                    }
                    if (workingValues[i] != null) {
                        JavaType jSrcType = JbMethodCall.getJotTypeFromClass(this.outer, workingValues[i].getClass());
                        if (jTargetType.isPrimitive()) {
                            Class primitiveCls = JotNames.classForName(jTargetType.getQualifiedName());
                            Class wrapperCls = null;
                            if (primitiveCls == Integer.TYPE) {
                                wrapperCls = Integer.class;
                            } else if (primitiveCls == Boolean.TYPE) {
                                wrapperCls = Boolean.class;
                            } else if (primitiveCls == Character.TYPE) {
                                wrapperCls = Character.class;
                            } else if (primitiveCls == Byte.TYPE) {
                                wrapperCls = Byte.class;
                            } else if (primitiveCls == Double.TYPE) {
                                wrapperCls = Double.class;
                            } else if (primitiveCls == Float.TYPE) {
                                wrapperCls = Float.class;
                            } else if (primitiveCls == Long.TYPE) {
                                wrapperCls = Long.class;
                            } else if (primitiveCls == Short.TYPE) {
                                wrapperCls = Short.class;
                            }
                            if (wrapperCls != null) {
                                jTargetType = JbMethodCall.getJotTypeFromClass(this.outer, wrapperCls);
                            }
                        }
                        if (jTargetType != null && jSrcType != null && jTargetType.isAssignableFrom(jSrcType)) continue;
                        return false;
                    }
                    if (!jTargetType.isPrimitive()) continue;
                    return false;
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object[] getParameterValues() {
        return this.parameterValues;
    }

    public Object invokeStatic(Class c, boolean doInvoke) {
        if (c == null) {
            return null;
        }
        if (this.getReflectionMethod(c) == null || this.parameterValues == null) {
            return null;
        }
        try {
            if (!doInvoke && this.subcomponent != null) {
                return this.reflectionMethod.getReturnType();
            }
            return this.reflectionMethod.invoke(null, this.parameterValues);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    @Override
    public Object invoke() throws Exception {
        return this.invoke(true);
    }

    public Object getReturnType() throws Exception {
        return this.invoke(false);
    }

    private Object invoke(boolean doInvoke) {
        Class<?> cls;
        SourceMethodCallExpression jMethodCall = this.getJotMethodCall();
        SourceExpression jExpr = jMethodCall.getLhsOperand();
        Object instance = null;
        if (jExpr == null) {
            CmtSubcomponent sub = this.outer.getSubcomponent(null);
            instance = sub.getLiveInstance();
        } else {
            JbValue jbValue = new JbValue(this.outer, jExpr);
            CmtPackages jMgr = this.outer.getComponents().getPackages();
            JavaClass jType = jMgr.getClass("java.lang.Object");
            instance = jbValue.getValue((JavaType)jType);
        }
        Class<Object> clazz = instance instanceof Class ? (Class<?>)instance : (cls = instance != null ? instance.getClass() : null);
        if (cls == null || this.getReflectionMethod(cls) == null || this.parameterValues == null) {
            return null;
        }
        try {
            if (!doInvoke) {
                return this.reflectionMethod.getReturnType();
            }
            if (jExpr instanceof SourceUnaryExpression) {
                instance = JbValue.getValue(((SourceUnaryExpression)jExpr).getFirstOperand(), "java.lang.Class", this.outer);
            }
            return this.reflectionMethod.invoke(instance, this.parameterValues);
        }
        catch (Throwable t) {
            Assert.println((String)("** JbMethodCall.invoke(Object, boolean): Failed to invoke \n   " + (this.reflectionMethod != null ? this.reflectionMethod.getName() : "null") + " upon " + (instance != null ? instance.getClass().getName() : "null")));
            return null;
        }
    }

    public boolean isStatic(Class c) {
        this.getReflectionMethod(c);
        boolean result = this.reflectionMethod == null ? false : Modifier.isStatic(this.reflectionMethod.getModifiers());
        return result;
    }
}

