/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.JavaModel;
import oracle.jdeveloper.usage.ClassQueryTaskImpl;
import oracle.jdeveloper.usage.ConstructorQueryTaskImpl;
import oracle.jdeveloper.usage.FieldQueryTaskImpl;
import oracle.jdeveloper.usage.MethodQueryTaskImpl;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdevimpl.java.Bug4598932Fix;

public class UsageManager {
    private Project _project;
    protected ProjectPath _projectPath;
    static AsyncScheduler USAGE_SCHEDULER = new AsyncScheduler("UsageQuery", 30, 2);

    public UsageManager(Project project) {
        this._project = project;
    }

    public UsageManager(ProjectPath projectPath) {
        this._projectPath = projectPath;
    }

    protected JavaFileProvider getJavaProvider() {
        if (this._project != null) {
            return JavaManager.getJavaManager(this._project);
        }
        URLPath clsPath = new URLPath();
        clsPath.add(this._projectPath._classPath);
        clsPath.add(this._projectPath._libPath);
        URLPath srcPath = this._projectPath._sourcePath;
        return JavaModel.getInstance((URLPath)srcPath, (URLPath)clsPath);
    }

    protected Project getProject() {
        return this._project;
    }

    protected ProjectPath getProjectPath() {
        return this._projectPath;
    }

    public UsageQueryTask findClassUsages(String fqClassName, ClassUsageListener listener) {
        return this.findClassUsages(fqClassName, listener, null);
    }

    public UsageQueryTask findClassUsages(String fqClassName, ClassUsageListener listener, URL[] urlsToSearch) {
        ClassQueryTaskImpl queryTask = new ClassQueryTaskImpl(this, fqClassName, listener, urlsToSearch);
        boolean preventDeadlock = Bug4598932Fix.getPreventDeadlock();
        if (preventDeadlock) {
            try {
                queryTask.run();
            }
            catch (Error e) {
                Assert.println((String)"Error occurred during UsageQueryTask");
                Assert.printStackTrace((Throwable)e);
            }
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)queryTask);
        }
        return queryTask;
    }

    private UsageQueryTask findClassUsage(JavaClass javaClass, ClassUsageListener listener) {
        return this.findClassUsage(javaClass, listener, null);
    }

    private UsageQueryTask findClassUsage(JavaClass javaClass, ClassUsageListener listener, URL[] urlsToSearch) {
        ClassQueryTaskImpl queryTask = new ClassQueryTaskImpl(this, javaClass, listener, urlsToSearch);
        boolean preventDeadlock = Bug4598932Fix.getPreventDeadlock();
        if (preventDeadlock) {
            try {
                queryTask.run();
            }
            catch (Error e) {
                Assert.println((String)"Error occurred during UsageQueryTask");
                Assert.printStackTrace((Throwable)e);
            }
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)queryTask);
        }
        return queryTask;
    }

    public UsageQueryTask findFieldUsages(String fqDeclareClassName, String fqFieldTypeName, String fieldName, FieldUsageListener listener) {
        return this.findFieldUsages(fqDeclareClassName, fqFieldTypeName, fieldName, listener, null);
    }

    public UsageQueryTask findFieldUsages(String fqDeclareClassName, String fieldName, FieldUsageListener listener) {
        return this.findFieldUsages(fqDeclareClassName, null, fieldName, listener, null);
    }

    public UsageQueryTask findFieldUsages(String fqDeclareClassName, String fqFieldTypeName, String fieldName, FieldUsageListener listener, URL[] urlsToSearch) {
        FieldQueryTaskImpl queryTask = new FieldQueryTaskImpl(this, fqDeclareClassName, fqFieldTypeName, fieldName, listener, urlsToSearch);
        boolean preventDeadlock = Bug4598932Fix.getPreventDeadlock();
        if (preventDeadlock) {
            try {
                queryTask.run();
            }
            catch (Error e) {
                Assert.println((String)"Error occurred during UsageQueryTask");
                Assert.printStackTrace((Throwable)e);
            }
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)queryTask);
        }
        return queryTask;
    }

    public UsageQueryTask findFieldUsages(String fqDeclareClassName, String fieldName, FieldUsageListener listener, URL[] urlsToSearch) {
        return this.findFieldUsages(fqDeclareClassName, null, fieldName, listener, urlsToSearch);
    }

    public UsageQueryTask findConstructorUsages(String fqDeclareClassName, String[] fqParameterTypeNames, ConstructorUsageListener listener) {
        return this.findConstructorUsages(fqDeclareClassName, fqParameterTypeNames, listener, null);
    }

    public UsageQueryTask findConstructorUsages(String fqDeclareClassName, String[] fqParameterTypeNames, ConstructorUsageListener listener, URL[] urlsToSearch) {
        ConstructorQueryTaskImpl queryTask = new ConstructorQueryTaskImpl(this, fqDeclareClassName, fqParameterTypeNames, listener, urlsToSearch);
        boolean preventDeadlock = Bug4598932Fix.getPreventDeadlock();
        if (preventDeadlock) {
            try {
                queryTask.run();
            }
            catch (Error e) {
                Assert.println((String)"Error occurred during UsageQueryTask");
                Assert.printStackTrace((Throwable)e);
            }
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)queryTask);
        }
        return queryTask;
    }

    public UsageQueryTask findMethodUsages(String fqDeclareClassName, String methodName, String[] fqParameterTypeNames, MethodUsageListener listener) {
        return this.findMethodUsages(fqDeclareClassName, methodName, fqParameterTypeNames, listener, null);
    }

    public UsageQueryTask findMethodUsages(String fqDeclareClassName, String methodName, String[] fqParameterTypeNames, MethodUsageListener listener, URL[] urlsToSearch) {
        MethodQueryTaskImpl queryTask = new MethodQueryTaskImpl(this, fqDeclareClassName, methodName, fqParameterTypeNames, listener, urlsToSearch);
        boolean preventDeadlock = Bug4598932Fix.getPreventDeadlock();
        if (preventDeadlock) {
            try {
                queryTask.run();
            }
            catch (Error e) {
                Assert.println((String)"Error occurred during UsageQueryTask");
                Assert.printStackTrace((Throwable)e);
            }
        } else {
            USAGE_SCHEDULER.scheduleTask((AsyncTask)queryTask);
        }
        return queryTask;
    }

    public JavaClass getClass(String fqClassName) {
        JavaFileProvider provider = this.getJavaProvider();
        JavaClass javaClass = provider.getClass(fqClassName);
        return javaClass;
    }

    static void cancelQuery(AsyncTask task) {
        USAGE_SCHEDULER.cancelTask(task);
    }

    public static class ProjectPath {
        public URLPath _sourcePath;
        public URLPath _libPath;
        public URLPath _classPath;

        public ProjectPath(URLPath sourcePath, URLPath libPath, URLPath classPath) {
            this._sourcePath = sourcePath;
            this._libPath = libPath;
            this._classPath = classPath;
        }

        public ProjectPath(URL sourceURL, URL libURL, URL classURL) {
            this._sourcePath = new URLPath(sourceURL);
            this._libPath = new URLPath(libURL);
            this._classPath = new URLPath(classURL);
        }
    }
}

