/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.DiscoveredDependable;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.BuildOutput;
import oracle.jdeveloper.library.JLibraryDependableRecognizer;
import oracle.jdeveloper.library.ProjectLibrary;

class ProjectLibraryRecognizer
extends DependableRecognizer {
    private static final String PROP_SOURCE_OWNER_URL = "sourceOwnerURL";
    private static final String PROP_SOURCE_URL = "sourceURL";

    private ProjectLibraryRecognizer() {
    }

    public Dependable create(Context context) {
        DependableFactory.Params params = new DependableFactory.Params(context);
        Element source = params.getElement();
        Project project = null;
        Workspace workspace = null;
        if (source instanceof Project && context.getWorkspace() != null) {
            project = (Project)source;
            workspace = context.getWorkspace();
        }
        if (source instanceof BuildOutput) {
            BuildOutput buildOutput = (BuildOutput)source;
            project = buildOutput.getProject();
            workspace = buildOutput.getWorkspace();
        }
        if (project != null && workspace != null) {
            assert (params.getParent() == workspace);
            return JLibraryDependableRecognizer.create((Element)project, (Element)workspace);
        }
        return null;
    }

    public HashStructure toHashStructure(Dependable d, Element source) {
        if (!(d instanceof ProjectLibrary)) {
            return null;
        }
        ProjectLibrary pl = (ProjectLibrary)d;
        HashStructure hash = HashStructure.newInstance();
        hash.putURL(PROP_SOURCE_OWNER_URL, pl.getSourceOwnerURL());
        hash.putURL(PROP_SOURCE_URL, pl.getSourceURL());
        return hash;
    }

    public Dependable toDependable(HashStructure hash, Element source) {
        ProjectLibrary pl = new ProjectLibrary();
        URL sourceOwnerURL = hash.getURL(PROP_SOURCE_OWNER_URL);
        URL sourceURL = hash.getURL(PROP_SOURCE_URL);
        pl.setSourceOwnerURL(sourceOwnerURL);
        pl.setSourceURL(sourceURL);
        return pl;
    }

    public Iterable<DiscoveredDependable> discover(Context context) {
        DependableFactory.Params params = new DependableFactory.Params(context);
        ArrayList<DiscoveredDependable> ddList = new ArrayList<DiscoveredDependable>();
        Element element = params.getElement();
        Element origin = params.getOrigin();
        Element parent = params.getParent();
        if (element instanceof Workspace) {
            Iterator children = element.getChildren();
            while (children.hasNext()) {
                Element ch = (Element)children.next();
                if (!(origin instanceof Project) || origin.equals(ch)) continue;
                ddList.add(DiscoveredDependable.createDefault((Element)ch, null));
            }
        } else if (element instanceof Project && origin instanceof Project && context.getWorkspace() != null) {
            BuildOutput buildOutput = new BuildOutput((Project)element, context.getWorkspace());
            DependableFactory.Params boParams = new DependableFactory.Params(new Context(context));
            boParams.setParent((Element)context.getWorkspace());
            boParams.setElement((Element)buildOutput);
            Dependable dependable = DependableFactory.getInstance().createDependable(boParams.getContext());
            assert (dependable != null);
            ddList.add(DiscoveredDependable.createDefault((Element)buildOutput, (Dependable)dependable));
        }
        return ddList;
    }
}

