/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

final class DuplicateLocator
extends BaseClassLocator {
    private static final Map<DuplicateLocator, WeakReference<DuplicateLocator>> INSTANCES = new WeakHashMap<DuplicateLocator, WeakReference<DuplicateLocator>>();
    private final BaseClassLocator duplicate;
    private final boolean isCycle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DuplicateLocator getInstance(BaseClassLocator duplicate, boolean isCycle) {
        if (duplicate == null) {
            throw new NullArgumentException("null duplicate locator");
        }
        DuplicateLocator locator = new DuplicateLocator(duplicate, isCycle);
        Map<DuplicateLocator, WeakReference<DuplicateLocator>> map = INSTANCES;
        synchronized (map) {
            DuplicateLocator cached;
            WeakReference<DuplicateLocator> ref = INSTANCES.get((Object)locator);
            DuplicateLocator duplicateLocator = cached = ref == null ? null : (DuplicateLocator)((Object)ref.get());
            if (cached == null) {
                cached = locator;
                INSTANCES.put(locator, new WeakReference<DuplicateLocator>(locator));
            }
            return cached;
        }
    }

    private DuplicateLocator(BaseClassLocator duplicate, boolean isCycle) {
        this.duplicate = duplicate;
        this.isCycle = isCycle;
    }

    public boolean isCycle() {
        return this.isCycle;
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
    }

    public void buildIndex() {
    }

    public URL getURL(String fqClassName) {
        return null;
    }

    public URL getSourceURL(String fqClassName) {
        return null;
    }

    public URL getClassURL(String fqClassName) {
        return null;
    }

    public URL getResourceURL(String resourceName) {
        return null;
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        if (!this.isCycle) {
            return Collections.singleton(this.duplicate);
        }
        return Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateLocator)) {
            return false;
        }
        DuplicateLocator other = (DuplicateLocator)((Object)o);
        return this.isCycle == other.isCycle && this.duplicate.equals(other.duplicate);
    }

    public int hashCode() {
        return 31 * this.duplicate.hashCode() + (this.isCycle ? 1 : 0);
    }
}

