/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.JavaModel;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.ProjectFileProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JPaths;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;

public class JavaManager
extends JavaModel {
    protected Project _project;
    private static final TransactionDescriptor NOT_UNDOABLE = new TransactionDescriptor(null, null);
    private static final int TXN_COMMAND_ID;

    public static JavaManager getInstance(Workspace workspace, Project project) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        return new JavaManager(ProjectFileProvider.getInstance(workspace, project));
    }

    public static JavaManager getAnyInstance(Workspace workspace, Project project) {
        if (workspace != null && project != null) {
            return JavaManager.getInstance(workspace, project);
        }
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        Project activeProject = Ide.getActiveProject();
        if (activeWorkspace != null && activeProject != null) {
            return JavaManager.getInstance(activeWorkspace, activeProject);
        }
        Project defaultProject = Ide.getDefaultProject();
        if (defaultProject != null) {
            return JavaManager.getInstanceFromProjectPaths(defaultProject);
        }
        JDK jdk = JLibraryManager.getDefaultJDK();
        if (jdk != null) {
            return JavaManager.getInstance(jdk.getSourcePath() != null ? jdk.getSourcePath() : new URLPath(), jdk.getClassPath() != null ? jdk.getClassPath() : new URLPath());
        }
        return JavaManager.getInstance(new URLPath(), new URLPath());
    }

    public static JavaManager getInstance(Project project) {
        if (project == null) {
            throw new NullArgumentException("non-null project required. Use JavaManager.getAnyInstance(project) for cases where the project might be null and the JavaManager should try and find a valid project");
        }
        ProjectFileProvider provider = ProjectFileProvider.getInstance(project);
        return new JavaManager(provider);
    }

    public static JavaManager getInstance(URLPath sourcePath, URLPath classPath) {
        return JavaManager.getInstance(sourcePath, classPath, null, null);
    }

    public static JavaManager getInstance(URLPath sourcePath, URLPath classPath, URL jrtfsjar, URLPath modulePath) {
        return new JavaManager(JavaModelFactory.getInstance().newFileProvider(sourcePath, classPath, jrtfsjar, modulePath));
    }

    public static JavaManager getInstance(CachedFileProvider fileProvider) {
        return new JavaManager(fileProvider);
    }

    public static JavaManager getAnyInstance(Project project) {
        if (project != null) {
            return JavaManager.getInstance(project);
        }
        Project activeProject = Ide.getActiveProject();
        if (activeProject != null) {
            return JavaManager.getInstance(activeProject);
        }
        Project defaultProject = Ide.getDefaultProject();
        if (defaultProject != null) {
            return JavaManager.getInstanceFromProjectPaths(defaultProject);
        }
        JDK jdk = JLibraryManager.getDefaultJDK();
        if (jdk != null) {
            return JavaManager.getInstance(jdk.getSourcePath() != null ? jdk.getSourcePath() : new URLPath(), jdk.getClassPath() != null ? jdk.getClassPath() : new URLPath());
        }
        return JavaManager.getInstance(new URLPath(), new URLPath());
    }

    private static JavaManager getInstanceFromProjectPaths(Project project) {
        PathsConfiguration pathConfig = PathsConfiguration.getInstance((Project)project);
        return JavaManager.getJavaManager(pathConfig.getSourcePath(), pathConfig.getClassPath());
    }

    public static JavaManager getJavaManager(Project project) {
        return JavaManager.getInstance(project);
    }

    public static JavaManager getJavaManager(URLPath sourcePath, URLPath classPath) {
        return JavaManager.getInstance(sourcePath, classPath);
    }

    public static JavaManager getAnyJavaManager(Project project) {
        return JavaManager.getAnyInstance(project);
    }

    protected JavaManager(CachedFileProvider provider) {
        super(provider);
    }

    public SourceTransaction beginTransaction(SourceFile sourceFile) {
        return sourceFile.beginTransaction();
    }

    public boolean commitTransaction(SourceTransaction openTransaction) {
        return this.commitTransaction(openTransaction, "Code Change");
    }

    public boolean commitTransaction(SourceTransaction openTransaction, String undoText) {
        return this.commitTransaction(openTransaction, new TransactionDescriptor(undoText, null));
    }

    public boolean commitTransactionNoUndo(SourceTransaction openTransaction) {
        return this.commitTransaction(openTransaction, NOT_UNDOABLE);
    }

    public boolean commitTransaction(SourceTransaction openTransaction, TransactionDescriptor txnDescriptor) {
        UndoableEdit edit;
        if (openTransaction == null) {
            throw new NullPointerException("transaction cannot be null");
        }
        if (txnDescriptor == null) {
            throw new NullPointerException("txn descriptor cannot be null");
        }
        URL sourceURL = openTransaction.getOwningSourceFile().getURL();
        Node node = NodeFactory.find((URL)sourceURL);
        Context context = Context.newIdeContext((Node)node);
        if (this._project != null) {
            context.setProject(this._project);
        }
        try {
            edit = openTransaction.commit();
        }
        catch (RuntimeException e) {
            openTransaction.abort();
            return false;
        }
        if (edit == null) {
            return true;
        }
        TransactionCommand command = txnDescriptor == NOT_UNDOABLE ? new TransactionCommand(sourceURL) : new TransactionCommand(edit, sourceURL, txnDescriptor);
        command.setContext(context);
        try {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            return commandProcessor.invoke((Command)command) == 0;
        }
        catch (Exception e) {
            Assert.print((String)"Command processor exception: ");
            Assert.println((String)e.getMessage());
            Assert.printStackTrace((Throwable)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static Project getDefiningProject(Context context, URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Library getDefiningLibrary(Context context, URL url) {
        JLibrary library;
        JDK jdk;
        Project project = context.getProject();
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        HashSet<URL> searchedLibraries = new HashSet<URL>();
        boolean searchSourcePaths = JavaManager.isSourceURL(url);
        boolean searchClassPaths = JavaManager.isClassURL(url);
        if (!searchSourcePaths && !searchClassPaths) {
            searchSourcePaths = true;
            searchClassPaths = true;
        }
        if (JavaManager.isDefinedIn((JPaths)(jdk = projectLibraries.getJDK()), url, searchSourcePaths, searchClassPaths)) {
            return jdk;
        }
        if (!projectLibraries.getOverrideApplicationLibraries() && (library = JavaManager.getDefiningLibrary(project.getWorkspace(), url, searchSourcePaths, searchClassPaths, searchedLibraries)) != null) {
            return library;
        }
        LinkedHashSet<Project> dependencies = new LinkedHashSet<Project>();
        JavaManager.getDependencies(project, dependencies);
        for (Project dependency : dependencies) {
            JLibrary library2 = JavaManager.getDefiningLibrary(dependency, url, true, searchSourcePaths, searchClassPaths, searchedLibraries);
            if (library2 == null) continue;
            return library2;
        }
        JLibrary library3 = JavaManager.getDefiningLibrary(project, url, false, searchSourcePaths, searchClassPaths, searchedLibraries);
        if (library3 != null) {
            return library3;
        }
        if (projectLibraries.getOverrideApplicationLibraries() && (library3 = JavaManager.getDefiningLibrary(project.getWorkspace(), url, searchSourcePaths, searchClassPaths, searchedLibraries)) != null) {
            return library3;
        }
        return null;
    }

    public static List<Project> getDependencies(Project project) {
        ArrayList<Project> dependencies = new ArrayList<Project>();
        DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
        List dependencyList = dc.getDependencyList();
        if (dependencyList != null) {
            for (Object o : dependencyList) {
                Dependable dependable = (Dependable)o;
                if (!(dependable instanceof ProjectLibrary)) continue;
                ProjectLibrary projectLibrary = (ProjectLibrary)dependable;
                dependencies.add(projectLibrary.getProject());
            }
        }
        return dependencies;
    }

    private static void getDependencies(Project project, Set<Project> dependencies) {
        LinkedList<Project> queue = new LinkedList<Project>();
        queue.add(project);
        while (!queue.isEmpty()) {
            Project current = (Project)queue.removeFirst();
            for (Project dependency : JavaManager.getDependencies(current)) {
                if (dependencies.contains(dependency)) continue;
                dependencies.add(dependency);
                queue.add(dependency);
            }
        }
    }

    public static boolean isDefinedIn(Project project, URL url) {
        return PathsConfiguration.getInstance((Project)project).getJavaContentSet().canHaveMember(url);
    }

    private static boolean isSourceURL(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        return ".java".equalsIgnoreCase(suffix) || ".sqlj".equalsIgnoreCase(suffix);
    }

    private static boolean isClassURL(URL url) {
        return ".class".equalsIgnoreCase(URLFileSystem.getSuffix((URL)url));
    }

    private static JLibrary getDefiningLibrary(Project project, URL url, boolean exports, boolean searchSourcePaths, boolean searchClassPaths, Set<URL> alreadySeen) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] libraries = exports ? projectLibraries.getExports() : projectLibraries.getLibraries();
        return JavaManager.getDefiningLibrary(Arrays.asList(libraries), url, searchSourcePaths, searchClassPaths, alreadySeen);
    }

    private static JLibrary getDefiningLibrary(Workspace workspace, URL url, boolean searchSourcePaths, boolean searchClassPaths, Set<URL> alreadySeen) {
        ApplicationLibraries libraries;
        JLibrary library;
        if (workspace != null && (library = JavaManager.getDefiningLibrary((libraries = ApplicationLibraries.getInstance((Workspace)workspace)).getLibraryReferences(), url, searchSourcePaths, searchClassPaths, alreadySeen)) != null) {
            return library;
        }
        return null;
    }

    private static JLibrary getDefiningLibrary(Collection<JLibrary> libraries, URL url, boolean searchSourcePaths, boolean searchClassPaths, Set<URL> alreadySeen) {
        for (JLibrary library : libraries) {
            if (library instanceof Node) {
                URL libraryURL = ((Node)library).getURL();
                if (alreadySeen.contains(libraryURL)) continue;
                alreadySeen.add(libraryURL);
            }
            if (!JavaManager.isDefinedIn((JPaths)library, url, searchSourcePaths, searchClassPaths)) continue;
            return library;
        }
        return null;
    }

    private static boolean isDefinedIn(JPaths paths, URL url, boolean searchSourcePaths, boolean searchClassPaths) {
        URLPath classPaths;
        URLPath sourcePaths;
        if (searchSourcePaths && (sourcePaths = paths.getSourcePath()) != null) {
            for (URL sourcePath : sourcePaths) {
                if (!URLFileSystem.isBaseURLFor((URL)sourcePath, (URL)url)) continue;
                return true;
            }
        }
        if (searchClassPaths && (classPaths = paths.getClassPath()) != null) {
            for (URL classPath : classPaths) {
                if (!URLFileSystem.isBaseURLFor((URL)classPath, (URL)url)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        int id = -1;
        try {
            id = Ide.findOrCreateCmdID((String)TransactionCommand.class.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TXN_COMMAND_ID = id;
    }

    protected class TransactionCommand
    extends Command {
        private TransactionDescriptor _descriptor;
        private UndoableEdit _undoableEdit;
        private URL _url;
        private boolean _first;

        protected TransactionCommand(URL url) {
            super(TXN_COMMAND_ID, 2);
            if (TXN_COMMAND_ID < 0) {
                throw new RuntimeException("Requires an owning Ide instance");
            }
            this._first = true;
            this._url = url;
        }

        protected TransactionCommand(UndoableEdit undoableEdit, URL url, TransactionDescriptor descriptor) {
            super(TXN_COMMAND_ID, 0, descriptor.getEditName());
            if (TXN_COMMAND_ID < 0) {
                throw new RuntimeException("Requires an owning Ide instance");
            }
            this._first = true;
            this._undoableEdit = undoableEdit;
            this._url = url;
            this._descriptor = descriptor;
        }

        private boolean isReadOnly() {
            try {
                Node node = NodeFactory.findOrCreate((URL)this._url);
                return node.isReadOnly();
            }
            catch (Exception e) {
                return true;
            }
        }

        public final int doit() throws Exception {
            Object origin;
            if (this.isReadOnly()) {
                return 1;
            }
            Object object = origin = this._descriptor != null ? this._descriptor.getClientObject() : null;
            if (this._first) {
                this._first = false;
                this._descriptor = null;
            } else if (this._undoableEdit != null) {
                this._undoableEdit.redo();
            }
            final Node node = NodeFactory.findOrCreate((URL)this._url);
            Runnable invoker = new Runnable(){

                @Override
                public void run() {
                    UpdateMessage msg = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, origin);
                    node.notifyObservers((Object)node, msg);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                invoker.run();
            } else {
                SwingUtilities.invokeLater(invoker);
            }
            return 0;
        }

        public final int undo() throws Exception {
            if (this.isReadOnly()) {
                return 1;
            }
            this._undoableEdit.undo();
            final Node node = NodeFactory.findOrCreate((URL)this._url);
            Runnable invoker = new Runnable(){

                @Override
                public void run() {
                    UpdateMessage msg = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, null);
                    node.notifyObservers((Object)node, msg);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                invoker.run();
            } else {
                SwingUtilities.invokeLater(invoker);
            }
            return 0;
        }
    }
}

