/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.util.MetaClass;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.BuilderComboBoxModel;
import oracle.jdeveloper.builder.DataList;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.cls.ClassSourceModel;
import oracle.jdeveloper.builder.cls.Generator;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.util.Helpers;
import oracle.jdevimpl.uieditor.JdevUiEditorUtils;

public class ClassBuilderModel
extends AbstractBuilderModel
implements AbstractPicker.PickerValueEncoder {
    public static final String MODEL = ClassBuilderModel.class.getName();
    public static final String JAVA_EXTENSION_ID = "oracle.jdeveloper.java.core";
    private HashMap clsHash = new HashMap();
    private Generator defaultGenerator;
    private MutableComboBoxModel model;
    private boolean keepDefaultPackage;
    private boolean _openInEditor = true;
    private boolean _confirmOverwrite = true;
    private String propertiesKey;
    private static final String propKeyItem = "-item";
    private static final String propKeyList = "-list";
    private DataList _history;
    private ArrayList _classList;
    private transient Component _panel;
    private transient JEWTDialog _dlg;
    private Context _ctx;
    private static final String PROP_START = "jdeveloper.{0}.generator.";
    public static final String DEFAULT_BASE_CLASS = "java.lang.Object";
    private static final int MAX_LENGTH = 10;

    public ClassBuilderModel(Context ctx) {
        this._ctx = ctx;
        this._ctx.setProperty(MODEL, (Object)this);
        this.initializeFromContext(ctx);
        this.loadGenerators();
    }

    @Override
    protected String getBaseName() {
        return BuilderArb.getString(47);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean buildFile(Node node) {
        super.buildFile(node);
        Assert.precondition((boolean)(node instanceof JavaSourceNode));
        boolean result = false;
        Object baseClass = null;
        if (node instanceof JavaSourceNode) {
            SourceFile srcFile;
            JavaSourceNode srcNode = (JavaSourceNode)node;
            JavaManager mgr = this.getJavaManager();
            URL srcURL = srcNode.getURL();
            if (srcNode.isNew()) {
                try {
                    srcFile = mgr.createSourceFile(srcURL);
                }
                catch (IOException e) {
                    srcFile = null;
                }
            } else {
                srcFile = mgr.getSourceFile(srcURL);
            }
            if (srcFile != null) {
                SourceTransaction txn = mgr.beginTransaction(srcFile);
                try {
                    Generator gen;
                    GeneratorElement base;
                    String pkg = this.getPackage();
                    if (pkg != null && pkg.length() > 0) {
                        srcFile.setPackageName(pkg);
                    }
                    if (!this.keepDefaultPackage) {
                        Project proj = this.getProject();
                        JavaProject.getInstance(proj).setMostRecentPackage(pkg);
                    }
                    if ((baseClass = this.model.getSelectedItem()) == null || baseClass.toString().length() == 0) {
                        baseClass = this.encodeValue(this.getDefaultBaseClass());
                    }
                    String superName = (base = (GeneratorElement)baseClass) == null ? null : base.getClassName();
                    String[] imps = this.getOtherImports();
                    if (imps != null) {
                        for (int i = 0; i < imps.length; ++i) {
                            SourceUtils.addImport((SourceFile)srcFile, (String)imps[i]);
                        }
                    }
                    String clsName = this.getClassName();
                    SourceClass cls = SourceUtils.addClass((SourceFile)srcFile, (String)clsName, (int)1);
                    if (superName != null && !superName.equals(DEFAULT_BASE_CLASS)) {
                        SourceUtils.setSuperclass((SourceClass)cls, (String)superName);
                    }
                    if (this.hasDefaultConstructor()) {
                        SourceUtils.addConstructor((SourceClass)cls, (int)1);
                    }
                    this.generate(srcFile, cls);
                    if (base != null && (gen = base.getGenerator()) != null) {
                        gen.generate(mgr, srcFile);
                    }
                    mgr.commitTransaction(txn, new TransactionDescriptor("Class Generation"));
                    txn = null;
                }
                catch (RuntimeException e) {
                    Assert.println((String)("Exception occurred in generation: " + e.toString()));
                    Assert.printStackTrace((Throwable)e);
                }
                finally {
                    if (txn != null) {
                        txn.abort();
                    }
                }
                this._panel = null;
                result = true;
            }
        }
        if (result && baseClass != null) {
            this.storeSettings(baseClass.toString());
        }
        return result;
    }

    @Override
    protected SourceModel createSourceModel() {
        return new ClassSourceModel();
    }

    @Override
    protected String getDefaultRelativeDirectory(Project project) {
        String pkg = JavaProject.getInstance(project).getMostRecentPackage();
        if (pkg != null) {
            pkg = pkg.replace('.', '/');
        }
        return pkg;
    }

    protected void validateClassNameIsUnique() {
    }

    public final void setClassName(String newClassName) throws IllegalArgumentException {
        if (newClassName == null || !JotNames.isValidIdentifier(newClassName)) {
            throw new IllegalClassNameException();
        }
        this.setFileName(newClassName);
        URL url = this.getSourceModel().getURL();
        if (url == null) {
            throw new UserCancelledFileException();
        }
        if (!URLFileSystem.isValid((URL)url)) {
            throw new InvalidFileException(URLFileSystem.getPlatformPathName((URL)url));
        }
        this.validateClassNameIsUnique();
        if (this.getConfirmOverwrite() && this.getSourceModel().checkForExistingFile()) {
            String msg = BuilderArb.format(36, BuilderArb.getString(20), URLFileSystem.getPlatformPathName((URL)this.getURL()));
            if (!MessageDialog.confirm((Component)this._getDialogOwner(), (Object)msg, (String)BuilderArb.getString(35), null, (boolean)true)) {
                throw new DuplicateClassException();
            }
        }
    }

    public final String getClassName() {
        return this.getFileName();
    }

    public final String getQualifiedClassName() {
        String pkg = this.getPackage();
        String clsName = this.getClassName();
        return pkg.length() > 0 ? pkg + "." + clsName : clsName;
    }

    public final void setPackage(String newPackage) throws IllegalArgumentException {
        if (!ClassBuilderModel.isPackageNameValid(newPackage)) {
            throw new IllegalPackageNameException();
        }
        String dir = newPackage != null ? newPackage.replace('.', '/') : "";
        this.setRelativeDirectory(dir);
    }

    public static final boolean isPackageNameValid(String newPackage) {
        return newPackage == null || newPackage.length() <= 0 || JotNames.isValidClassName(newPackage);
    }

    public final String getPackage() {
        String dir = this.getRelativeDirectory();
        return dir != null ? dir.replace('/', '.') : "";
    }

    public final void setKeepDefaultPackage(boolean keep) {
        this.keepDefaultPackage = keep;
    }

    public final boolean getKeepDefaultPackage() {
        return this.keepDefaultPackage;
    }

    public final void setOpenInEditor(boolean openInEditor) {
        this._openInEditor = openInEditor;
    }

    public final boolean getOpenInEditor() {
        return this._openInEditor;
    }

    public final void setConfirmOverwrite(boolean confirmOverwrite) {
        this._confirmOverwrite = confirmOverwrite;
    }

    public final boolean getConfirmOverwrite() {
        return this._confirmOverwrite;
    }

    public final void generateDefaultFileName() {
        SourceModel src = this.getSourceModel();
        src.generateDefaultFileName(this.getBaseName());
    }

    public final MutableComboBoxModel getModel() {
        return this.model;
    }

    public final Object getDefaultType() {
        String defType = this.getDefaultBaseClass();
        return defType != null ? this.clsHash.get(defType) : null;
    }

    public final void setActivePanel(Component panel) {
        this._panel = panel;
    }

    public Component getPanel() {
        return this._panel;
    }

    public void setBuilderDialog(JEWTDialog dlg) {
        this._dlg = dlg;
    }

    public JEWTDialog getBuilderDialog() {
        return this._dlg;
    }

    public final boolean hasAttributes() {
        for (int i = 0; i < this.model.getSize(); ++i) {
            GeneratorElement gen = (GeneratorElement)this.model.getElementAt(i);
            if (gen.getAttributes() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getBuilderType() {
        return "Class";
    }

    protected String[] getDefaultBaseClasses() {
        return new String[]{DEFAULT_BASE_CLASS};
    }

    protected String getDefaultBaseClass() {
        return DEFAULT_BASE_CLASS;
    }

    protected String[] getOtherImports() {
        return new String[0];
    }

    @Deprecated
    protected String[] getLibraries() {
        return new String[0];
    }

    private void initializeDataList() {
        String string = this.propertiesKey = this._dlg == null ? null : this._dlg.getTitle();
        if (this.propertiesKey == null || this.propertiesKey.length() == 0) {
            this._history = new DataList();
            return;
        }
        this.formatPropertyString(this.propertiesKey);
        if (this._history == null) {
            String selItem = Ide.getDTCache().getString(this.propertiesKey + propKeyItem);
            List extList = (List)Ide.getDTCache().getData(this.propertiesKey + propKeyList);
            this._history = new DataList(selItem, extList);
        }
    }

    protected void updateStoredBaseClasses() {
        this.initializeDataList();
        Iterator<String> iter = this._history.getList().iterator();
        this._classList = new ArrayList();
        while (iter.hasNext()) {
            String o = iter.next();
            if (!this.validateClassType(o, this.getPackage())) continue;
            this._classList.add(o);
        }
        if (this._classList.isEmpty()) {
            return;
        }
        String[] baseClasses = this._classList.toArray(new String[0]);
        this.updateModel(baseClasses);
        this.updateGenerators();
        Object base = this.getDefaultType();
        if (base != null && this.model != null) {
            this.model.setSelectedItem(base);
        }
    }

    private void storeSettings(String item) {
        if (this.propertiesKey == null) {
            return;
        }
        this.initializeDataList();
        List<String> classes = this._history.getList();
        if (classes.contains(item)) {
            classes.remove(item);
        }
        classes.add(0, item);
        for (int i = classes.size() - 1; i >= 10; --i) {
            classes.remove(i);
        }
        Ide.getDTCache().putData(this.propertiesKey + propKeyList, classes);
        Ide.getDTCache().putString(this.propertiesKey + propKeyItem, item);
    }

    protected boolean validateClass(JavaClass cls, String pkg) {
        boolean result = false;
        if (!(cls == null || cls.isArray() || cls.isInterface() || cls.isPrimitive() || Modifier.isFinal(cls.getModifiers()) || !this._isClassAccessible(cls, pkg))) {
            String[] baseClasses = this.getDefaultBaseClasses();
            for (int i = 0; i < baseClasses.length; ++i) {
                JavaClass baseClass = this.getJavaManager().getClass(baseClasses[i]);
                if (!baseClass.isAssignableFrom((JavaType)cls)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected final boolean _isClassAccessible(JavaClass cls, String pkg) {
        return Helpers.isClassAccessible(cls, pkg);
    }

    protected boolean validateClassType(String fqName, String pkgName) {
        boolean result = false;
        try {
            JavaManager mgr = this.getJavaManager();
            JavaClass cls = mgr.getClass(fqName);
            result = this.validateClass(cls, pkgName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected boolean hasDefaultConstructor() {
        return false;
    }

    protected boolean isObjectBaseClass() {
        return DEFAULT_BASE_CLASS.equals(this.getDefaultBaseClass());
    }

    protected boolean isSuperclassEditable() {
        return this.isObjectBaseClass();
    }

    protected void generate(SourceFile file, SourceClass cls) {
    }

    protected final JavaManager getJavaManager() {
        return JavaManager.getJavaManager(this.getProject());
    }

    public final Context getContext() {
        return this._ctx;
    }

    @Override
    public final void reportError(String title, String msg, String helpID) {
        MessageDialog.error((Component)this._getDialogOwner(), (Object)msg, (String)title, (String)helpID);
    }

    private Component _getDialogOwner() {
        return this._panel != null ? this._panel : Ide.getMainWindow();
    }

    private void formatPropertyString(String prop) {
        String newProp = prop.toLowerCase() + BuilderArb.getString(19);
        if (newProp.indexOf(" ") > 0) {
            newProp = newProp.replaceAll(" ", "-");
        }
        this.propertiesKey = newProp;
    }

    private void updateModel(String[] items) {
        for (int i = 0; i < items.length; ++i) {
            String cName = items[i];
            if (this.clsHash.containsKey(cName)) continue;
            GeneratorElement elem = new GeneratorElement(cName, null);
            this.clsHash.put(cName, elem);
            this.model.addElement(elem);
        }
    }

    private void loadGenerators() {
        this.model = new BuilderComboBoxModel();
        String[] cNames = this.getDefaultBaseClasses();
        if (cNames != null) {
            this.updateModel(cNames);
        }
        Map builderData = GalleryManager.getGalleryManager().getBuilderMap();
        Object[] args = new Object[]{this.getBuilderType().toLowerCase()};
        String type = MessageFormat.format(PROP_START, args);
        Set keys = builderData.keySet();
        for (String key : keys) {
            if (!key.startsWith(type)) continue;
            String cName = key.substring(type.length());
            MetaClass genClass = (MetaClass)builderData.get(key);
            Generator gen = null;
            try {
                Generator cls = (Generator)genClass.newInstance();
                if (cls != null) {
                    gen = cls;
                    gen.setContext(this.getContext());
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            if (cName.equals("*")) {
                this.defaultGenerator = gen;
                continue;
            }
            GeneratorElement element = (GeneratorElement)this.clsHash.get(cName);
            if (element != null) {
                element.setGenerator(gen);
                continue;
            }
            element = new GeneratorElement(cName, gen);
            this.clsHash.put(cName, element);
            this.model.addElement(element);
        }
        this.updateGenerators();
        Object base = this.getDefaultType();
        if (base != null) {
            this.model.setSelectedItem(base);
        }
    }

    public void updateGenerators() {
        if (this.defaultGenerator != null) {
            for (Object key : this.clsHash.keySet()) {
                GeneratorElement element = (GeneratorElement)this.clsHash.get(key);
                if (element == null || element.getGenerator() != null) continue;
                element.setGenerator(this.defaultGenerator);
            }
        }
    }

    public Object encodeValue(Object value) {
        String clsName = value.toString();
        GeneratorElement elem = (GeneratorElement)this.clsHash.get(clsName);
        if (elem == null) {
            elem = new GeneratorElement(clsName, this.defaultGenerator);
            this.clsHash.put(clsName, elem);
        }
        return elem;
    }

    @Override
    protected void postProcess(final Node node) {
        if (node != null) {
            CommandProcessor.getInstance().flush(node);
            try {
                node.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String name = URLFileSystem.getFileName((URL)node.getURL());
                    if (name != null) {
                        JavaClass compCls;
                        SourceClass cls;
                        int start = name.lastIndexOf(File.separatorChar);
                        int end = name.lastIndexOf(".");
                        end = end < 0 ? name.length() : end;
                        name = name.substring(start + 1, end).replace('/', '.');
                        JavaManager mgr = JavaManager.getJavaManager(ClassBuilderModel.this.getProject());
                        SourceFile file = mgr != null ? mgr.getSourceFile(node.getURL()) : null;
                        SourceClass sourceClass = cls = file != null ? file.getSourceClass(name) : null;
                        if (cls != null && (compCls = mgr.getClass("java.awt.Component")) != null && compCls.isAssignableFrom((JavaType)cls) && !cls.getDeclaredMethods("jbInit").isEmpty()) {
                            Context ctx = ClassBuilderModel.this.getContext() != null ? new Context(ClassBuilderModel.this.getContext()) : Context.newIdeContext();
                            ctx.setNode(node);
                            ctx.setSelection(new Element[]{node});
                            if (JdevUiEditorUtils.getInstance().openUIEditorImpl(ctx)) {
                                return;
                            }
                        }
                    }
                    if (ClassBuilderModel.this._openInEditor) {
                        Context context = Context.newIdeContext((Node)node);
                        EditorManager editorManager = EditorManager.getEditorManager();
                        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                        if (!ClassBuilderModel.this.isRaiseEditor()) {
                            openEditorOptions.setFlags(2);
                        }
                        openEditorOptions.setFlags(8, true);
                        editorManager.openEditor(openEditorOptions);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static class InvalidFileException
    extends IllegalArgumentException {
        String _path;

        public InvalidFileException(String path) {
            this._path = path;
        }

        public String getPath() {
            return this._path;
        }
    }

    public static class UserCancelledFileException
    extends IllegalArgumentException {
    }

    public static class DuplicateClassException
    extends IllegalArgumentException {
    }

    public static class IllegalBaseClassException
    extends IllegalArgumentException {
    }

    public static class IllegalPackageNameException
    extends IllegalArgumentException {
    }

    public static class IllegalClassNameException
    extends IllegalArgumentException {
    }
}

