/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.browse;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.browse.JavaBrowseContext;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;

public class JavaBrowseContextImpl
extends Context2ParserHelper
implements JavaBrowseContext {
    private final Context _context;
    private int startOffset;
    private int endOffset;
    private SourceFile _sourceFile;
    private JavaBraceProvider _braceProvider;

    public static JavaBrowseContextImpl createContext(Context context, int offset) {
        Node node = context.getNode();
        if (!(node instanceof TextNode)) {
            return null;
        }
        return new JavaBrowseContextImpl(context, offset);
    }

    protected JavaBrowseContextImpl(Context context, int offset) {
        this._context = context;
        this.startOffset = offset;
        this.endOffset = offset;
    }

    @Override
    public int getSelectionStart() {
        return this.startOffset;
    }

    @Override
    public int getSelectionEnd() {
        return this.endOffset;
    }

    @Override
    public void setSelection(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    protected void finalize() {
        this.release();
    }

    @Override
    public void acquire() {
        this.acquireLock();
    }

    @Override
    public void release() {
        this.releaseLock();
    }

    protected JavaBraceProvider getBraceProviderImpl() {
        BasicEditorPane editor;
        View view = this.getContext().getView();
        BasicEditorPane basicEditorPane = editor = view instanceof CodeEditor ? ((CodeEditor)view).getFocusedEditorPane() : null;
        if (editor != null) {
            BasicDocument basicDocument = (BasicDocument)editor.getDocument();
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            return (JavaBraceProvider)languageSupport.getBraceProvider();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        return new JavaBraceProvider(textBuffer);
    }

    @Override
    public final JavaBraceProvider getBraceProvider() {
        if (this._braceProvider == null) {
            this._braceProvider = this.getBraceProviderImpl();
        }
        return this._braceProvider;
    }

    protected SourceFile getSourceFileImpl() {
        SourceFile file = super.getSourceFile();
        if (file != null) {
            return file;
        }
        TextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        JavaManager javaManager = this.getJavaManager();
        return javaManager.getSourceFile(textBuffer);
    }

    @Override
    public final SourceFile getSourceFile() {
        if (this._sourceFile == null) {
            this._sourceFile = this.getSourceFileImpl();
        }
        return this._sourceFile;
    }
}

