/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.navigator.SshFolderElement;
import oracle.dbtools.raptor.ssh.navigator.SshHostElement;

public final class Hosts
extends SshFolderElement<SshHostElement> {
    static final Hosts INSTANCE = new Hosts();

    private Hosts() {
    }

    public String getShortLabel() {
        return SshSupportResources.getString("NAVIGATOR_ROOT");
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    protected Icon loadIcon() {
        return RaptorImagesArb.getIcon((String)"SERVERS");
    }

    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    protected List<SshHostElement> loadChildren() {
        ArrayList<SshHostElement> arrayList = new ArrayList<SshHostElement>();
        Store store = Client.getInstance().getStore();
        for (String string : store.listHosts()) {
            HostDescriptor hostDescriptor = store.getHostDescriptor(string);
            SshHostElement sshHostElement = SshHostElement.createHostElement(hostDescriptor);
            arrayList.add(sshHostElement);
        }
        return arrayList;
    }

    @Override
    protected void handleHostAdded(StoreEvent storeEvent) {
        HostDescriptor hostDescriptor = storeEvent.getHostDescriptor();
        SshHostElement sshHostElement = SshHostElement.createHostElement(hostDescriptor);
        this.addChild(sshHostElement);
    }

    @Override
    protected void handleHostRemoved(StoreEvent storeEvent) {
        HostDescriptor hostDescriptor = storeEvent.getHostDescriptor();
        final String string = hostDescriptor.getName();
        SshHostElement sshHostElement = this.findChild(new SshFolderElement.Matcher<SshHostElement>(){

            @Override
            public boolean matches(SshHostElement sshHostElement) {
                HostDescriptor hostDescriptor = sshHostElement.getHost();
                return ModelUtil.areEqual((Object)string, (Object)hostDescriptor.getName());
            }
        });
        if (sshHostElement != null) {
            this.removeChild(sshHostElement);
        }
    }

    static {
        INSTANCE.initListeners();
    }
}

