/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.config;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.dbtools.raptor.ssh.core.SshConfigParameter;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class SshConfiguration
extends RaptorHashStructureAdapter {
    private static final String DATA_KEY = "SQLDeveloper.SSHConfiguration";
    private static final String ROOT_KEY = "SshRoot";
    public static final String KNOWN_HOSTS_KEY = "KnownHosts";
    public static final String CONFIG_FILE_KEY = "ConfigFile";
    public static final String IDENTITIES_KEY = "Identities";
    public static final String CONFIG_OVERRIDES_KEY = "ConfigOverrides";
    public static final String CONFIG_PARAMS_KEY = "ConfigParameters";

    public static SshConfiguration getInstance(PropertyStorage propertyStorage) {
        return new SshConfiguration(SshConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public static SshConfiguration createSettings(TraversableContext traversableContext) {
        return SshConfiguration.getInstance(traversableContext.getPropertyStorage());
    }

    public static SshConfiguration getInstance() {
        return SshConfiguration.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private SshConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    protected String getRootKey() {
        return ROOT_KEY;
    }

    public URL getKnownHostsFile() {
        HashStructure hashStructure = this.getRootHash();
        return hashStructure.getURL(KNOWN_HOSTS_KEY);
    }

    public void setKnownHostsFile(URL uRL) {
        HashStructure hashStructure = this.getRootHash();
        hashStructure.putURL(KNOWN_HOSTS_KEY, uRL, true);
    }

    public URL getConfigFile() {
        HashStructure hashStructure = this.getRootHash();
        return hashStructure.getURL(CONFIG_FILE_KEY);
    }

    public void setConfigFile(URL uRL) {
        HashStructure hashStructure = this.getRootHash();
        hashStructure.putURL(CONFIG_FILE_KEY, uRL, true);
    }

    public URL[] getIdentityFiles() {
        URL[] uRLArray = new URL[]{};
        HashStructure hashStructure = this.getRootHash();
        ListStructure listStructure = hashStructure.getListStructure(IDENTITIES_KEY);
        if (listStructure != null) {
            int n = listStructure.size();
            uRLArray = new URL[n];
            for (int i = 0; i < n; ++i) {
                uRLArray[i] = (URL)listStructure.get(i);
            }
        }
        return uRLArray;
    }

    public void setIdentityFiles(URL[] uRLArray) {
        HashStructure hashStructure = this.getRootHash();
        if (uRLArray == null || uRLArray.length == 0) {
            hashStructure.remove(IDENTITIES_KEY);
        } else {
            ListStructure listStructure = ListStructure.newInstance();
            listStructure.addAll(Arrays.asList(uRLArray));
            hashStructure.putListStructure(IDENTITIES_KEY, listStructure);
        }
    }

    public boolean isParameterOverridden(SshConfigParameter sshConfigParameter) {
        HashStructure hashStructure = this.getRootHash();
        HashStructure hashStructure2 = hashStructure.getHashStructure(CONFIG_OVERRIDES_KEY);
        return hashStructure2 != null && hashStructure2.getBoolean(sshConfigParameter.name());
    }

    public void setParameterOverridden(SshConfigParameter sshConfigParameter, boolean bl) {
        HashStructure hashStructure = this.getRootHash();
        HashStructure hashStructure2 = hashStructure.getHashStructure(CONFIG_OVERRIDES_KEY);
        if (bl) {
            if (hashStructure2 == null) {
                hashStructure2 = HashStructure.newInstance();
                hashStructure.putHashStructure(CONFIG_OVERRIDES_KEY, hashStructure2);
            }
            hashStructure2.putBoolean(sshConfigParameter.name(), bl);
        } else if (hashStructure2 != null) {
            hashStructure2.remove(sshConfigParameter.name());
        }
    }

    public String getParameterValue(SshConfigParameter sshConfigParameter) {
        HashStructure hashStructure = this.getRootHash();
        HashStructure hashStructure2 = hashStructure.getHashStructure(CONFIG_PARAMS_KEY);
        return hashStructure2 != null ? hashStructure2.getString(sshConfigParameter.name()) : null;
    }

    public void setParameterValue(SshConfigParameter sshConfigParameter, String string) {
        HashStructure hashStructure = this.getRootHash();
        if (string != null) {
            HashStructure hashStructure2 = hashStructure.getOrCreateHashStructure(CONFIG_PARAMS_KEY);
            hashStructure2.putString(sshConfigParameter.name(), string);
        } else {
            HashStructure hashStructure3 = hashStructure.getHashStructure(CONFIG_PARAMS_KEY);
            if (hashStructure3 != null) {
                hashStructure3.remove(sshConfigParameter.name());
            }
        }
    }

    public Collection<String> getParameterNames() {
        HashStructure hashStructure = this.getRootHash();
        HashStructure hashStructure2 = hashStructure.getHashStructure(CONFIG_PARAMS_KEY);
        return hashStructure2 != null ? hashStructure2.keySet() : Collections.emptySet();
    }
}

