/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.log;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;

public class LogImpl {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/log/LogImpl.java /main/4 2010/02/17 16:23:11 bmoroze Exp $";
    private PrintWriter mOut;
    private int mLevel = 0;
    private String mModule = "all";
    private StringBuffer mBuf;

    public LogImpl(Writer pOut) {
        this.initPrintWriter(pOut);
    }

    public LogImpl(OutputStream pOut) {
        this.initPrintWriter(pOut);
    }

    public LogImpl(String pFilename) {
        try {
            this.initPrintWriter(new FileOutputStream(pFilename));
        }
        catch (Exception e) {
            this.initPrintWriter(this.getDefaultPrintStream());
        }
    }

    public LogImpl() {
        this.initPrintWriter(this.getDefaultPrintStream());
    }

    public void setDestination(Writer pOut) {
        this.initPrintWriter(pOut);
    }

    public void setDestination(OutputStream pOut) {
        this.initPrintWriter(pOut);
    }

    public void setLevel(int pLevel) {
        this.mLevel = pLevel;
    }

    public void setModule(String pModule) {
        this.mModule = pModule;
    }

    public void write(Object pThis, String pString, int pLevel) {
    }

    public void write(String pString, int pLevel) {
        this.write(null, pString, pLevel);
    }

    public void writeEncoded(Object pThis, String pStringe, int pLevel) {
    }

    public void write(Object pThis, Throwable pError, int pLevel) {
    }

    public boolean test(Object pThis, int pLevel) {
        return false;
    }

    public boolean isEnabled(int pLevel) {
        return this.mLevel <= pLevel;
    }

    private void initPrintWriter(OutputStream pOut) {
        try {
            this.mOut = new PrintWriter((Writer)new OutputStreamWriter(pOut, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void initPrintWriter(Writer pOut) {
        this.mOut = pOut instanceof PrintWriter ? (PrintWriter)pOut : new PrintWriter(pOut, true);
    }

    private PrintStream getDefaultPrintStream() {
        try {
            Class<?> t = Class.forName("java.lang.System");
            Field f = t.getField("out");
            Object o = f.get(null);
            return (PrintStream)o;
        }
        catch (Exception e) {
            return null;
        }
    }
}

