/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Map;
import java.util.Vector;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.transform.CollapseableMemberImpl;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.LayerInterfaceWrapper;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.RepeatMap;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeNodeImpl;
import oracle.dss.util.transform.TreeProjection;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public class TreeFromRowImpl
implements TreeProjection {
    protected TreeNode m_node = null;
    protected RowProjection m_proj = null;
    protected String m_layerType = "layerName";
    protected boolean[] m_noCollapseLeaves = null;
    protected RepeatMap m_repeatTable = new RepeatMap();

    public TreeFromRowImpl() {
    }

    public TreeFromRowImpl(RowProjection proj, String dataOnlyColumnKey, String layerType, boolean[] noCollapseLeaves, int edge) throws TransformException {
        this(proj, dataOnlyColumnKey, layerType, noCollapseLeaves, edge, null);
    }

    public TreeFromRowImpl(RowProjection proj, String dataOnlyColumnKey, String layerType, boolean[] noCollapseLeaves, int edge, boolean[] alwaysAdd) throws TransformException {
        this.m_proj = proj;
        if (layerType != null) {
            this.m_layerType = TransformUtils.convertLayerMetadataMap(layerType);
        }
        this.m_noCollapseLeaves = noCollapseLeaves;
        this.m_node = this.buildTree(this.m_proj, dataOnlyColumnKey, edge, alwaysAdd);
    }

    public TreeFromRowImpl(RowProjection proj, String dataOnlyColumnKey, String layerType, boolean[] noCollapseLeaves) throws TransformException {
        this(proj, dataOnlyColumnKey, layerType, noCollapseLeaves, -1);
    }

    public TreeFromRowImpl(RowProjection proj, String dataOnlyColumnKey) throws TransformException {
        this(proj, dataOnlyColumnKey, "layerName", null);
    }

    public TreeFromRowImpl(RowProjection proj, String dataOnlyColumnKey, String layerType) throws TransformException {
        this(proj, dataOnlyColumnKey, layerType, null);
    }

    public void setCollapsed(QDR qdr, boolean collapsed, MemberInterface.AggregatePosition position) throws TransformException {
        TreeNode node = this.m_node;
        String layer = null;
        QDRMember member = null;
        Object memVal = null;
        QDR localQDR = (QDR)qdr.clone();
        TreeNode siblingNode = null;
        while (node != null) {
            if (node.getLayer() == null) {
                node = node.getFirstChild();
                continue;
            }
            layer = node.getLayer().getValue();
            member = localQDR.getDimMember(layer);
            if (member != null) {
                memVal = member.getData();
                boolean found = false;
                for (siblingNode = node; siblingNode != null; siblingNode = siblingNode.getNextSibling()) {
                    if (!memVal.equals(siblingNode.getMember().getValue())) continue;
                    localQDR.removeDimMemberPair(layer);
                    if (localQDR.size() == 0) {
                        ((CollapseableMemberImpl)siblingNode.getMember()).setCollapsed(collapsed, position);
                        return;
                    }
                    node = siblingNode;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
            node = node.getFirstChild();
        }
    }

    @Override
    public boolean placeDataItemsAlone() {
        return false;
    }

    @Override
    public MemberInterface[] getDataItems() {
        return null;
    }

    @Override
    public LayerInterface getDataLayer() {
        return this.m_proj != null ? this.m_proj.getDataLayer() : null;
    }

    @Override
    public DataCellInterface getData(Map<String, Object> keyPath) {
        return this.m_proj.getData(keyPath);
    }

    protected String[] getColumns(String[][] layout, String meas) {
        Vector<String> cols = new Vector<String>();
        for (int e = 0; e < layout.length; ++e) {
            if (layout[e] == null) continue;
            for (int l = 0; l < layout[e].length; ++l) {
                if (layout[e][l].equals(meas)) continue;
                cols.addElement(layout[e][l]);
            }
        }
        return cols.toArray(new String[0]);
    }

    protected TreeNodeImpl generateTreeNodeImpl(MemberInterface member, long extent, TreeNodeImpl parent, LayerInterface layer, String layerType, int edge) throws TransformException {
        return new TreeNodeImpl(member, parent, layer, layerType, edge);
    }

    protected TreeNode buildTree(RowProjection proj, String dataOnlyCol, int edge, boolean[] alwaysAdd) throws TransformException {
        TreeNodeImpl topNode = this.generateTreeNodeImpl(null, -1L, null, null, null, edge);
        RowIterator iter = proj.getRowIterator();
        String[][] layout = proj.getLayout();
        MemberInterface[] dataItems = proj.getDataItems();
        LayerInterface meas = proj.getDataLayer();
        while (iter.nextRow()) {
            this.processRow(iter, topNode, layout, meas, dataItems, proj, dataOnlyCol, edge, alwaysAdd);
        }
        return topNode;
    }

    protected int getEdge(int edge) {
        return edge;
    }

    private String getLayerValue(LayerInterface layerInt) throws TransformException {
        if (layerInt == null) {
            return null;
        }
        LayerInterfaceWrapper tempLayerWrapper = new LayerInterfaceWrapper(layerInt, this.m_layerType);
        return tempLayerWrapper.getValue();
    }

    protected TreeNodeImpl processRow(RowIterator iter, TreeNodeImpl topNode, String[][] layout, LayerInterface measLayerInt, MemberInterface[] dataItems, RowProjection proj, String dataOnlyCol, int singleEdge, boolean[] alwaysAdd) throws TransformException {
        int startEdge = singleEdge == -1 ? layout.length - 1 : singleEdge;
        int endEdge = singleEdge == -1 ? 0 : singleEdge;
        String meas = this.getLayerValue(measLayerInt);
        TreeNodeImpl node = topNode;
        boolean doneMeas = false;
        String layer = null;
        MemberInterface dataOnlyObj = dataOnlyCol != null ? iter.getMember(dataOnlyCol) : null;
        boolean dataOnly = false;
        if (dataOnlyObj != null) {
            dataOnly = Boolean.parseBoolean(dataOnlyObj.getValue());
        }
        if (dataOnly) {
            return null;
        }
        QDR qdr = new QDR();
        for (int e = startEdge; e >= endEdge; --e) {
            int edge = this.getEdge(e);
            for (int l = 0; l < layout[edge].length && (layer = layout[edge][l]) != null; ++l) {
                this.m_repeatTable.createRepeatTableEntries(layer, iter, layout, dataItems, meas);
                if (layer.equals(meas)) {
                    TreeNodeImpl measTop = node;
                    QDR measQDR = null;
                    if (dataItems != null) {
                        for (int m = 0; m < dataItems.length; ++m) {
                            measQDR = (QDR)qdr.clone();
                            node = measTop;
                            TreeNodeImpl newNode = node.findChild(dataItems[m].getValue());
                            if (newNode == null) {
                                MemberInterface mi = iter.getMember(dataItems[m].getValue());
                                TreeNodeImpl tempNode = this.generateTreeNodeImpl(dataItems[m], mi != null ? (Long)mi.getMetadata("extent") : -1L, node, proj.getLayer(layer), this.m_layerType, edge);
                                if (node != null) {
                                    node.addChild(tempNode);
                                }
                                node = tempNode;
                            } else {
                                node = newNode;
                            }
                            LayerInterface dataLayer = this.getDataLayer();
                            measQDR.addDimMemberPair(dataLayer != null ? dataLayer.getValue() : null, new QDRMember(0, dataItems[m].getValue()));
                            for (int measEdge = e; measEdge >= endEdge; --measEdge) {
                                int measLayer;
                                int n = measLayer = measEdge == e ? l + 1 : 0;
                                while (measLayer < layout[measEdge].length) {
                                    this.m_repeatTable.createRepeatTableEntries(layout[measEdge][measLayer], iter, layout, dataItems, meas);
                                    int newMeasEdge = this.getEdge(measEdge);
                                    node = this.processInsertion(node, layout[newMeasEdge][measLayer], newMeasEdge, iter, measQDR, dataOnly, proj, alwaysAdd);
                                    ++measLayer;
                                }
                            }
                        }
                    }
                    doneMeas = true;
                }
                if (doneMeas) break;
                node = this.processInsertion(node, layout[edge][l], edge, iter, qdr, dataOnly, proj, alwaysAdd);
            }
            if (doneMeas) break;
        }
        return topNode;
    }

    protected TreeNodeImpl processInsertion(TreeNodeImpl node, String layer, int edge, RowIterator iter, QDR qdr, boolean dataOnly, RowProjection proj, boolean[] alwaysAdd) throws TransformException {
        MemberInterface currMember = iter.getMember(layer);
        TreeNodeImpl newNode = null;
        if (currMember.getValue() != null) {
            qdr.addDimMemberPair(layer, new QDRMember(0, currMember.getValue()));
            newNode = node.findChild(currMember.getValue());
        }
        if (newNode == null || TransformUtils.alwaysAdd(alwaysAdd, edge)) {
            TreeNodeImpl tempNode = null;
            Long longObj = currMember != null ? (Long)currMember.getMetadata("extent") : null;
            long extent = longObj != null ? longObj : -1L;
            tempNode = this.generateTreeNodeImpl(currMember, extent, node, proj.getLayer(layer), this.m_layerType, edge);
            if (node != null && !dataOnly) {
                node.addChild(tempNode);
            }
            node = tempNode;
            return node;
        }
        return newNode;
    }

    public boolean repeats(String layer) {
        return this.m_repeatTable.repeats(layer);
    }

    @Override
    public boolean isNoCollapseLeaves(int edge) {
        return this.m_noCollapseLeaves != null && this.m_noCollapseLeaves.length > edge ? this.m_noCollapseLeaves[edge] : false;
    }

    @Override
    public String[][] getLayout() {
        return this.m_proj.getLayout();
    }

    @Override
    public TreeNode getNodeTree() {
        return this.m_node;
    }

    @Override
    public boolean repeats(int edge) {
        String[][] layout;
        if (this.m_proj != null && (layout = this.m_proj.getLayout()) != null && layout.length > edge && layout[edge] != null && layout[edge].length > 0) {
            return this.repeats(this.m_proj.getLayout()[edge][0]);
        }
        return false;
    }
}

