/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Hashtable;
import java.util.Map;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.InsertableTreeDataAccess;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.CommonTreeBasedCubicDataAccess;
import oracle.dss.util.transform.CommonTreeProjection;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTreeProjection;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.PageInfo;
import oracle.dss.util.transform.StackPack;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.transform.TreeNode;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public class EdgeTreeBasedCubicDataAccess
extends CommonTreeBasedCubicDataAccess
implements InsertableTreeDataAccess {
    protected CommonTreeProjection[] m_projection = null;
    protected StackPack[] m_stackPack = null;

    public EdgeTreeBasedCubicDataAccess(EdgeTreeProjection[] projection) throws TransformException {
        this.initEdgeTreeBased(projection, this.m_alwaysAdd);
    }

    protected EdgeTreeBasedCubicDataAccess() throws TransformException {
    }

    public void insert(oracle.adf.model.dvt.util.transform.TreeNode[] tn) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EdgeTreeBasedCubicDataAccess da = (EdgeTreeBasedCubicDataAccess)super.clone();
        da.m_layerEdge = (Hashtable)this.m_layerEdge.clone();
        if (this.m_stackPack != null) {
            da.m_stackPack = new StackPack[this.m_stackPack.length];
            for (int i = 0; i < this.m_stackPack.length; ++i) {
                if (this.m_stackPack[i] == null) continue;
                da.m_stackPack[i] = (StackPack)this.m_stackPack[i].clone();
            }
        }
        return da;
    }

    private void initEdgeTreeBased(EdgeTreeProjection[] projection, boolean[] alwaysAdd) throws TransformException {
        this.m_cube = new Cube(new PageInfo(true));
        this.initCaches();
        this.m_projection = new EdgeTreeProjection[projection.length];
        this.m_stackPack = new StackPack[projection.length];
        for (int e = 0; e < projection.length; ++e) {
            TreeNode nodes;
            this.m_projection[e] = projection[e].getDataItems() != null ? new ImpliedMeasureEdgeTreeProjection(projection[e]) : projection[e];
            if (projection[e] == null || (nodes = this.m_projection[e].getNodeTree()) == null) continue;
            if (this.m_stackPack[e] == null) {
                this.m_stackPack[e] = new StackPack();
            }
            this.buildTree(nodes, this.m_stackPack[e], e, -1L, null, alwaysAdd);
        }
        this.m_cube.lockTrees();
    }

    @Override
    protected LayerInterface getDataLayerInterface() {
        for (int e = 0; e < this.m_projection.length; ++e) {
            if (this.m_projection[e] == null) continue;
            return this.m_projection[e].getDataLayer();
        }
        return null;
    }

    @Override
    protected BaseProjection getProjection() {
        for (int e = 0; e < this.m_projection.length; ++e) {
            if (this.m_projection[e] == null) continue;
            return this.m_projection[e];
        }
        return null;
    }

    protected TreeBasedEdgeTree getEdgeTree(int edge) throws TransformException {
        BaseProjection proj = this.getProjection();
        return new TreeBasedEdgeTree(this._getLayers(edge), edge, proj, proj.getDataLayer().getValue(), TransformUtils.getMeasList(proj), this.isNoCollapsedLeaves(edge), -1L, this);
    }

    private boolean isNoCollapsedLeaves(int edge) {
        if (this.m_projection[edge] instanceof EdgeTreeProjection) {
            return ((EdgeTreeProjection)this.m_projection[edge]).isNoCollapseLeaves();
        }
        return true;
    }

    @Override
    protected TreeBasedEdgeTree getEdgeTree(TreeNode node, long slice, boolean checked) throws TransformException {
        int edge = this.getEdgeForLayer(node);
        TreeBasedEdgeTree et = null;
        try {
            et = (TreeBasedEdgeTree)super.getEdgeTree(edge, slice, checked);
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
        if (et == null) {
            et = this.getEdgeTree(edge);
            this.m_cube.setEdgeTree(edge, et, this.getCurrentPage());
        }
        return et;
    }

    protected class ImpliedMeasureEdgeTreeProjection
    extends CommonTreeBasedCubicDataAccess.ImpliedMeasureCommonTreeProjection
    implements EdgeTreeProjection {
        protected EdgeTreeProjection m_proj;
        protected CommonTreeBasedCubicDataAccess.ImpliedMeasureTreeNode m_node;
        protected String[][] m_layout;
        protected int m_impliedMeasureEdge;

        public ImpliedMeasureEdgeTreeProjection(EdgeTreeProjection proj) {
            super(proj);
            this.m_proj = null;
            this.m_node = null;
            this.m_layout = null;
            this.m_impliedMeasureEdge = -1;
            this.m_proj = proj;
        }

        @Override
        protected int findBottom() throws TransformException {
            String[][] layout = this.m_proj.getLayout();
            if (layout == null) {
                return -1;
            }
            return this.walkTree(layout, this.m_proj.getNodeTree());
        }

        @Override
        protected int getNewLength(String[][] origLayout) {
            return origLayout.length;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            return this.m_proj.getData(keyPath);
        }

        @Override
        public TreeNode getNodeTree() {
            if (this.m_node == null) {
                this.m_node = new CommonTreeBasedCubicDataAccess.ImpliedMeasureTreeNode(this.m_proj.getNodeTree(), this);
            }
            return this.m_node;
        }

        @Override
        public boolean isNoCollapseLeaves() {
            return true;
        }
    }
}

