/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import oracle.dss.util.persistence.ComponentAttributes;
import oracle.javatools.mt.annotation.CodeSharingSafe;

@CodeSharingSafe(value="StaticInitializer")
public class PersistableAttributes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BitSet m_formatUsedFlags;
    private static final int OBJECT_NAME_BIT = 0;
    private static final int DESCRIPTION_BIT = 1;
    private static final int KEYWORDS_BIT = 2;
    private static final int APPLICATION_BIT = 3;
    private static final int DATABASE_BIT = 4;
    private static final int APPLICATION_SUBTYPE_BIT = 5;
    private static final int OBJECT_TYPE_BIT = 6;
    private static final int OBJECT_TYPE_VERSION_BIT = 7;
    private static final int TITLE_BIT = 8;
    private static final int COMP_SUBTYPE_1_BIT = 9;
    private static final int COMP_SUBTYPE_2_BIT = 10;
    private static final int COMP_SUBTYPE_3_BIT = 11;
    private static final int COMPONENT_ATTRIBUTES_BIT = 12;
    private static final int NUMBER_OF_FORMAT_BITS = 13;
    private String m_uoid;
    private String m_newUoid = null;
    private int m_generation = 0;
    private Date m_dateCreated;
    private Date m_dateModified;
    private Date m_dateLastAccessed;
    private String m_creator;
    private String m_modifier;
    private boolean m_userVisible;
    private String m_objFullPathName;
    private String m_name;
    private String m_desc;
    private String m_keywords;
    private String m_app;
    private String m_db;
    private String m_appSubType;
    private String m_objType;
    private int m_version = -1;
    private String m_title;
    private String m_compSubType1;
    private String m_compSubType2;
    private String m_compSubType3;
    private ComponentAttributes m_extensibleComponentAttrbs = null;
    @CodeSharingSafe(value="StaticField")
    private static BitSet NoBitsSet = new BitSet(13);

    public PersistableAttributes(String name, String uoid, Date dateCreated, Date dateModified, String creator, String modifier, boolean userVisible, String objFullPathName, Date dateLastAccessed) {
        this.m_name = name;
        this.m_uoid = uoid;
        this.m_objFullPathName = objFullPathName;
        this.m_dateCreated = dateCreated;
        this.m_dateModified = dateModified;
        this.m_dateLastAccessed = dateLastAccessed;
        this.m_creator = creator;
        this.m_modifier = modifier;
        this.m_userVisible = userVisible;
        this.m_formatUsedFlags = new BitSet(13);
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public PersistableAttributes(String objType, int version, String title, String compSubType1, String compSubType2, String compSubType3) {
        this.m_objType = objType;
        this.m_version = version;
        this.m_title = title;
        this.m_compSubType1 = compSubType1;
        this.m_compSubType2 = compSubType2;
        this.m_compSubType3 = compSubType3;
        this.m_formatUsedFlags = new BitSet(13);
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVisible(boolean visible) {
        this.m_userVisible = visible;
    }

    public void setFullPath(String fullPath) {
        this.m_objFullPathName = fullPath;
    }

    public PersistableAttributes() {
        this.m_formatUsedFlags = new BitSet(13);
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public boolean isAnythingOverridden() {
        return !this.m_formatUsedFlags.equals(NoBitsSet);
    }

    public void clearUsedBits() {
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public void dump() {
        for (int i = 0; i < 13; ++i) {
            System.out.println(this.m_formatUsedFlags.get(i));
        }
    }

    public Object clone() {
        PersistableAttributes _attrs = new PersistableAttributes(this.getObjectName(), this.getUOID(), this.getTimeDateCreated(), this.getTimeDateModified(), this.getCreatedBy(), this.getModifiedBy(), this.getUserVisible(), this.getObjectFullPathName(), this.getTimeDateLastAccessed());
        _attrs.setNewUOID(this.m_newUoid);
        _attrs.setGeneration(this.m_generation);
        _attrs.setDescription(this.m_desc);
        _attrs.setKeywords(this.m_keywords);
        _attrs.setApplication(this.m_app);
        _attrs.setDatabase(this.m_db);
        _attrs.setApplicationSubType(this.m_appSubType);
        _attrs.setObjectType(this.m_objType);
        _attrs.setObjectTypeVersion(this.m_version);
        _attrs.setTitle(this.m_title);
        _attrs.setCompSubType1(this.m_compSubType1);
        _attrs.setCompSubType2(this.m_compSubType2);
        _attrs.setCompSubType3(this.m_compSubType3);
        if (this.m_extensibleComponentAttrbs != null) {
            _attrs.setExtensibleComponentAttributes((ComponentAttributes)this.m_extensibleComponentAttrbs.clone());
        }
        return _attrs;
    }

    public void merge(PersistableAttributes from) {
        PersistableAttributes attrs = from;
        if (attrs.isObjectNameUsed()) {
            this.setObjectName(attrs.getObjectName());
        }
        if (attrs.isDescriptionUsed()) {
            this.setDescription(attrs.getDescription());
        }
        if (attrs.isKeywordsUsed()) {
            this.setKeywords(attrs.getKeywords());
        }
        if (attrs.isApplicationUsed()) {
            this.setApplication(attrs.getApplication());
        }
        if (attrs.isDatabaseUsed()) {
            this.setDatabase(attrs.getDatabase());
        }
        if (attrs.isApplicationSubTypeUsed()) {
            this.setApplicationSubType(attrs.getApplicationSubType());
        }
        if (attrs.isObjectTypeUsed()) {
            this.setObjectType(attrs.getObjectType());
        }
        if (attrs.isObjectTypeVersionUsed()) {
            this.setObjectTypeVersion(attrs.getObjectTypeVersion());
        }
        if (attrs.isTitleUsed()) {
            this.setTitle(attrs.getTitle());
        }
        if (attrs.isCompSubType1Used()) {
            this.setCompSubType1(attrs.getCompSubType1());
        }
        if (attrs.isCompSubType2Used()) {
            this.setCompSubType2(attrs.getCompSubType2());
        }
        if (attrs.isCompSubType3Used()) {
            this.setCompSubType3(attrs.getCompSubType3());
        }
    }

    public String getUOID() {
        return this.m_uoid;
    }

    public String getNewUOID() {
        return this.m_newUoid;
    }

    public void setUOID(String id) {
        this.m_uoid = id;
    }

    public int getGeneration() {
        return this.m_generation;
    }

    public void setGeneration(int generation) {
        this.m_generation = generation;
    }

    public void setNewUOID(String id) {
        this.m_newUoid = id;
    }

    public String getObjectFullPathName() {
        return this.m_objFullPathName;
    }

    public Date getTimeDateCreated() {
        return this.m_dateCreated;
    }

    public void setTimeDateCreated(Date d) {
        this.m_dateCreated = d;
    }

    public Date getTimeDateModified() {
        return this.m_dateModified;
    }

    public void setTimeDateModified(Date d) {
        this.m_dateModified = d;
    }

    public void clearTrackingAttributes() {
        this.m_dateModified = null;
        this.m_modifier = null;
        this.m_dateLastAccessed = null;
    }

    public Date getTimeDateLastAccessed() {
        return this.m_dateLastAccessed;
    }

    public void setTimeDateLastAccessed(Date d) {
        this.m_dateLastAccessed = d;
    }

    public String getCreatedBy() {
        return this.m_creator;
    }

    public void setCreatedBy(String creator) {
        this.m_creator = creator;
    }

    public String getModifiedBy() {
        return this.m_modifier;
    }

    public void setModifiedBy(String modifier) {
        this.m_modifier = modifier;
    }

    public boolean getUserVisible() {
        return this.m_userVisible;
    }

    public boolean isObjectNameUsed() {
        return this.m_formatUsedFlags.get(0);
    }

    public void setObjectNameUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(0);
        } else {
            this.m_formatUsedFlags.clear(0);
        }
    }

    public String getObjectName() {
        return this.m_name;
    }

    public void setObjectName(String name) {
        this.setObjectNameUsed(true);
        this.m_name = name;
    }

    public String getObjectLabel() {
        return this.m_name;
    }

    public boolean isDescriptionUsed() {
        return this.m_formatUsedFlags.get(1);
    }

    public void setDescriptionUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(1);
        } else {
            this.m_formatUsedFlags.clear(1);
        }
    }

    public String getDescription() {
        return this.m_desc;
    }

    public void setDescription(String desc) {
        this.setDescriptionUsed(true);
        this.m_desc = desc;
    }

    public boolean isKeywordsUsed() {
        return this.m_formatUsedFlags.get(2);
    }

    public void setKeywordsUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(2);
        } else {
            this.m_formatUsedFlags.clear(2);
        }
    }

    public String getKeywords() {
        return this.m_keywords;
    }

    public void setKeywords(String keywords) {
        this.setKeywordsUsed(true);
        this.m_keywords = keywords;
    }

    public boolean isApplicationUsed() {
        return this.m_formatUsedFlags.get(3);
    }

    public void setApplicationUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(0);
        } else {
            this.m_formatUsedFlags.clear(0);
        }
    }

    public String getApplication() {
        return this.m_app;
    }

    public void setApplication(String app) {
        this.setApplicationUsed(true);
        this.m_app = app;
    }

    public boolean isDatabaseUsed() {
        return this.m_formatUsedFlags.get(4);
    }

    public void setDatabaseUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(4);
        } else {
            this.m_formatUsedFlags.clear(4);
        }
    }

    public String getDatabase() {
        return this.m_db;
    }

    public void setDatabase(String db) {
        this.setDatabaseUsed(true);
        this.m_db = db;
    }

    public boolean isApplicationSubTypeUsed() {
        return this.m_formatUsedFlags.get(5);
    }

    public void setApplicationSubTypeUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(5);
        } else {
            this.m_formatUsedFlags.clear(5);
        }
    }

    public String getApplicationSubType() {
        return this.m_appSubType;
    }

    public void setApplicationSubType(String appSubType) {
        this.setApplicationSubTypeUsed(true);
        this.m_appSubType = appSubType;
    }

    public boolean isObjectTypeUsed() {
        return this.m_formatUsedFlags.get(6);
    }

    public void setObjectTypeUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(6);
        } else {
            this.m_formatUsedFlags.clear(6);
        }
    }

    public String getObjectType() {
        return this.m_objType;
    }

    public void setObjectType(String objType) {
        this.setObjectTypeUsed(true);
        this.m_objType = objType;
    }

    public boolean isObjectTypeVersionUsed() {
        return this.m_formatUsedFlags.get(7);
    }

    public void setObjectTypeVersionUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(7);
        } else {
            this.m_formatUsedFlags.clear(7);
        }
    }

    public int getObjectTypeVersion() {
        return this.m_version;
    }

    public void setObjectTypeVersion(int version) {
        this.setObjectTypeVersionUsed(true);
        this.m_version = version;
    }

    public boolean isTitleUsed() {
        return this.m_formatUsedFlags.get(8);
    }

    public void setTitleUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(8);
        } else {
            this.m_formatUsedFlags.clear(8);
        }
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.setTitleUsed(true);
        this.m_title = title;
    }

    public boolean isCompSubType1Used() {
        return this.m_formatUsedFlags.get(9);
    }

    public void setCompSubType1Used(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(9);
        } else {
            this.m_formatUsedFlags.clear(9);
        }
    }

    public String getCompSubType1() {
        return this.m_compSubType1;
    }

    public void setCompSubType1(String compSubType1) {
        this.setCompSubType1Used(true);
        this.m_compSubType1 = compSubType1;
    }

    public boolean isCompSubType2Used() {
        return this.m_formatUsedFlags.get(10);
    }

    public void setCompSubType2Used(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(10);
        } else {
            this.m_formatUsedFlags.clear(10);
        }
    }

    public String getCompSubType2() {
        return this.m_compSubType2;
    }

    public void setCompSubType2(String compSubType2) {
        this.setCompSubType2Used(true);
        this.m_compSubType2 = compSubType2;
    }

    public boolean isCompSubType3Used() {
        return this.m_formatUsedFlags.get(11);
    }

    public void setCompSubType3Used(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(11);
        } else {
            this.m_formatUsedFlags.clear(11);
        }
    }

    public String getCompSubType3() {
        return this.m_compSubType3;
    }

    public void setCompSubType3(String compSubType3) {
        this.setCompSubType3Used(true);
        this.m_compSubType3 = compSubType3;
    }

    public void setExtensibleComponentAttributes(ComponentAttributes attrbs) {
        this.setExtensibleComponentAttributesUsed(true);
        this.m_extensibleComponentAttrbs = attrbs;
    }

    public ComponentAttributes getExtensibleComponentAttributes() {
        return this.m_extensibleComponentAttrbs;
    }

    public void setExtensibleComponentAttributesUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(12);
        } else {
            this.m_formatUsedFlags.clear(12);
        }
    }

    public Attributes getUntypedAttributes() {
        BasicAttributes _attrs = new BasicAttributes();
        if (this.getUOID() != null) {
            _attrs.put("object_id", this.getUOID());
        }
        _attrs.put("user_visible", new Boolean(this.getUserVisible()));
        if (this.getTimeDateCreated() != null) {
            _attrs.put("time_date_created", this.getTimeDateCreated());
        }
        if (this.getTimeDateModified() != null) {
            _attrs.put("time_date_modified", this.getTimeDateModified());
        }
        if (this.getCreatedBy() != null) {
            _attrs.put("created_by", this.getCreatedBy());
        }
        if (this.getModifiedBy() != null) {
            _attrs.put("modified_by", this.getModifiedBy());
        }
        if (this.getObjectName() != null) {
            _attrs.put("object_name", this.getObjectName());
        }
        if (this.getObjectFullPathName() != null) {
            _attrs.put("obj_fullpath_name", this.getObjectFullPathName());
        }
        if (this.getDescription() != null) {
            _attrs.put("description", this.getDescription());
        }
        if (this.getKeywords() != null) {
            _attrs.put("keywords", this.getKeywords());
        }
        if (this.getApplication() != null) {
            _attrs.put("application", this.getApplication());
        }
        if (this.getDatabase() != null) {
            _attrs.put("database", this.getDatabase());
        }
        if (this.getApplicationSubType() != null) {
            _attrs.put("application_subtype1", this.getApplicationSubType());
        }
        if (this.getObjectType() != null) {
            _attrs.put("object_type", this.getObjectType());
        }
        if (this.isObjectTypeVersionUsed()) {
            _attrs.put("version", new Integer(this.getObjectTypeVersion()));
        }
        if (this.getTitle() != null) {
            _attrs.put("title", this.getTitle());
        }
        if (this.getCompSubType1() != null) {
            _attrs.put("comp_subtype1", this.getCompSubType1());
        }
        if (this.getCompSubType2() != null) {
            _attrs.put("comp_subtype2", this.getCompSubType2());
        }
        if (this.getCompSubType3() != null) {
            _attrs.put("comp_subtype3", this.getCompSubType3());
        }
        if (this.getExtensibleComponentAttributes() != null) {
            _attrs.put("extensible_component_attributes", this.getExtensibleComponentAttributes());
        }
        if (this.getTimeDateLastAccessed() != null) {
            _attrs.put("time_date_last_accessed", this.getTimeDateLastAccessed());
        }
        return _attrs;
    }

    static {
        for (int i = 0; i < 13; ++i) {
            NoBitsSet.clear(i);
        }
    }
}

