/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dss.util.gui.context.PropertyHashtable;

public class ResourceHandler
extends PropertyHashtable {
    private static final long serialVersionUID = 1L;
    private String m_strDefaultResourceBundleClass = null;
    private Locale m_locale = null;

    public ResourceHandler() {
    }

    public ResourceHandler(Locale locale) {
        this.setLocale(locale);
    }

    public ResourceHandler(String strDefaultResourceBundleClass) {
        this(strDefaultResourceBundleClass, null);
    }

    public ResourceHandler(String strDefaultResourceBundleClass, Locale locale) {
        this.setDefaultResourceBundleClass(strDefaultResourceBundleClass);
        this.setLocale(locale);
    }

    public String getDefaultResourceBundleClass() {
        return this.m_strDefaultResourceBundleClass;
    }

    public void setDefaultResourceBundleClass(String strDefaultResourceBundleClass) {
        this.m_strDefaultResourceBundleClass = strDefaultResourceBundleClass;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        String[] objResourceBundleClasses = (String[])this.getPropertyKeys();
        Object resourceBundle = null;
        if (objResourceBundleClasses != null) {
            for (int nIndex = 0; nIndex < objResourceBundleClasses.length; ++nIndex) {
                this.getResourceBundle(objResourceBundleClasses[nIndex], true);
            }
        }
    }

    public Locale getLocale() {
        return this.m_locale != null ? this.m_locale : Locale.getDefault();
    }

    public String getResourceString(String strResourceBundleClass, String strKey) {
        String strResource = null;
        try {
            ResourceBundle resourceBundle = this.getResourceBundle(strResourceBundleClass);
            strResource = resourceBundle == null ? strKey : resourceBundle.getString(strKey);
        }
        catch (MissingResourceException missingResourceBundle) {
            strResource = strKey;
        }
        return strResource;
    }

    public String getResourceString(String strKey) {
        String strResource = null;
        try {
            ResourceBundle resourceBundle = this.getResourceBundle(this.getDefaultResourceBundleClass());
            strResource = resourceBundle == null ? strKey : resourceBundle.getString(strKey);
        }
        catch (MissingResourceException missingResourceBundle) {
            strResource = strKey;
        }
        return strResource;
    }

    public ResourceBundle getResourceBundle(String strResourceBundleClassName) {
        return this.getResourceBundle(strResourceBundleClassName, false);
    }

    public ResourceBundle getResourceBundle(String strResourceBundleClassName, boolean bForceUpdate) {
        ResourceBundle resourceBundle = null;
        if (strResourceBundleClassName != null && ((resourceBundle = (ResourceBundle)this.getProperty(strResourceBundleClassName)) == null || bForceUpdate) && (resourceBundle = ResourceBundle.getBundle(strResourceBundleClassName, this.getLocale())) != null) {
            this.setProperty(strResourceBundleClassName, resourceBundle);
        }
        return resourceBundle;
    }

    public void cleanUp() {
        this.removeAll();
    }
}

