/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import oracle.dss.util.QDR;
import oracle.dss.util.Utility;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Object m_objValue = null;
    protected Class m_classType = null;

    public Parameter() {
    }

    public Parameter(Object objValue, Class classValue) {
        this.setValue(objValue);
        this.setType(classValue);
    }

    public Parameter(Object objValue) {
        if (objValue != null) {
            if (objValue instanceof String) {
                this.setValue(new String((String)objValue));
                this.setType(String.class);
            } else if (objValue instanceof QDR) {
                this.setValue(new QDR((QDR)objValue));
                this.setType(QDR.class);
            } else if (objValue instanceof Integer) {
                this.setValue(new Integer((Integer)objValue));
                this.setType(Integer.class);
            } else if (objValue instanceof Long) {
                this.setValue(new Long((Long)objValue));
                this.setType(Long.class);
            } else if (objValue instanceof Float) {
                this.setValue(new Float(((Float)objValue).floatValue()));
                this.setType(Float.class);
            } else if (objValue instanceof Double) {
                this.setValue(new Double((Double)objValue));
                this.setType(Double.class);
            } else if (objValue instanceof Boolean) {
                this.setValue(new Boolean((Boolean)objValue));
                this.setType(Boolean.class);
            }
        }
    }

    public Parameter(String strValue) {
        this.setValue(strValue != null ? new String(strValue) : null);
        this.setType(String.class);
    }

    public Parameter(int nValue) {
        this.setValue(new Integer(nValue));
        this.setType(Integer.class);
    }

    public Parameter(float fValue) {
        this.setValue(new Float(fValue));
        this.setType(Float.class);
    }

    public Parameter(long lValue) {
        this.setValue(new Long(lValue));
        this.setType(Long.class);
    }

    public Parameter(double dValue) {
        this.setValue(new Double(dValue));
        this.setType(Double.class);
    }

    public Parameter(boolean bValue) {
        this.setValue(new Boolean(bValue));
        this.setType(Boolean.class);
    }

    public Object clone() throws CloneNotSupportedException {
        Boolean booleanValue;
        Parameter parameter = null;
        parameter = (Parameter)super.clone();
        parameter.setType(this.getType());
        if (this.getType() == QDR.class) {
            QDR qdrValue = (QDR)this.getValue();
            if (qdrValue != null) {
                parameter.setValue(qdrValue.clone());
            }
        } else if (this.getType() == String.class) {
            String strValue = (String)this.getValue();
            if (strValue != null) {
                parameter.setValue(new String(strValue));
            }
        } else if (this.getType() == Integer.class) {
            Integer intValue = (Integer)this.getValue();
            if (intValue != null) {
                parameter.setValue(new Integer(intValue));
            }
        } else if (this.getType() == Long.class) {
            Long longValue = (Long)this.getValue();
            if (longValue != null) {
                parameter.setValue(new Long(longValue));
            }
        } else if (this.getType() == Float.class) {
            Float floatValue = (Float)this.getValue();
            if (floatValue != null) {
                parameter.setValue(new Float(floatValue.floatValue()));
            }
        } else if (this.getType() == Double.class) {
            Double doubleValue = (Double)this.getValue();
            if (doubleValue != null) {
                parameter.setValue(new Double(doubleValue));
            }
        } else if (this.getType() == Boolean.class && (booleanValue = (Boolean)this.getValue()) != null) {
            parameter.setValue(new Boolean(booleanValue));
        }
        return parameter;
    }

    public boolean equals(Object objValue) {
        if (objValue == null || !(objValue instanceof Parameter)) {
            return false;
        }
        return Utility.compareObj(this.getValue(), ((Parameter)objValue).getValue()) && Utility.compareObj(this.getType(), ((Parameter)objValue).getType());
    }

    public Class getType() {
        return this.m_classType;
    }

    public Object getValue() {
        return this.m_objValue;
    }

    public void setValue(Object objValue) {
        this.m_objValue = objValue;
    }

    public void setType(Class classType) {
        this.m_classType = classType;
    }

    public String toString() {
        return Utility.arrayToString(this.getValue());
    }
}

