/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;

public class CustomStyle
implements Persistable {
    private String _title = "Unnamed Style";
    private String _xmlString = null;
    private CustomStyle _baseStyle = null;
    private String _persistableObjectType = null;
    private PersistableAttributes _attrs;

    public CustomStyle() {
    }

    public CustomStyle(String xml) {
        this.setXMLAsString(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomStyle(Class object, String stylePath) throws IOException {
        try (InputStream stream = null;){
            stream = object.getResourceAsStream(stylePath);
            this.init(stream);
        }
    }

    public CustomStyle(InputStream stream) throws IOException {
        this.init(stream);
    }

    private void init(InputStream stream) throws IOException {
        if (stream == null) {
            throw new FileNotFoundException();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException();
        }
        char[] charArray = new char[2048];
        int charRead = 0;
        StringBuffer xmlString = new StringBuffer();
        while ((charRead = ((Reader)reader).read(charArray, 0, charArray.length)) != -1) {
            xmlString.append(charArray, 0, charRead);
        }
        this.setXMLAsString(xmlString.toString());
    }

    public CustomStyle getBaseStyle() {
        return this._baseStyle;
    }

    public void setBaseStyle(CustomStyle baseStyle) {
        this._baseStyle = baseStyle;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getPersistableObjectType() {
        return this._persistableObjectType;
    }

    public void setPersistableObjectType(String persistableObjectType) {
        this._persistableObjectType = persistableObjectType;
    }

    @Override
    public void initialize(Hashtable env) {
    }

    @Override
    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregates = null;
        CustomStyle style = this.getBaseStyle();
        if (style != null && style instanceof Persistable) {
            aggregates = new AggregateInfo[]{new AggregateInfo(style, 0)};
        }
        return aggregates;
    }

    @Override
    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null && persistables.length > 0) {
            this.setBaseStyle((CustomStyle)persistables[0].getPersistable());
        }
    }

    @Override
    public PersistableAttributes getPersistableAttributes(PersistableAttributes attrs) {
        String type;
        PersistableAttributes result = null;
        result = this._attrs == null ? new PersistableAttributes() : (PersistableAttributes)this._attrs.clone();
        if (attrs != null) {
            result.merge(attrs);
        }
        if ((type = this.getPersistableObjectType()) != null) {
            result.setObjectType(type);
        } else {
            result.setObjectType("GraphStyle");
        }
        result.setTitle(this.getTitle());
        return result;
    }

    @Override
    public void setPersistableAttributes(PersistableAttributes attrs) {
        this._attrs = attrs;
    }

    @Override
    public String getXMLAsString() {
        return this._xmlString;
    }

    @Override
    public boolean setXMLAsString(String xml) {
        this._xmlString = xml;
        return true;
    }
}

