/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Hashtable;
import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.util.QDR;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class QDRDiscriminator
implements DiscriminatorXML,
DiscriminatorState {
    private static final long serialVersionUID = 1L;
    protected QDR m_QDR = null;
    protected int m_setOperator = 3;
    public static final int SUBSET = 0;
    public static final int PROPER_SUBSET = 1;
    public static final int PROPER_SUPERSET = 2;
    public static final int EQUALS = 3;
    public static final int SUPERSET = 4;
    protected static final String QDR_NAME = "QDRName";
    protected static final String S_NAME_QDR_DISC = "QD";
    protected static final String s_setOperator = "s";
    protected static final String s_qdrString = "q";
    @CodeSharingSafe(value="StaticField")
    protected static QDRDiscriminator m_defaultDiscriminator = null;
    protected Hashtable m_context = null;
    public static final String NAME_QDR_DISC = "QDRDisc";
    protected static final int setOperator = 0;
    protected static final String a_setOperator = "setOp";
    protected static final String subset = "SUBSET";
    protected static final String proper_subset = "PROPER_SUBSET";
    protected static final String proper_superset = "PROPER_SUPERSET";
    protected static final String equals = "EQUALS";
    protected static final String superset = "SUPERSET";

    public QDRDiscriminator() {
    }

    public QDRDiscriminator(QDR qdr, int setOp) {
        this.m_QDR = (QDR)(qdr != null ? qdr.clone() : qdr);
        this.m_setOperator = setOp;
    }

    @Override
    public Object clone() {
        return new QDRDiscriminator(this.m_QDR, this.m_setOperator);
    }

    public void setQDR(QDR qdr) {
        this.m_QDR = (QDR)(qdr != null ? qdr.clone() : qdr);
    }

    public QDR getQDR() {
        return this.m_QDR;
    }

    public void setSetOperator(int setOp) {
        if (setOp < 0 || setOp > 4) {
            return;
        }
        this.m_setOperator = setOp;
    }

    public int getSetOperator() {
        return this.m_setOperator;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QDRDiscriminator)) {
            return false;
        }
        return ((QDRDiscriminator)o).getSetOperator() == this.getSetOperator() && this.getQDR() != null && ((QDRDiscriminator)o).getQDR().equals(this.getQDR());
    }

    @Override
    public boolean applies(RuleContext context) {
        boolean bApplies;
        if (this.m_QDR == null) {
            return false;
        }
        QDR ruleContextQDR = (QDR)context.get("QDR");
        QDR dimensionQDR = (QDR)context.get("DIMENSIONQDR");
        switch (this.m_setOperator) {
            case 0: {
                bApplies = this.m_QDR.isSubsetOf(ruleContextQDR);
                break;
            }
            case 1: {
                bApplies = this.m_QDR.isProperSubsetOf(ruleContextQDR);
                break;
            }
            case 2: {
                bApplies = this.m_QDR.isProperSupersetOf(ruleContextQDR);
                break;
            }
            case 3: {
                bApplies = this.m_QDR.equals(ruleContextQDR) || this.m_QDR.equals(dimensionQDR);
                break;
            }
            case 4: {
                bApplies = this.m_QDR.isSupersetOf(ruleContextQDR);
                break;
            }
            default: {
                bApplies = this.m_QDR.equals(ruleContextQDR);
            }
        }
        return bApplies;
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    @Override
    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        PropertyNode pNode;
        XMLContext xmlContext = this.m_context != null && this.m_context.containsKey("xml_context") ? (XMLContext)this.m_context.get("xml_context") : new XMLContext(new ObjectScope(), false);
        if (xmlContext.getScope() == null) {
            xmlContext.setScope(new ObjectScope());
        }
        if ((pNode = node.getProperty(a_setOperator)) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals(subset)) {
                this.setSetOperator(0);
            } else if (tmp.equals(proper_subset)) {
                this.setSetOperator(1);
            } else if (tmp.equals(proper_superset)) {
                this.setSetOperator(2);
            } else if (tmp.equals(equals)) {
                this.setSetOperator(3);
            } else if (tmp.equals(superset)) {
                this.setSetOperator(4);
            }
        }
        String qdrName = null;
        try {
            qdrName = node.getPropertyValueAsString(QDR_NAME);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        ContainerNode XML = null;
        String qdrClass = null;
        if (qdrName == null) {
            XML = node.getContainer("QDR");
            if (XML == null) {
                XML = node.getContainer("dvt-cube:QDR");
            }
        } else {
            XML = node.getContainer(qdrName);
            if (XML == null && qdrName.equals("QDR")) {
                XML = node.getContainer("dvt-cube:QDR");
            }
            if (!qdrName.equals("QDR")) {
                qdrClass = "oracle.dss.selection.OlapQDR";
            }
        }
        if (XML != null) {
            if (this.getQDR() != null) {
                this.getQDR().setXML(xmlContext, XML);
            } else {
                QDR tmp = null;
                Class<?> qdrClassObj = null;
                if (qdrClass != null) {
                    try {
                        qdrClassObj = Class.forName(qdrClass);
                        tmp = (QDR)qdrClassObj.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (tmp == null) {
                    tmp = new QDR();
                }
                tmp.setXML(xmlContext, XML);
                this.setQDR(tmp);
            }
        }
        return true;
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter converter, boolean emptyElement) {
        ObjectNode node = new ObjectNode(NAME_QDR_DISC);
        boolean nodeExists = false;
        if (this.getQDR() != null) {
            XMLContext xmlContext = this.m_context != null && this.m_context.containsKey("xml_context") ? (XMLContext)this.m_context.get("xml_context") : new XMLContext(new ObjectScope(), false);
            if (xmlContext.getScope() == null) {
                xmlContext.setScope(new ObjectScope());
            }
            xmlContext.getScope().addObject("allProperties", new Boolean(allProperties));
            ContainerNode qdrxml = (ContainerNode)this.getQDR().getXML(xmlContext);
            if (qdrxml != null) {
                node.addProperty(QDR_NAME, qdrxml.getName());
                node.addContainer(qdrxml);
                nodeExists = true;
            }
        }
        if (this.getSetOperator() == 0) {
            node.addProperty(a_setOperator, subset);
        } else if (this.getSetOperator() == 1) {
            node.addProperty(a_setOperator, proper_subset);
        } else if (this.getSetOperator() == 2) {
            node.addProperty(a_setOperator, proper_superset);
        } else if (this.getSetOperator() == 3) {
            node.addProperty(a_setOperator, equals);
        } else if (this.getSetOperator() == 4) {
            node.addProperty(a_setOperator, superset);
        }
        return node;
    }

    @Override
    public void setStateAsObjectNode(List context, ObjectNode node, DiscriminatorState baseState) {
        QDRDiscriminator baseDisc;
        PropertyNode pNode = node.getProperty(s_setOperator);
        QDRDiscriminator qDRDiscriminator = baseDisc = baseState instanceof QDRDiscriminator ? (QDRDiscriminator)baseState : null;
        if (pNode != null) {
            this.setSetOperator(pNode.getValueAsInteger());
        } else if (baseDisc != null) {
            this.setSetOperator(baseDisc.getSetOperator());
        } else {
            this.setSetOperator(4);
        }
        pNode = node.getProperty(s_qdrString);
        if (pNode != null) {
            this.setQDR(QDR.setStateString(context, pNode.getValueAsString()));
        } else if (baseDisc != null) {
            this.setQDR((QDR)baseDisc.getQDR().clone());
        } else {
            this.setQDR(new QDR());
        }
    }

    @Override
    public ObjectNode getStateAsObjectNode(List context, DiscriminatorState baseState) {
        ObjectNode node = new ObjectNode(S_NAME_QDR_DISC);
        QDRDiscriminator baseDisc = baseState instanceof QDRDiscriminator ? (QDRDiscriminator)baseState : QDRDiscriminator.createDefaultDiscriminator();
        boolean nodeExists = false;
        if (baseDisc.getSetOperator() != this.getSetOperator()) {
            node.addProperty(s_setOperator, this.getSetOperator());
            nodeExists = true;
        }
        if (!Utility.compareObj(baseDisc.getQDR(), this.getQDR())) {
            node.addProperty(s_qdrString, this.getQDR().getStateString(context));
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    protected static QDRDiscriminator createDefaultDiscriminator() {
        if (m_defaultDiscriminator == null) {
            m_defaultDiscriminator = new QDRDiscriminator();
            m_defaultDiscriminator.setSetOperator(4);
        }
        return m_defaultDiscriminator;
    }
}

