/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.RowIterator;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.RowsetCollection;
import oracle.adfinternal.model.dvt.util.transform.RowsetCollectionSetter;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.dss.util.Utility;
import oracle.javatools.annotations.Concealed;

@Concealed
public class RowsetRecord
implements Map<String, Object> {
    private static final int INITIAL_SIZE = 8;
    protected RowsetCollection m_coll = null;
    protected Object[] m_data = null;

    public RowsetRecord(RowIterator iter, RowsetCollection coll) throws TransformException {
        this.m_coll = coll;
        if (iter != null && iter.nextRow()) {
            String[] cols = this.m_coll.m_cols;
            String[] colKeys = this.m_coll.getColumns();
            if (cols != null) {
                String key = null;
                for (int c = 0; c < cols.length; ++c) {
                    if (cols[c] == null) continue;
                    key = this.m_coll.getMappedKey(colKeys[c]);
                    if (this.m_coll.isDataItem(cols[c])) {
                        DataCellInterface dci = iter.getCell(cols[c]);
                        if (dci instanceof RowsetCollectionSetter) {
                            ((RowsetCollectionSetter)((Object)dci)).setRowsetCollection(this.m_coll);
                        }
                        this.put(key, dci != null ? dci.getData("dataValue") : null);
                        continue;
                    }
                    MemberInterface mi = iter.getMember(cols[c]);
                    if (mi instanceof RowsetCollectionSetter) {
                        ((RowsetCollectionSetter)((Object)mi)).setRowsetCollection(this.m_coll);
                    }
                    this.put(key, mi != null ? mi.getMetadata("value") : null);
                    String attrName = this.m_coll.getInterfaceAttrName(key, LayerInterface.class.getName());
                    if (attrName != null) {
                        this.put(attrName, (Object)this.m_coll.getLayer(cols[c]));
                    }
                    if ((attrName = this.m_coll.getInterfaceAttrName(key, MemberInterface.class.getName())) == null) continue;
                    this.put(attrName, (Object)mi);
                }
            }
        }
        if (this.m_coll != null) {
            this.m_coll.add(this);
        }
    }

    @Override
    public int size() {
        int size = this._arrSize();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (this.m_data[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object remove(Object key) {
        Object retVal = null;
        if (this.m_coll == null) {
            return retVal;
        }
        int pos = this.m_coll.getKeyPosition(key);
        if (pos > -1 && pos < this._arrSize()) {
            retVal = this.m_data[pos];
            this.m_data[pos] = null;
        }
        return retVal;
    }

    @Override
    public Collection values() {
        int size = this._arrSize();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            if (this.m_data[i] == null) continue;
            list.add(this.m_data[i]);
        }
        return list;
    }

    @Override
    public Set<String> keySet() {
        return this.m_coll != null ? this.m_coll.getKeys() : null;
    }

    @Override
    public Set entrySet() {
        HashSet<AbstractMap.SimpleEntry<Object, Object>> entries = new HashSet<AbstractMap.SimpleEntry<Object, Object>>();
        if (this.m_coll == null) {
            return null;
        }
        int keyCount = this.m_coll.getKeyCount();
        for (int i = 0; i < keyCount; ++i) {
            if (i >= this._arrSize() || this.m_data[i] == null) continue;
            entries.add(new AbstractMap.SimpleEntry<Object, Object>(this.m_coll.getKey(i), (this.m_data[i] instanceof TransformUtils.NullMarker ? null : this.m_data[i])));
        }
        return entries;
    }

    @Override
    public void putAll(Map m) {
        if (m == null) {
            return;
        }
        Set keys = m.keySet();
        for (String key : keys) {
            Object val = m.get(key);
            this.put(key, val);
        }
    }

    @Override
    public Object put(String key, Object value) {
        if (this.m_coll == null) {
            return null;
        }
        Object retVal = null;
        int pos = this.m_coll.addKey(key);
        if (pos >= this._arrSize()) {
            Object[] newArr = new Object[pos + 1];
            if (this.m_data != null) {
                System.arraycopy(this.m_data, 0, newArr, 0, this.m_data.length);
                this.m_data = newArr;
            } else {
                this.m_data = new Object[8];
            }
        }
        this.m_data[pos] = value != null ? value : TransformUtils.m_nullMarker;
        return retVal;
    }

    @Override
    public Object get(Object key) {
        if (this.m_coll == null) {
            return null;
        }
        int pos = this.m_coll.getKeyPosition(key);
        if (pos > -1 && pos < this._arrSize()) {
            return this.m_data[pos] == TransformUtils.m_nullMarker ? null : this.m_data[pos];
        }
        return null;
    }

    @Override
    public boolean containsKey(Object k) {
        if (this.m_coll == null) {
            return false;
        }
        int pos = this.m_coll.getKeyPosition(k);
        return pos > -1 && pos < this._arrSize();
    }

    @Override
    public boolean containsValue(Object o) {
        int size = this._arrSize();
        for (int i = 0; i < size; ++i) {
            if ((o != null || this.m_data[i] != TransformUtils.m_nullMarker) && (o == null || !o.equals(this.m_data[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int _arrSize() {
        return this.m_data == null ? 0 : this.m_data.length;
    }

    @Override
    public void clear() {
        this.m_data = null;
        this.m_coll = null;
    }

    public RowsetCollection getCollection() {
        return this.m_coll;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Collection vals = this.values();
        for (Object val : vals) {
            hash += val != null ? val.hashCode() : 0;
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RowsetRecord)) {
            return false;
        }
        return Utility.compareArrays(this.m_data, ((RowsetRecord)obj).m_data);
    }
}

