/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.adf.model.dvt.util.transform.EdgeTreeNode;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.TreeNode;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeChildren;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.GetSlice;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.total.TotalMember;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.Utility;
import oracle.javatools.annotations.Concealed;

@Concealed
class EdgeTreeNodeImpl
implements Cloneable,
EdgeTreeNode {
    private MemberInterface m_value = null;
    private EdgeTreeChildren m_children = new EdgeTreeChildren();
    private EdgeTreeChildren m_collapseChildren = null;
    private long m_span = -1L;
    private long m_start = -1L;
    private EdgeTreeImpl m_tree = null;
    private EdgeTreeNodeImpl m_parent = null;
    private long m_myPos = -1L;
    private String m_layerName = null;
    @Concealed
    private boolean m_isAsym = true;
    private boolean m_isAsymChecked = false;
    private boolean m_isCollapsed = false;
    private MemberInterface.AggregatePosition m_aggregatePosition = MemberInterface.AggregatePosition.NONE;
    private boolean m_aggregateNodeType = false;
    private EdgeTreeNodeImpl m_myAllSibling = null;
    private boolean m_isAggregateSibling = false;

    protected EdgeTreeNodeImpl(EdgeTreeImpl tree) {
        this.m_tree = tree;
    }

    protected EdgeTreeNodeImpl(EdgeTreeImpl tree, boolean aggregateNodeType, EdgeTreeNodeImpl parent, MemberInterface value, String layerName) throws TransformException {
        this(tree);
        this.m_aggregateNodeType = aggregateNodeType;
        this.m_parent = parent;
        try {
            this.setValue(value);
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
        this.m_layerName = layerName;
        this.setIsOutline();
    }

    public Object clone(EdgeTreeImpl tree, EdgeTreeNodeImpl parent, boolean caching) throws CloneNotSupportedException {
        EdgeTreeNodeImpl node = (EdgeTreeNodeImpl)super.clone();
        node.m_children = (EdgeTreeChildren)this.m_children.clone(tree, node, caching);
        if (this.m_collapseChildren != null) {
            node.m_collapseChildren = (EdgeTreeChildren)this.m_collapseChildren.clone(tree, node, caching);
        }
        node.m_tree = tree;
        node.m_parent = parent;
        if (this.m_myAllSibling != null) {
            node.m_myAllSibling = (EdgeTreeNodeImpl)this.m_myAllSibling.clone(tree, parent, caching);
        }
        if (caching) {
            try {
                node.m_value = new MemberInterfaceCache(this.m_value);
            }
            catch (TransformException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }
        return node;
    }

    protected void setSpan(long span) {
        this.m_span = span;
    }

    public int hashCode() {
        int hashCode = this.m_value != null ? this.m_value.hashCode() : 0;
        return hashCode + (this.m_isAggregateSibling ? 1 : 0);
    }

    protected void release() {
        this.m_value = null;
        if (this.m_children != null) {
            this.m_children.release();
        }
        this.m_children = null;
        if (this.m_collapseChildren != null) {
            this.m_collapseChildren.release();
        }
        this.m_tree = null;
        this.m_parent = null;
        this.m_myAllSibling = null;
    }

    private void setIsOutline() throws TransformException {
        if (!this.m_tree.isOutline() && this.m_aggregateNodeType && this.m_value != null) {
            Object obj = this.m_value.getMetadata("isTotal");
            if (obj instanceof Boolean) {
                if (!((Boolean)obj).booleanValue()) {
                    this.m_tree.setOutline(true);
                }
            } else {
                this.m_tree.setOutline(true);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EdgeTreeNodeImpl) {
            EdgeTreeNodeImpl etn = (EdgeTreeNodeImpl)obj;
            if (this.m_value == null && etn.getMember() == null) {
                return true;
            }
            if (this.m_value == null) {
                return false;
            }
            if (etn.getMember() == null) {
                return false;
            }
            try {
                if (Utility.compareObj(this.m_value.getValue(), etn.getMember().getValue())) {
                    return this.isAggregateNodeType() == etn.isAggregateNodeType();
                }
            }
            catch (TransformException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    private List<EdgeTreeNodeImpl> _getDescendants(List<EdgeTreeNodeImpl> descendants) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        if (children != null) {
            descendants.addAll(children);
            for (EdgeTreeNodeImpl node : children) {
                descendants.addAll(node._getDescendants(descendants));
            }
        }
        return descendants;
    }

    @Concealed
    private boolean _areSiblingsDescendantsUnequal() throws TransformException {
        int childCount;
        EdgeTreeChildren myChildren = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        int n = childCount = myChildren != null ? myChildren.size() : 0;
        if (childCount > 1) {
            EdgeTreeNodeImpl firstChild = this.getFirstChild();
            List<EdgeTreeNodeImpl> firstChildDescendants = firstChild._getDescendants(new ArrayList<EdgeTreeNodeImpl>());
            List<EdgeTreeNodeImpl> currentDescendants = null;
            for (int c = 1; c < childCount; ++c) {
                currentDescendants = ((EdgeTreeNodeImpl)myChildren.get(c))._getDescendants(new ArrayList<EdgeTreeNodeImpl>());
                if (Utility.compareLists(firstChildDescendants, currentDescendants)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAsymmetric() throws TransformException {
        if (this.m_isAsymChecked) {
            return this.m_isAsym;
        }
        this.m_isAsym = this._areSiblingsDescendantsUnequal();
        this.m_isAsymChecked = true;
        return this.m_isAsym;
    }

    protected void setAllSibling(EdgeTreeNodeImpl sibling) {
        this.m_myAllSibling = sibling;
        sibling.setIsAggregateSibling(true);
    }

    private void setIsAggregateSibling(boolean isSibling) {
        this.m_isAggregateSibling = isSibling;
    }

    private boolean isCollapsed() throws TransformException {
        this.m_isCollapsed = this.m_value == null ? false : this.getIsCollapsed(this.m_value);
        return this.m_isCollapsed;
    }

    protected MemberInterface.AggregatePosition getAggregatePosition() throws TransformException {
        Object obj;
        this.m_aggregatePosition = this.m_value == null ? MemberInterface.AggregatePosition.NONE : ((obj = this.m_value.getMetadata("memberMetadataAggPosition")) instanceof MemberInterface.AggregatePosition ? (MemberInterface.AggregatePosition)((Object)obj) : MemberInterface.AggregatePosition.NONE);
        return this.m_aggregatePosition;
    }

    @Override
    public String getLayerName() {
        return this.m_layerName;
    }

    protected EdgeTreeImpl getEdgeTree() {
        return this.m_tree;
    }

    protected int getEdge() {
        return this.m_tree.getEdge();
    }

    private EdgeTreeChildren getSearchableChildren(GetSlice get, long goToSlice) throws TransformException {
        if (this.isCollapsed()) {
            if (this.m_tree.isNoCollapseLeaves()) {
                return this.getCollapseChildren();
            }
            return new EdgeTreeChildren();
        }
        return this.getChildren(get, goToSlice);
    }

    private EdgeTreeChildren getCollapseChildren() throws TransformException {
        if (this.m_collapseChildren == null) {
            this.m_collapseChildren = this._gatherChildren(this, new EdgeTreeChildren());
        }
        return this.m_collapseChildren;
    }

    private EdgeTreeChildren _gatherChildren(EdgeTreeNodeImpl node, EdgeTreeChildren currentChildren) throws TransformException {
        if (node == null) {
            return currentChildren;
        }
        if (node.isModifiableLeaf() && currentChildren.findChild(node) == null) {
            currentChildren.add(node);
        }
        currentChildren = this._gatherChildren(node.getModifiableFirstChild(), currentChildren);
        currentChildren = this._gatherChildren(node.getModifiableNextSibling(), currentChildren);
        return currentChildren;
    }

    protected EdgeTreeChildren getModifiableChildren() throws TransformException {
        return this.m_children;
    }

    private EdgeTreeChildren getChildren(GetSlice get, long goToSlice) throws TransformException {
        EdgeTreeBasedCubicDataAccess da = null;
        switch (get) {
            case GET_NO_SLICES: {
                return this.m_children;
            }
            case GET_ALL_SLICES: {
                da = this.m_tree.getDataAccess();
                if (da == null) break;
                da.updateTree(this.getEdge(), -1L, this);
                break;
            }
            case GET_TO_SLICE: {
                da = this.m_tree.getDataAccess();
                if (da == null) break;
                da.updateTree(this.getEdge(), goToSlice, this);
            }
        }
        return this.m_children;
    }

    private void setValue(MemberInterface value) throws CloneNotSupportedException {
        this.m_value = value;
        if (this.m_value != null) {
            this.m_value.setEdgeTreeNode(this);
        }
    }

    protected QDRInterface getQDR() throws TransformException {
        QDR qdr = new QDR();
        for (EdgeTreeNodeImpl currNode = this; currNode != null; currNode = (EdgeTreeNodeImpl)currNode.getParent()) {
            if (currNode.getLayerName() == null || currNode.getMember() == null) continue;
            qdr.addDimMemberPair(currNode.getLayerName(), currNode.getMember().getValue());
        }
        return qdr;
    }

    protected boolean delete() throws TransformException {
        if (this.isRoot()) {
            return false;
        }
        EdgeTreeNodeImpl parent = this.getParentInternal();
        if (parent != null) {
            parent.deleteChild(this);
        }
        this.clearSpan();
        this.clearStarts();
        if (parent != null) {
            parent.clearStarts();
        }
        return true;
    }

    private void deleteChild(EdgeTreeNodeImpl node) throws TransformException {
        this.getModifiableChildren().deleteChild(node);
    }

    private void deleteSibling() throws TransformException {
        this.m_parent.deleteChild(this.m_myAllSibling);
    }

    private void insertSibling(TreeNode node) throws TransformException {
        EdgeTreeChildren parentChildren = this.m_parent.getModifiableChildren();
        parentChildren.addAggregateSibling(this, node, parentChildren.indexOf(this));
    }

    public void clearStarts() throws TransformException {
        for (EdgeTreeNodeImpl parent = this.getParentInternal(); parent != null; parent = parent.getParentInternal()) {
            EdgeTreeChildren parentChildren = parent.getModifiableChildren();
            int start = parentChildren.indexOf(this);
            long childCount = parent.getChildCount();
            EdgeTreeNodeImpl node = null;
            int i = start + 1;
            while ((long)i < childCount) {
                node = parentChildren.getChild(i);
                node.clearStart();
                ++i;
            }
            parent.clearStarts();
        }
    }

    public void clearStart() throws TransformException {
        this.m_start = -1L;
        this.m_collapseChildren = null;
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        children.clearStart();
    }

    public void clearSpan() {
        this.m_span = -1L;
        this.m_collapseChildren = null;
        if (this.getParent() != null) {
            this.getParentInternal().clearSpan();
        }
    }

    public void invalidate() throws TransformException {
        this.deleteCachedInfo();
        EdgeTreeChildren children = this.getModifiableChildren();
        if (!this.m_isAggregateSibling) {
            if (this.m_isCollapsed != this.getIsCollapsed(this.m_value)) {
                if (this.m_isCollapsed) {
                    this.insertSibling(null);
                } else {
                    this.deleteSibling();
                }
            } else if (!this.getIsCollapsed(this.m_value) && this.m_value.getMetadata("memberMetadataAggPosition") != this.m_aggregatePosition) {
                this.deleteSibling();
                this.insertSibling(null);
            }
        }
        if (children != null) {
            children.invalidate();
        }
    }

    protected void deleteCachedInfo() {
        this.m_span = -1L;
        this.m_start = -1L;
        this.m_myPos = -1L;
        this.m_isAsymChecked = false;
        this.m_isAsym = true;
        this.m_collapseChildren = null;
    }

    public void unlock() throws TransformException {
        this.deleteCachedInfo();
        EdgeTreeChildren children = this.getModifiableChildren();
        if (children == null) {
            return;
        }
        children.unlock();
    }

    @Override
    public MemberInterface getMember() {
        return this.m_value;
    }

    @Override
    public boolean isRoot() {
        return this.m_parent == null;
    }

    @Override
    public EdgeTreeNode getParent() {
        return this.m_parent;
    }

    protected EdgeTreeNodeImpl getParentInternal() {
        return this.m_parent;
    }

    public long getPosition() throws TransformException {
        if (this.m_myPos == -1L && this.m_parent != null) {
            long pos;
            EdgeTreeChildren children = this.m_parent.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
            long l = pos = children != null ? (long)children.indexOf(this) : -1L;
            if (this.m_tree.isLocked()) {
                this.m_myPos = pos;
            }
            return pos;
        }
        return this.m_myPos;
    }

    public long getChildCount() throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        return children != null ? (long)children.size() : 0L;
    }

    public boolean isLeaf() throws TransformException {
        return this.getChildCount() == 0L;
    }

    private long getModifiableChildCount() throws TransformException {
        EdgeTreeChildren children = this.getModifiableChildren();
        return children != null ? (long)children.size() : 0L;
    }

    private boolean isModifiableLeaf() throws TransformException {
        return this.getModifiableChildCount() == 0L;
    }

    private EdgeTreeNodeImpl getModifiableNextSibling() throws TransformException {
        if (this.getParent() == null) {
            return null;
        }
        EdgeTreeChildren siblings = this.getParentInternal().getModifiableChildren();
        long pos = siblings.indexOf(this);
        if (pos + 1L < (long)siblings.size()) {
            return siblings.getChild(pos + 1L);
        }
        return null;
    }

    private EdgeTreeNodeImpl getModifiableFirstChild() throws TransformException {
        EdgeTreeChildren children = this.getModifiableChildren();
        if (children != null) {
            return children.getChild(0L);
        }
        return null;
    }

    @Override
    public EdgeTreeNode getFirstChild(boolean nonAggregate) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        if (children != null) {
            return children.findFirstChild(nonAggregate);
        }
        return null;
    }

    @Override
    public EdgeTreeNode getLastChild(boolean nonAggregate) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        if (children != null) {
            return children.findLastChild(nonAggregate);
        }
        return null;
    }

    public EdgeTreeNodeImpl getFirstChild() throws TransformException {
        return this.getChild(0L);
    }

    public EdgeTreeNodeImpl getLastChild() throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        if (children != null) {
            return children.getLastChild();
        }
        return null;
    }

    @Override
    public List<EdgeTreeNode> getChildren() {
        ArrayList<EdgeTreeNode> retList = new ArrayList<EdgeTreeNode>();
        if (this.m_children != null) {
            retList.addAll(this.m_children);
        }
        return retList;
    }

    protected List<EdgeTreeNodeImpl> getAllLeaves(List<EdgeTreeNodeImpl> leaves) throws TransformException {
        if (this.isLeaf()) {
            if (leaves == null) {
                leaves = new ArrayList<EdgeTreeNodeImpl>();
            }
            leaves.add(this);
        } else {
            List<EdgeTreeNode> children = this.getChildren();
            if (children != null) {
                for (EdgeTreeNode child : children) {
                    leaves = ((EdgeTreeNodeImpl)child).getAllLeaves(leaves);
                }
            }
        }
        return leaves;
    }

    public EdgeTreeNodeImpl getLastLeaf() throws TransformException {
        EdgeTreeNodeImpl currNode;
        for (currNode = this; currNode != null && !currNode.isLeaf(); currNode = currNode.getLastChild()) {
        }
        return currNode;
    }

    public EdgeTreeNodeImpl getFirstLeaf() throws TransformException {
        EdgeTreeNodeImpl currNode;
        for (currNode = this; currNode != null && !currNode.isLeaf(); currNode = currNode.getFirstChild()) {
        }
        return currNode;
    }

    public boolean isAggregateNodeType() {
        return this.m_aggregateNodeType;
    }

    public long[] getHPos() throws TransformException {
        ArrayList<Long> indicies = new ArrayList<Long>();
        for (EdgeTreeNodeImpl node = this; node != null && !node.isRoot(); node = node.getParentInternal()) {
            indicies.add(new Long(node.getPosition()));
        }
        long[] hPos = new long[indicies.size()];
        int counter = hPos.length - 1;
        for (int i = 0; i < hPos.length; ++i) {
            hPos[i] = (Long)indicies.get(counter);
            --counter;
        }
        return hPos;
    }

    protected long getStart(EdgeTreeNodeImpl node, GetSlice get, long goToSlice) throws TransformException {
        EdgeTreeChildren childlist = this.getSearchableChildren(get, goToSlice);
        Iterator children = childlist.iterator();
        EdgeTreeNodeImpl currNode = null;
        long spanSum = 0L;
        while (children.hasNext()) {
            currNode = (EdgeTreeNodeImpl)children.next();
            if (currNode == node) {
                return this.getStart(get, goToSlice) + spanSum;
            }
            spanSum += currNode.getSpan();
        }
        return this.getStart(get, goToSlice);
    }

    public long getStart(GetSlice get, long goToSlice) throws TransformException {
        if (this.m_start == -1L) {
            long start = this.m_parent == null ? 0L : this.m_parent.getStart(this, get, goToSlice);
            if (this.m_tree.isLocked()) {
                this.m_start = start;
            } else {
                return start;
            }
        }
        return this.m_start;
    }

    public long getSpan() throws TransformException {
        if (this.m_span == -1L) {
            EdgeTreeChildren childlist = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
            Iterator children = childlist.iterator();
            EdgeTreeNodeImpl currNode = null;
            long span = 0L;
            while (children.hasNext()) {
                currNode = (EdgeTreeNodeImpl)children.next();
                span += currNode.getSpan();
            }
            if (span == 0L && !this.isRoot()) {
                span = 1L;
            }
            if (this.m_tree.isLocked()) {
                this.m_span = span;
            } else {
                return span;
            }
        }
        return this.m_span;
    }

    protected EdgeTreeNodeImpl findChild(long slice, GetSlice get) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(get, slice);
        if (children == null) {
            return null;
        }
        return children.findChild(slice, get);
    }

    protected EdgeTreeNodeImpl addChild(EdgeTreeNodeImpl childNode, TreeNode node, String insertLocation, boolean above, boolean alwaysAdd, boolean replace, boolean placeTotals, LayerSortInfo sortInfo) throws TransformException {
        EdgeTreeChildren children = this.getModifiableChildren();
        return children.addChild(childNode, node, insertLocation, above, alwaysAdd, replace, placeTotals, sortInfo);
    }

    protected boolean needAggregateSibling() throws TransformException {
        return !this.isCollapsed() && this.getAggregatePosition() != MemberInterface.AggregatePosition.NONE;
    }

    protected boolean isTotalNode() {
        MemberInterface val = this.getMember();
        return val != null && val instanceof TotalMember;
    }

    protected EdgeTreeNodeImpl getChild(long pos) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_TO_SLICE, pos);
        if (children != null) {
            return children.getChild(pos);
        }
        return null;
    }

    protected EdgeTreeNodeImpl findNonAggregateChild(String value) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        return children.findChild(value, true, false);
    }

    protected EdgeTreeNodeImpl[] findAllChildren(String value, boolean treatNullAsAll) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        return children.findAllChildren(value, false, treatNullAsAll);
    }

    protected EdgeTreeNodeImpl findChild(String value) throws TransformException {
        EdgeTreeChildren children = this.getSearchableChildren(GetSlice.GET_ALL_SLICES, -1L);
        return children.findChild(value, false, false);
    }

    private boolean getIsCollapsed(MemberInterface mi) throws TransformException {
        Object obj = mi.getMetadata("memberMetadataIsCollapsed");
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    private class MemberInterfaceCache
    implements MemberInterface {
        private final boolean m_miIsNull;
        private final String m_miValue;
        private final boolean m_miIsCollapsed;
        private EdgeTreeNode m_miNode = null;
        private final MemberInterface.AggregatePosition m_miAggPosition;
        private final int m_miHashCode;

        public MemberInterfaceCache(MemberInterface mi) throws TransformException {
            this.m_miIsNull = mi == null;
            this.m_miValue = mi != null ? mi.getValue() : null;
            this.m_miIsCollapsed = mi != null ? EdgeTreeNodeImpl.this.getIsCollapsed(mi) : false;
            this.m_miAggPosition = mi != null ? (MemberInterface.AggregatePosition)((Object)mi.getMetadata("memberMetadataAggPosition")) : null;
            this.m_miHashCode = mi != null ? mi.hashCode() : 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return this.m_miIsNull;
            }
            try {
                if (obj instanceof MemberInterface) {
                    MemberInterface mi = (MemberInterface)obj;
                    return this.m_miValue.equals(mi.getValue()) && this.m_miIsCollapsed == EdgeTreeNodeImpl.this.getIsCollapsed(mi) && this.m_miAggPosition.equals(mi.getMetadata("memberMetadataAggPosition"));
                }
                return false;
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public String getValue() throws TransformException {
            return this.m_miValue;
        }

        @Override
        public Object getMetadata(String type) throws TransformException {
            if (type.equals("value")) {
                return this.getValue();
            }
            if (type.equals("memberMetadataIsCollapsed")) {
                return this.isCollapsed();
            }
            if (type.equals("memberMetadataAggPosition")) {
                return this.getAggregatePosition();
            }
            return null;
        }

        @Override
        public int hashCode() {
            return this.m_miHashCode;
        }

        @Override
        public void setEdgeTreeNode(EdgeTreeNode node) {
            this.m_miNode = node;
        }

        @Override
        public EdgeTreeNode getEdgeTreeNode() {
            return this.m_miNode;
        }

        private boolean isCollapsed() {
            return this.m_miIsCollapsed;
        }

        private MemberInterface.AggregatePosition getAggregatePosition() {
            return this.m_miAggPosition;
        }
    }
}

