/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RowHeaderSelectionModel
extends DefaultListSelectionModel {
    private JTable table;
    private TableL tableL = new TableL();
    private boolean tableSelChanging;
    private boolean shrinkSelection = false;

    public RowHeaderSelectionModel() {
    }

    public RowHeaderSelectionModel(JTable table) {
        this.setTable(table);
    }

    public void setTable(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.tableL);
            this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.tableL);
            table.removePropertyChangeListener("rowSelectionAllowed", this.tableL);
            table.removePropertyChangeListener("columnSelectionAllowed", this.tableL);
        }
        this.table = table;
        this.table.getSelectionModel().addListSelectionListener(this.tableL);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.tableL);
        this.table.addPropertyChangeListener("rowSelectionAllowed", this.tableL);
        this.table.addPropertyChangeListener("columnSelectionAllowed", this.tableL);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.table.getRowSelectionAllowed()) {
            if (index0 == index1 && this.isSelectedIndex(index0)) {
                return;
            }
            this._setTableSelectionIsChanging(true);
            this.table.getSelectionModel().setSelectionInterval(index0, index1);
            this._setTableSelectionIsChanging(false);
            super.setSelectionInterval(index0, index1);
            if (this.table.getColumnSelectionAllowed()) {
                this._setTableSelectionIsChanging(true);
                this.table.setColumnSelectionInterval(0, this._boundTableColumn(this.table.getColumnCount() - 1));
                this._setTableSelectionIsChanging(false);
            }
        }
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (this.table.getRowSelectionAllowed()) {
            this._setTableSelectionIsChanging(true);
            this.table.getSelectionModel().addSelectionInterval(index0, index1);
            this._setTableSelectionIsChanging(false);
            super.addSelectionInterval(index0, index1);
            if (this.table.getColumnSelectionAllowed()) {
                this._setTableSelectionIsChanging(true);
                this.table.setColumnSelectionInterval(0, this._boundTableColumn(this.table.getColumnCount() - 1));
                this._setTableSelectionIsChanging(false);
            }
        }
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (this.table.getRowSelectionAllowed()) {
            this._setTableSelectionIsChanging(true);
            this.table.getSelectionModel().removeSelectionInterval(index0, index1);
            this._setTableSelectionIsChanging(false);
            super.removeSelectionInterval(index0, index1);
        }
    }

    @Override
    public void setAnchorSelectionIndex(int anchorIndex) {
        if (this.table.getRowSelectionAllowed()) {
            this._setTableSelectionIsChanging(true);
            this.table.getSelectionModel().setAnchorSelectionIndex(anchorIndex);
            this._setTableSelectionIsChanging(false);
            super.setAnchorSelectionIndex(anchorIndex);
        }
    }

    @Override
    public void setLeadSelectionIndex(int leadIndex) {
        if (this.table.getRowSelectionAllowed()) {
            this._setTableSelectionIsChanging(true);
            this.table.getSelectionModel().setLeadSelectionIndex(leadIndex);
            this._setTableSelectionIsChanging(false);
            super.setLeadSelectionIndex(leadIndex);
        }
    }

    @Override
    public void clearSelection() {
        if (this.table.getRowSelectionAllowed()) {
            this._setTableSelectionIsChanging(true);
            this.table.getSelectionModel().clearSelection();
            this._setTableSelectionIsChanging(false);
            super.clearSelection();
        }
    }

    @Override
    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    @Override
    public void moveLeadSelectionIndex(int leadIndex) {
        if (this.table.getRowSelectionAllowed()) {
            super.moveLeadSelectionIndex(leadIndex);
        }
    }

    private void _updateSelection() {
        if (!this._isTableSelectionIsChanging()) {
            super.clearSelection();
            if (this.table.getRowSelectionAllowed() && !this.table.getCellSelectionEnabled()) {
                int[] rows;
                for (int index : rows = this.table.getSelectedRows()) {
                    super.addSelectionInterval(index, index);
                }
            }
        }
    }

    private int _boundTableColumn(int index) {
        return Math.max(0, index);
    }

    private void _setTableSelectionIsChanging(boolean b) {
        this.tableSelChanging = b;
    }

    private boolean _isTableSelectionIsChanging() {
        return this.tableSelChanging;
    }

    public final void setShrinkSelection(boolean shrinkSelection) {
        this.shrinkSelection = shrinkSelection;
    }

    public final boolean isShrinkSelection() {
        return this.shrinkSelection;
    }

    private class TableL
    implements ListSelectionListener,
    PropertyChangeListener {
        private TableL() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            RowHeaderSelectionModel.this._updateSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            if ("rowSelectionAllowed".equals(pe.getPropertyName()) || "columnSelectionAllowed".equals(pe.getPropertyName())) {
                RowHeaderSelectionModel.this._updateSelection();
            }
        }
    }
}

