/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.javatools.ui.table.BasicRowHeaderModel;
import oracle.javatools.ui.table.DefaultRowHeaderRenderer;
import oracle.javatools.ui.table.RolloverListener;
import oracle.javatools.ui.table.RolloverRowHeaderListener;
import oracle.javatools.ui.table.RolloverRowHeaderRenderer;
import oracle.javatools.ui.table.RowHeaderSelectionModel;

public class RowHeader
extends JList {
    private JTable _table;
    private TableListener _listener;
    private RolloverListener rolloverListener;
    private boolean _highlight;

    public RowHeader(JTable table) {
        super(new BasicRowHeaderModel(table.getModel()));
        BasicRowHeaderModel model = (BasicRowHeaderModel)this.getModel();
        this._table = table;
        this._table.putClientProperty("tableRowHeader", this);
        this.setSelectionModel(this.createSelectionModel());
        this.setCellRenderer(new DefaultRowHeaderRenderer());
        this._listener = new TableListener();
        table.addPropertyChangeListener("model", this._listener);
        table.addPropertyChangeListener("selectionModel", this._listener);
        table.addPropertyChangeListener("sorter", this._listener);
        table.getModel().addTableModelListener(this._listener);
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        if (sorter != null) {
            sorter.addRowSorterListener(this._listener);
            model.setSorter(sorter);
        }
        this.setBackground(Color.white);
    }

    public JTable getTable() {
        return this._table;
    }

    public void setShowRowNumber(boolean show) {
        ListModel model = this.getModel();
        if (model instanceof BasicRowHeaderModel) {
            ((BasicRowHeaderModel)model).setShowRowNumber(show);
        }
    }

    public boolean isShowRowNumber() {
        ListModel model = this.getModel();
        if (model instanceof BasicRowHeaderModel) {
            return ((BasicRowHeaderModel)model).isShowRowNumber();
        }
        return false;
    }

    public void setRolloverHighlightingEnabled(boolean highlight) {
        if (this._highlight != highlight) {
            if (highlight) {
                if (this.rolloverListener == null) {
                    this.rolloverListener = new RolloverRowHeaderListener(this);
                }
                this.addMouseListener(this.rolloverListener);
                this.addMouseMotionListener(this.rolloverListener);
                this.setCellRenderer(new RolloverRowHeaderRenderer(this.getCellRenderer()));
            } else {
                this.removeMouseListener(this.rolloverListener);
                this.removeMouseMotionListener(this.rolloverListener);
                ListCellRenderer renderer = this.getCellRenderer();
                if (renderer instanceof RolloverRowHeaderRenderer) {
                    this.setCellRenderer(((RolloverRowHeaderRenderer)renderer).getBaseRenderer());
                }
            }
        }
    }

    public boolean isRolloverHighlightingEnabled() {
        return this._highlight;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installProperty(this, "opaque", Boolean.TRUE);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getModel().getSize() == 0) {
            return new Dimension(0, 0);
        }
        return super.getPreferredScrollableViewportSize();
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        super.scrollRectToVisible(aRect);
        Rectangle tableRect = this._table.getVisibleRect();
        if (tableRect.y != aRect.y) {
            tableRect.y = aRect.y;
            this._table.scrollRectToVisible(tableRect);
        }
    }

    protected void modelChanged() {
        ListModel model = this.getModel();
        if (model instanceof BasicRowHeaderModel) {
            ((BasicRowHeaderModel)model).setTableModel(this._table.getModel());
        }
    }

    protected void selectionModelChanged() {
        ListSelectionModel selModel = this.getSelectionModel();
        if (selModel instanceof RowHeaderSelectionModel) {
            ((RowHeaderSelectionModel)selModel).setTable(this._table);
        }
    }

    @Override
    protected ListSelectionModel createSelectionModel() {
        if (this._table != null) {
            RowHeaderSelectionModel selModel = new RowHeaderSelectionModel();
            selModel.setTable(this._table);
            return selModel;
        }
        return super.createSelectionModel();
    }

    @Override
    public void ensureIndexIsVisible(int index) {
    }

    private class TableListener
    implements PropertyChangeListener,
    TableModelListener,
    RowSorterListener {
        private TableListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("model".equals(name)) {
                if (evt.getOldValue() != null && evt.getOldValue() instanceof TableModel) {
                    ((TableModel)evt.getOldValue()).removeTableModelListener(this);
                }
                RowHeader.this.modelChanged();
                if (evt.getNewValue() != null && evt.getNewValue() instanceof TableModel) {
                    ((TableModel)evt.getNewValue()).addTableModelListener(this);
                }
            } else if ("selectionModel".equals(name)) {
                RowHeader.this.selectionModelChanged();
            } else if ("sorter".equals(name)) {
                if (evt.getOldValue() != null && evt.getOldValue() instanceof RowSorter) {
                    ((RowSorter)evt.getOldValue()).removeRowSorterListener(this);
                }
                if (evt.getNewValue() != null && evt.getNewValue() instanceof RowSorter) {
                    RowSorter sorter = (RowSorter)evt.getNewValue();
                    sorter.addRowSorterListener(this);
                    ((BasicRowHeaderModel)RowHeader.this.getModel()).setSorter(sorter);
                }
                RowHeader.this.selectionModelChanged();
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            RowHeader.this.repaint();
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            RowHeader.this.repaint();
        }
    }
}

