/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.olaf2.OracleButtonUI;
import oracle.javatools.ui.themes.Themes;

public final class ThemedButtonUI
extends OracleButtonUI {
    private static final int _CORNER_INSET = 3;
    private static final ThemedButtonUI _INSTANCE = new ThemedButtonUI();

    public static ComponentUI createUI(JComponent component) {
        return _INSTANCE;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (Themes.isThemed()) {
            b.setRolloverEnabled(true);
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                b.setBorder(new ButtonBorder(border.getBorderInsets(b)));
            }
        }
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (Themes.isThemed() && c.isOpaque() && !this.isToolBarButton(b) && b.isContentAreaFilled() && c.getBackground() instanceof UIResource) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            this.paintThemeBackground(g, c);
            this.paint(g, c);
            return;
        }
        super.update(g, c);
    }

    protected void paintThemeBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        int corner = b.getBorder() instanceof ButtonBorder ? 3 : 0;
        Themes.getActiveTheme().getStateProperties("commandbutton.center", this._getState(b)).getPainter("bg").paint(g, corner, 0, b.getWidth() - 2 * corner, b.getHeight());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!Themes.isThemed()) {
            super.paintButtonPressed(g, b);
        } else if (b.isContentAreaFilled()) {
            this.paintThemeBackground(g, b);
        }
    }

    private String _getState(AbstractButton b) {
        String state = "default";
        if (!b.isEnabled()) {
            state = "disabled";
        }
        if (b.getModel().isArmed() && b.getModel().isPressed()) {
            state = "down";
        } else if (b.getModel().isRollover()) {
            state = "over";
        } else if (b.isFocusPainted() && b.hasFocus()) {
            state = "focus";
        } else if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
            state = "defaultbutton";
        } else if (b.getModel().isSelected()) {
            state = "selected";
        }
        return state;
    }

    private class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private Insets _inset;

        public ButtonBorder(Insets inset) {
            this._inset = inset;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!c.isOpaque()) {
                return;
            }
            AbstractButton b = (AbstractButton)c;
            String state = ThemedButtonUI.this._getState(b);
            Themes.getActiveTheme().getStateProperties("commandbutton.edge1", state).getPainter("bg").paint(g, 0, 0, b.getWidth(), b.getHeight());
            Themes.getActiveTheme().getStateProperties("commandbutton.edge2", state).getPainter("bg").paint(g, 0, 0, b.getWidth(), b.getHeight());
            if (!(c.isOpaque() && b.isContentAreaFilled() || "defaultbutton".equals(state))) {
                Themes.getActiveTheme().getStateProperties("commandbutton.edge3", state).getPainter("bg").paint(g, 0, 0, b.getWidth(), b.getHeight());
                Themes.getActiveTheme().getStateProperties("commandbutton.edge4", state).getPainter("bg").paint(g, 0, 0, b.getWidth(), b.getHeight());
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this._inset;
        }
    }
}

