/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.search.SearchProgress;

public class SearchFieldHarness
extends TransparentPanel {
    private final JList _list = new JList();
    private SearchField _searchField;
    private final JPanel _options = new TransparentPanel();
    private final JLabel _style = new JLabel("Style:");
    private final JRadioButton _filter = new JRadioButton("Filter");
    private final JRadioButton _search = new JRadioButton("Search");
    private final JRadioButton _find = new JRadioButton("Find");
    private final JCheckBox _categories = new JCheckBox("Add search categories");
    private final JCheckBox _extraItems = new JCheckBox("Add extra menu items");
    private final JCheckBox _buttonsInField = new JCheckBox("All buttons inside field border");
    private final JLabel _searchSpeedLabel = new JLabel("Simulated search speed:");
    private final JSlider _searchSpeed = new JSlider(0, 100);
    private final JLabel _slow = new JLabel("Slow");
    private final JLabel _fast = new JLabel("Fast");
    private final JCheckBox _determinateProgress = new JCheckBox("Use determinate search progress");
    private final JCheckBox _slowStopResponse = new JCheckBox("Respond to stop search slowly");
    private static final SearchCategory ALL_CATEGORY = new SearchCategory("All");
    private static final SearchCategory CLASS_NAME_CATEGORY = new SearchCategory("Class Name");
    private static final SearchCategory PACKAGE_NAME_CATEGORY = new SearchCategory("Package Name");
    private final int MAX_TIME_TO_SEARCH = 15000;
    private boolean _searching = false;
    private Set<Class> _highlightedClasses = null;

    SearchFieldHarness() {
        this._buttonsInField.setSelected(true);
        HeaderPanel<JPanel> optionsHeader = new HeaderPanel<JPanel>(this._options);
        optionsHeader.getHeader().setLevel(Header.Level.SUB);
        optionsHeader.getHeader().setText("Options");
        optionsHeader.getHeader().setExpanded(true);
        optionsHeader.setComponentIndented(true);
        this._searchSpeed.setPaintLabels(true);
        Hashtable<Integer, JLabel> m = new Hashtable<Integer, JLabel>();
        ((Dictionary)m).put(100, this._slow);
        ((Dictionary)m).put(0, this._fast);
        this._searchSpeed.setLabelTable(m);
        this._list.setCellRenderer(new ClassListRenderer());
        this._list.setSelectionMode(0);
        this.createSearchField(this._buttonsInField.isSelected());
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this._searchField, "North");
        this.add((Component)new JScrollPane(this._list), "Center");
        this.add(optionsHeader, "South");
        this._options.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 5, 5);
        this._options.add((Component)this._style, gbc);
        ++gbc.gridx;
        this._options.add((Component)this._filter, gbc);
        ++gbc.gridx;
        this._options.add((Component)this._search, gbc);
        ++gbc.gridx;
        this._options.add((Component)this._find, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 4;
        this._options.add((Component)this._categories, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._extraItems, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._buttonsInField, gbc);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(5, 0));
        p.add((Component)this._searchSpeedLabel, "West");
        p.add((Component)this._searchSpeed, "Center");
        ++gbc.gridy;
        this._options.add((Component)p, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._determinateProgress, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._slowStopResponse, gbc);
        this.updateSearchOptions();
        this._buttonsInField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchFieldHarness.this.createSearchField(SearchFieldHarness.this._buttonsInField.isSelected());
            }
        });
        this._extraItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchFieldHarness.this._extraItems.isSelected()) {
                    SearchFieldHarness.this._searchField.clearCategoryMenuItems();
                } else {
                    SearchFieldHarness.this._searchField.addCategoryMenuItem(new JMenuItem("Advanced Search..."));
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._filter);
        bg.add(this._search);
        bg.add(this._find);
        this._filter.setSelected(true);
        this._list.setModel(this.buildModel(null, null));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchField.Style newStyle = SearchField.Style.SEARCH;
                if (e.getSource() == SearchFieldHarness.this._filter) {
                    newStyle = SearchField.Style.FILTER;
                } else if (e.getSource() == SearchFieldHarness.this._search) {
                    newStyle = SearchField.Style.SEARCH;
                } else if (e.getSource() == SearchFieldHarness.this._find) {
                    newStyle = SearchField.Style.FIND;
                } else {
                    throw new IllegalStateException("Illegal source for SearchEvent: " + e.getSource());
                }
                SearchFieldHarness.this._searchField.clear();
                SearchFieldHarness.this._searchField.setStyle(newStyle);
                SearchFieldHarness.this._highlightedClasses = null;
                SearchFieldHarness.this.repaint();
                switch (newStyle) {
                    case FILTER: 
                    case FIND: {
                        SearchFieldHarness.this._searchField.setAutoFind(true);
                        SearchFieldHarness.this._list.setModel(SearchFieldHarness.this.buildModel(null, null));
                        break;
                    }
                    case SEARCH: {
                        SearchFieldHarness.this._list.setModel(new AbstractListModel(){

                            @Override
                            public int getSize() {
                                return 0;
                            }

                            @Override
                            public Object getElementAt(int index) {
                                return null;
                            }
                        });
                    }
                }
                SearchFieldHarness.this.updateSearchOptions();
            }
        };
        this._filter.addActionListener(al);
        this._search.addActionListener(al);
        this._find.addActionListener(al);
        this._categories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchFieldHarness.this.updateCategories();
            }
        });
    }

    private void updateSearchOptions() {
        boolean isSearchStyle = !this._searching && this._searchField.getStyle() == SearchField.Style.SEARCH;
        this._slow.setEnabled(isSearchStyle);
        this._fast.setEnabled(isSearchStyle);
        this._searchSpeed.setEnabled(isSearchStyle);
        this._searchSpeedLabel.setEnabled(isSearchStyle);
        this._determinateProgress.setEnabled(isSearchStyle);
        this._slowStopResponse.setEnabled(isSearchStyle);
        this._filter.setEnabled(!this._searching);
        this._find.setEnabled(!this._searching);
        this._search.setEnabled(!this._searching);
        this._categories.setEnabled(!this._searching);
        this._buttonsInField.setEnabled(!this._searching);
        this._extraItems.setEnabled(!this._searching);
    }

    private void updateCategories() {
        this._searchField.clearCategories();
        if (this._categories.isSelected()) {
            this._searchField.addCategory(ALL_CATEGORY);
            this._searchField.addCategory(CLASS_NAME_CATEGORY);
            this._searchField.addCategory(PACKAGE_NAME_CATEGORY);
        }
    }

    private void createSearchField(boolean buttonsInField) {
        SearchField old = null;
        if (this._searchField != null) {
            old = this._searchField;
            this.remove(this._searchField);
        }
        this._searchField = new SearchField();
        this._searchField.clear();
        if (old != null) {
            this._searchField.setStyle(old.getStyle());
            this.updateCategories();
        }
        this._searchField.addSearchListener(new SearchListener(){

            private void filter(SearchCategory category, String search) {
                SearchFieldHarness.this._list.setModel(SearchFieldHarness.this.buildModel(category, search));
            }

            @Override
            public void searchPerformed(SearchEvent se) {
                if (SearchFieldHarness.this._searchField.getStyle() == SearchField.Style.FILTER) {
                    this.filter(se.getSearchCategory(), se.getSearchText());
                } else if (SearchFieldHarness.this._searchField.getStyle() == SearchField.Style.SEARCH) {
                    MutableModel m = new MutableModel();
                    SearchFieldHarness.this._list.setModel(m);
                    SearchFieldHarness.this._searching = true;
                    SearchFieldHarness.this.updateSearchOptions();
                    if (!se.isFromClear()) {
                        SearchRunnable r = new SearchRunnable(se.getSearchProgress(), se.getSearchCategory(), se.getSearchText(), m);
                        Thread t = new Thread((Runnable)r, "Search runnable");
                        t.start();
                    }
                } else if (SearchFieldHarness.this._searchField.getStyle() == SearchField.Style.FIND) {
                    this.find(se, se.getDirection() == SearchEvent.Direction.FORWARD);
                }
            }

            private void find(SearchEvent se, boolean direction) {
                Class clz;
                Class clz2;
                if (se.getSearchText().trim().length() == 0) {
                    SearchFieldHarness.this._highlightedClasses = null;
                    SearchFieldHarness.this._list.repaint();
                    return;
                }
                SearchMatcher helper = SearchMatcher.getSubstringMatcher(se.getSearchText(), true);
                int curIdx = SearchFieldHarness.this._list.getSelectedIndex();
                SearchFieldHarness.this._highlightedClasses = new HashSet();
                for (int i = 0; i < SearchFieldHarness.this._list.getModel().getSize(); ++i) {
                    Class z = (Class)SearchFieldHarness.this._list.getModel().getElementAt(i);
                    if (!SearchFieldHarness.matchesClass(z, se.getSearchCategory(), helper)) continue;
                    SearchFieldHarness.this._highlightedClasses.add(z);
                }
                SearchFieldHarness.this._list.repaint();
                if (SearchFieldHarness.this._highlightedClasses.size() == 0) {
                    SearchFieldHarness.this._searchField.showSearchFailed();
                }
                if (curIdx >= 0 && se.isTriggeredByKeypress() && SearchFieldHarness.matchesClass(clz2 = (Class)SearchFieldHarness.this._list.getModel().getElementAt(curIdx), se.getSearchCategory(), helper)) {
                    return;
                }
                int start = direction ? curIdx + 1 : curIdx - 1;
                int end = direction ? SearchFieldHarness.this._list.getModel().getSize() : -1;
                int modify = direction ? 1 : -1;
                int i = start;
                while (direction ? i < end : i > end) {
                    clz = (Class)SearchFieldHarness.this._list.getModel().getElementAt(i);
                    if (SearchFieldHarness.matchesClass(clz, se.getSearchCategory(), helper)) {
                        SearchFieldHarness.this._list.setSelectedIndex(i);
                        return;
                    }
                    i += modify;
                }
                start = direction ? 0 : SearchFieldHarness.this._list.getModel().getSize() - 1;
                end = curIdx;
                i = start;
                while (direction ? i < end : i > end) {
                    clz = (Class)SearchFieldHarness.this._list.getModel().getElementAt(i);
                    if (SearchFieldHarness.matchesClass(clz, se.getSearchCategory(), helper)) {
                        SearchFieldHarness.this._searchField.showSearchWrapped();
                        SearchFieldHarness.this._list.setSelectedIndex(i);
                        return;
                    }
                    i += modify;
                }
            }

            @Override
            public void searchCategoryChanged(SearchEvent se) {
                if (SearchFieldHarness.this._searchField.getStyle() == SearchField.Style.FILTER) {
                    this.filter(se.getSearchCategory(), se.getSearchText());
                }
            }
        });
        this.add((Component)this._searchField, "North");
        this.validate();
        this.repaint();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel("oracle.bali.ewt.olaf2.OracleLookAndFeel");
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        SearchFieldHarness harness = new SearchFieldHarness();
        f.setContentPane(harness);
        f.setTitle("Search Control Test Harness");
        f.pack();
        f.setVisible(true);
        harness._list.requestFocus();
    }

    private ListModel buildModel(SearchCategory category, String search) {
        final List<Class> classes = this.getAllClasses();
        SearchMatcher helper = SearchMatcher.getSubstringMatcher(search, true);
        if (search != null && search.trim().length() > 0) {
            Iterator<Class> i = classes.iterator();
            while (i.hasNext()) {
                Class clz = i.next();
                if (SearchFieldHarness.matchesClass(clz, category, helper)) continue;
                i.remove();
            }
        }
        return new AbstractListModel(){

            @Override
            public int getSize() {
                return classes.size();
            }

            @Override
            public Object getElementAt(int index) {
                return classes.get(index);
            }
        };
    }

    private List<Class> getAllClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            classes.addAll((Vector)f.get(Thread.currentThread().getContextClassLoader()));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return classes;
    }

    private static boolean matchesClass(Class clz, SearchCategory category, SearchMatcher search) {
        String className = clz.getSimpleName();
        String packageName = clz.getPackage() == null ? null : clz.getPackage().getName();
        String fqName = clz.getName();
        String textToSearch = "";
        if (category == null || category == ALL_CATEGORY) {
            textToSearch = fqName;
        } else if (category == CLASS_NAME_CATEGORY) {
            textToSearch = className;
        } else if (category == PACKAGE_NAME_CATEGORY) {
            textToSearch = packageName;
        }
        return search.matches(textToSearch);
    }

    private static class MutableModel
    extends AbstractListModel {
        private final List _items = new ArrayList();

        private MutableModel() {
        }

        @Override
        public int getSize() {
            return this._items.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._items.get(index);
        }

        public void add(Collection items) {
            int oldCount = this._items.size();
            this._items.addAll(items);
            this.fireIntervalAdded(this, oldCount, this._items.size() - 1);
        }
    }

    private class SearchRunnable
    implements Runnable {
        private final SearchProgress _progress;
        private final SearchCategory _category;
        private final String _search;
        private final MutableModel _model;

        SearchRunnable(SearchProgress progress, SearchCategory category, String search, MutableModel model) {
            this._progress = progress;
            this._category = category;
            this._search = search;
            this._model = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            SearchMatcher helper;
            List allClasses;
            try {
                allClasses = SearchFieldHarness.this.getAllClasses();
                int maxTime = (int)((double)SearchFieldHarness.this._searchSpeed.getValue() / (double)SearchFieldHarness.this._searchSpeed.getMaximum() * 15000.0);
                int msWaitPerClass = (int)((double)maxTime / (double)allClasses.size());
                if (SearchFieldHarness.this._determinateProgress.isSelected()) {
                    this._progress.setDeterminate(allClasses.size());
                }
                helper = SearchMatcher.getSubstringMatcher(this._search, true);
                for (i = 0; i < allClasses.size(); ++i) {
                    try {
                        Thread.sleep(msWaitPerClass);
                    }
                    catch (InterruptedException e) {
                        this._progress.finish();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchFieldHarness.this._searching = false;
                                SearchFieldHarness.this.updateSearchOptions();
                            }
                        });
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                this._progress.finish();
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            {
                block12: {
                    if (!this._progress.isStopped()) break block12;
                    if (SearchFieldHarness.this._slowStopResponse.isSelected()) {
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException e) {
                            this._progress.finish();
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                    }
                    this._progress.finish();
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                Class clz = (Class)allClasses.get(i);
                if (SearchFieldHarness.matchesClass(clz, this._category, helper)) {
                    this.addClass(clz);
                }
                if (!SearchFieldHarness.this._determinateProgress.isSelected()) continue;
                this._progress.setProgress(i + 1);
                continue;
            }
            this._progress.finish();
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        private void addClass(final Class clz) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchRunnable.this._model.add(Collections.singleton(clz));
                }
            });
        }
    }

    private class ClassListRenderer
    extends DefaultListCellRenderer {
        private ClassListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Class z = (Class)value;
            String label = "";
            int lastPeriod = z.getName().lastIndexOf(46);
            label = lastPeriod <= 0 ? z.getName() : z.getName().substring(lastPeriod + 1) + " (" + z.getName().substring(0, lastPeriod) + ")";
            this.setText(label);
            this.setIcon(OracleIcons.getIcon((String)"class.png"));
            if (!isSelected && SearchFieldHarness.this._highlightedClasses != null && SearchFieldHarness.this._highlightedClasses.contains(z)) {
                this.setBackground(new Color(255, 255, 0));
            }
            return c;
        }
    }
}

