/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.text.DefaultCaret;
import oracle.javatools.ui.ColorUtils2;
import oracle.javatools.ui.infotip.InfoTipStyles;

public final class TemplateUtils {
    private TemplateUtils() {
    }

    public static JTextArea createDescriptionArea(InfoTipStyles infoTipStyle) {
        JTextArea textArea = new JTextArea(){

            @Override
            public void setText(String t) {
                super.setText(t);
                this.setCaretPosition(0);
            }
        };
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBorder(BorderFactory.createEmptyBorder());
        textArea.setSelectionColor(ColorUtils2.TRANSPARENT);
        textArea.setSelectedTextColor(textArea.getForeground());
        textArea.setCaret(new DefaultCaret(){

            @Override
            public void paint(Graphics g) {
            }
        });
        textArea.setCursor(Cursor.getDefaultCursor());
        textArea.setForeground(infoTipStyle.getContentTextColor());
        return textArea;
    }

    public static JScrollPane createHorizontalScrollPane() {
        JScrollPane sp = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (this.getHorizontalScrollBar().isVisible()) {
                    d.height = (int)((double)d.height + this.getHorizontalScrollBar().getPreferredSize().getHeight());
                }
                return d;
            }
        };
        sp.setBorder(new EmptyBorder());
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        sp.setVerticalScrollBarPolicy(21);
        sp.setOpaque(true);
        return sp;
    }

    public static JScrollPane createScrollPane() {
        JScrollPane sp = new JScrollPane();
        sp.setBorder(new EmptyBorder());
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        return sp;
    }

    private static class EmptyBorder
    extends MetalBorders.ScrollPaneBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        private EmptyBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

