/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist.xml;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.ui.checklist.DefaultChecklistModel;
import oracle.javatools.ui.checklist.Step;

public class XMLChecklistModel
extends DefaultChecklistModel {
    private HashMap<String, Step> _idMap = new HashMap();
    private HashMap<Step, Map<String, Step>> _parentMap = new HashMap();

    public Step getStep(String id) {
        return this._idMap.get(id);
    }

    public Step getSubstep(Step parentStep, String id) {
        Map<String, Step> subIdMap = this._parentMap.get(parentStep);
        if (subIdMap != null) {
            return subIdMap.get(id);
        }
        return null;
    }

    public void addStep(String id, Step step) {
        super.addStep(step);
        this._idMap.put(id, step);
    }

    public void addStep(String id, Step step, int index) {
        super.addStep(step, index);
        this._idMap.put(id, step);
    }

    public void removeStep(String id) {
        Step step = this._idMap.get(id);
        if (step != null) {
            super.removeStep(step);
        }
    }

    public void addSubstep(Step parent, String id, Step child) {
        super.addSubstep(parent, child);
        Map<String, Step> subIdMap = this._parentMap.get(parent);
        if (subIdMap == null) {
            subIdMap = new HashMap<String, Step>();
            this._parentMap.put(parent, subIdMap);
        }
        subIdMap.put(id, child);
    }

    public void addSubstep(Step parent, String id, Step child, int index) {
        super.addSubstep(parent, child, index);
        Map<String, Step> subIdMap = this._parentMap.get(parent);
        if (subIdMap == null) {
            subIdMap = new HashMap<String, Step>();
            this._parentMap.put(parent, subIdMap);
        }
        subIdMap.put(id, child);
    }

    public void removeSubstep(Step parent, String childId) {
        Step step;
        Map<String, Step> subIdMap = this._parentMap.get(parent);
        if (subIdMap != null && (step = subIdMap.get(childId)) != null) {
            super.removeSubstep(parent, step);
        }
    }

    @Override
    protected void fireStepRemoved(Step step, int index) {
        super.fireStepRemoved(step, index);
        for (String key : this._idMap.keySet()) {
            if (!this._idMap.get(key).equals(step)) continue;
            this._parentMap.remove(step);
            this._idMap.remove(key);
        }
    }
}

