/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.builders.BreadcrumbsTableBuilder;
import oracle.javatools.ui.builders.BuiltBreadcrumbsTable;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;

class ExAppBreadcrumbTablePanel
extends ExAppBasicPanel {
    private static BuiltBreadcrumbsTable tc;
    private static Model model;

    ExAppBreadcrumbTablePanel() {
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, nogrid, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExAppBreadcrumbTablePanel.this.build();
                }
                catch (UnsupportedOperationException e1) {
                    ExAppBreadcrumbTablePanel.this.updateComponent(new JLabel("Error: See below"));
                    ExAppBreadcrumbTablePanel.this.constructTextArea.setText("Error: " + e1.getMessage());
                    ExAppBreadcrumbTablePanel.this.constructTextArea.setCaretPosition(0);
                    ExAppBreadcrumbTablePanel.this.selectTextArea.setText("");
                }
            }
        });
        JButton dumpButton = new JButton("Dump");
        dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppBreadcrumbTablePanel.this.dump();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split");
        controlPanel.add((Component)buildButton, "wrap");
        return controlPanel;
    }

    private void build() {
        BreadcrumbsTableBuilder<Territory> builder = new BreadcrumbsTableBuilder<Territory>();
        builder.setModel(model);
        builder.setBreadcrumbMaker(new BreadcrumbsTableBuilder.BreadcrumbMaker<Territory>(){

            @Override
            public BreadcrumbsTableBuilder.TableBreadcrumb<Territory> createBreadcrumb(Territory node) {
                return new TerritoryCrumb(node);
            }

            class TerritoryCrumb
            implements BreadcrumbsTableBuilder.TableBreadcrumb<Territory> {
                private Territory t;
                private StyledTextModel name;

                TerritoryCrumb(Territory t) {
                    this.t = t;
                    this.name = new StyledTextModel(t.name);
                }

                @Override
                public boolean hasChildren() {
                    return !this.t.children.isEmpty();
                }

                @Override
                public StyledTextModel getShortName() {
                    return this.name;
                }

                @Override
                public StyledTextModel getLongName() {
                    return this.name;
                }

                @Override
                public Territory getUserObject() {
                    return this.t;
                }
            }
        });
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        this.constructTextArea.setText(createSB.toString());
        this.constructTextArea.setCaretPosition(0);
        this.selectTextArea.setText(selectSB.toString());
        this.selectTextArea.setCaretPosition(0);
        tc = builder.build();
        this.updateComponent(tc.getGUI());
    }

    @Override
    protected void dump() {
    }

    static {
        Territory usa = new Territory("USA", "300,000,000", "Washington D.C.");
        Territory california = new Territory("California", "80,000,000", "Sacramento");
        Territory newyork = new Territory("New York", "23,000,000", "Albany");
        Territory florida = new Territory("Florida", "20,000,000", "Talahassee");
        Territory sanfran = new Territory("San Francisco", "800,000", "SF City Hall");
        Territory la = new Territory("Los Angeles", "10,000,000", "LA City Hall");
        Territory newyorkcity = new Territory("New York City", "8,000,000", "NY City Hall");
        Territory albany = new Territory("Albany", "200,000", "The Capitol");
        Territory miami = new Territory("Miami", "2,000,000", "Miami City Hall");
        Territory disneyworld = new Territory("Disney World", "1,000", "Magic Castle");
        Territory mission = new Territory("Mission", "80,000", "16th and Mission");
        Territory castro = new Territory("Castro", "10,000", "Castro & 18th");
        usa.addChild(california);
        usa.addChild(newyork);
        usa.addChild(florida);
        california.addChild(sanfran);
        california.addChild(la);
        newyork.addChild(newyorkcity);
        newyork.addChild(albany);
        florida.addChild(miami);
        florida.addChild(disneyworld);
        sanfran.addChild(mission);
        sanfran.addChild(castro);
        model = new Model(usa);
    }

    private static class Territory {
        String name;
        String population;
        String capital;
        List<Territory> children = new ArrayList<Territory>();

        public Territory(String name, String population, String capital) {
            this.name = name;
            this.population = population;
            this.capital = capital;
        }

        public void addChild(Territory child) {
            this.children.add(child);
        }
    }

    private static class Model
    extends AbstractTreeTableModel {
        public Model(Territory root) {
            super(root);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Population";
                }
                case 2: {
                    return "Capital";
                }
            }
            return null;
        }

        @Override
        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public Object getValueAt(Object node, int column) {
            Territory t = (Territory)node;
            switch (column) {
                case 0: {
                    return t.name;
                }
                case 1: {
                    return t.population;
                }
                case 2: {
                    return t.capital;
                }
            }
            return null;
        }

        @Override
        public Object getChild(Object parent, int index) {
            Territory t = (Territory)parent;
            return t.children.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            Territory t = (Territory)parent;
            return t.children.size();
        }
    }
}

