/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.builders.BuiltTextField;
import oracle.javatools.ui.builders.TextFieldBuilder;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.search.PromptedTextField;

final class BuiltTextFieldImpl
implements BuiltTextField {
    private JComponent content;
    private JTextField textField;
    private JLabel label;
    private MultiLineLabel hint;

    BuiltTextFieldImpl(TextFieldBuilder.Instructions instructions) {
        if (instructions.expands) {
            this.textField = new ExtendedTextField(false);
        } else if (instructions.completionProvider != null) {
            this.textField = new CompletionTextField();
            CompletionPopupHandler handler = ((CompletionTextField)this.textField).getPopupHandler();
            handler.registerInsightProvider(instructions.completionProvider);
            handler.setAlignWithField(true);
        } else {
            this.textField = new PromptedTextField();
        }
        if (instructions.prompt != null) {
            ((PromptedTextField)this.textField).setPrompt(instructions.prompt);
        }
        this.textField.setText(instructions.text);
        this.textField.setColumns(instructions.columns);
        this.textField.setEditable(instructions.editable);
        this.content = new JPanel((LayoutManager)new MigLayout("ins 0"));
        if (instructions.label != null) {
            String text = StringUtils.stripMnemonic((String)instructions.label);
            if (!text.endsWith(":")) {
                text = text + ":";
            }
            this.label = new JLabel(text);
            int code = StringUtils.getMnemonicKeyCode((String)instructions.label);
            if (code != 0) {
                this.label.setDisplayedMnemonic(code);
            }
            this.label.setLabelFor(this.textField);
            this.textField.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BuiltTextFieldImpl.this.textField.setEnabled(BuiltTextFieldImpl.this.textField.isEnabled());
                }
            });
            this.content.add((Component)this.label, "grow 0, gapright 4");
        }
        this.content.add((Component)this.textField, "wrap");
        if (instructions.hint != null) {
            this.hint = new MultiLineLabel(WordWrapper.getTextWrapper(), instructions.hint);
            this.hint.setForeground(Colors.HINT_TEXT);
            this.hint.setPreferredAspectRatio(10.0f);
            this.textField.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BuiltTextFieldImpl.this.hint.setEnabled(BuiltTextFieldImpl.this.textField.isEnabled());
                }
            });
            if (instructions.label != null) {
                this.content.add(Box.createGlue(), "");
            }
            this.textField.setEnabled(instructions.enabled);
            this.content.add((Component)this.hint, "grow, wrap");
        }
    }

    @Override
    public JComponent getGUI() {
        return this.content;
    }

    @Override
    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    @Override
    public void setEditable(boolean isEditable) {
        this.textField.setEditable(isEditable);
    }

    @Override
    public void setText(String text) {
        this.textField.setText(text);
    }

    @Override
    public String getText() {
        return this.textField.getText();
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }
}

