/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;

final class BreadcrumbsLayout
implements LayoutManager2 {
    private BreadcrumbsModel model;
    private Dimension size;
    private int _currentContentsWidth = 0;
    private static int overlapAmount = 12;

    public BreadcrumbsLayout(BreadcrumbsModel model) {
        this.model = model;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.invalidateLayout(comp.getParent());
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.size = null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.size == null) {
            this.layoutContainer(parent);
        }
        return this.size;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.size == null) {
            this.layoutContainer(parent);
        }
        return this.size;
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        if (this.size == null) {
            this.layoutContainer(parent);
        }
        return this.size;
    }

    @Override
    public void layoutContainer(Container parent) {
        try {
            for (int i = 0; i <= this.model.getBreadcrumbCount(); ++i) {
                if (!this.layoutShorter(parent, i)) continue;
                return;
            }
        }
        finally {
            this.vAlignSeparators(parent);
        }
    }

    private boolean layoutShorter(Container parent, int crumbsToShorten) {
        int x = parent.getInsets().left;
        int y = parent.getInsets().top;
        int h = 0;
        int xGap = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (!(c instanceof BreadcrumbsButton)) continue;
            BreadcrumbsButton bb = (BreadcrumbsButton)c;
            int crumbI = bb.getIndex();
            if (crumbI < this.model.getBreadcrumbCount()) {
                Breadcrumb crumb = this.model.getBreadcrumb(crumbI);
                if (crumbI < crumbsToShorten) {
                    bb.setText(crumb.getShortName());
                } else {
                    bb.setText(crumb.getLongName());
                }
            } else {
                bb.setText("");
            }
            c.setLocation(x, y);
            c.setSize(c.getPreferredSize());
            h = Math.max(h, c.getHeight());
            x += c.getSize().width + xGap - overlapAmount;
        }
        this.size = new Dimension(x += overlapAmount, h += parent.getInsets().top + parent.getInsets().bottom);
        this._currentContentsWidth = x;
        return x < parent.getSize().width;
    }

    public int getCurrentContentsWidth() {
        return this._currentContentsWidth;
    }

    private void vAlignSeparators(Container parent) {
        int y = this.size == null ? 2 : this.size.height / 2;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (i % 2 != 0) continue;
            c.setLocation(c.getX(), y - c.getHeight() / 2);
        }
    }
}

